/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.config;

import net.knarcraft.stargate.config.OptionDataType;

public enum ConfigOption {
    LANGUAGE("language", "The language used for all signs and all messages to players", "en"),
    PORTAL_FOLDER("folders.portalFolder", "The folder containing the portal databases", "plugins/Stargate/portals/"),
    GATE_FOLDER("folders.gateFolder", "The folder containing all gate files", "plugins/Stargate/gates/"),
    MAX_GATES_EACH_NETWORK("gates.maxGatesEachNetwork", "The max number of stargates in a single network", 0),
    DEFAULT_GATE_NETWORK("gates.defaultGateNetwork", "The network used when no network is specified", "central"),
    REMEMBER_DESTINATION("gates.cosmetic.rememberDestination", "Whether to remember the last destination used", false),
    SORT_NETWORK_DESTINATIONS("gates.cosmetic.sortNetworkDestinations", "Whether to sort destinations by name", false),
    MAIN_SIGN_COLOR("gates.cosmetic.mainSignColor", "The main text color of all stargate signs", "BLACK"),
    HIGHLIGHT_SIGN_COLOR("gates.cosmetic.highlightSignColor", "The text color used for highlighting stargate signs", "WHITE"),
    PER_SIGN_COLORS("gates.cosmetic.perSignColors", "The per-sign color specification", new String[]{"'ACACIA:default,default'", "'BIRCH:default,default'", "'CRIMSON:inverted,inverted'", "'DARK_OAK:inverted,inverted'", "'JUNGLE:default,default'", "'OAK:default,default'", "'SPRUCE:inverted,inverted'", "'WARPED:inverted,inverted'"}),
    DESTROYED_BY_EXPLOSION("gates.integrity.destroyedByExplosion", "Whether stargates should be destroyed by explosions", false),
    VERIFY_PORTALS("gates.integrity.verifyPortals", "Whether to verify that portals match their gate layout on load", false),
    PROTECT_ENTRANCE("gates.integrity.protectEntrance", "Whether to protect stargates' entrances", false),
    ENABLE_BUNGEE("gates.functionality.enableBungee", "Whether to enable BungeeCord support", false),
    HANDLE_VEHICLES("gates.functionality.handleVehicles", "Whether to enable vehicle teleportation", true),
    HANDLE_EMPTY_VEHICLES("gates.functionality.handleEmptyVehicles", "Whether to enable teleportation of empty vehicles", true),
    HANDLE_CREATURE_TRANSPORTATION("gates.functionality.handleCreatureTransportation", "Whether to enable teleportation of vehicles containing non-player creatures", true),
    HANDLE_NON_PLAYER_VEHICLES("gates.functionality.handleNonPlayerVehicles", "Whether to enable teleportation of non-empty vehicles without a player", true),
    HANDLE_LEASHED_CREATURES("gates.functionality.handleLeashedCreatures", "Whether to enable players to teleport a creature on a leash", true),
    ENABLE_CRAFT_BOOK_REMOVE_ON_EJECT_FIX("gates.functionality.enableCraftBookRemoveOnEjectFix", "Whether to enable a fix that causes loss of NBT data, but allows vehicle teleportation to work when CraftBook's remove minecart/boat on eject setting is enabled", false),
    WAIT_FOR_PLAYER_AFTER_TELEPORT_DELAY("advanced.waitForPlayerAfterTeleportDelay", "The amount of ticks to wait before adding a player as passenger of a vehicle. On slow servers, a value of 6 is required to avoid client glitches after teleporting on a vehicle.", 6),
    USE_ECONOMY("economy.useEconomy", "Whether to use economy to incur fees when stargates are used, created or destroyed", false),
    CREATE_COST("economy.createCost", "The cost of creating a new stargate", 0),
    DESTROY_COST("economy.destroyCost", "The cost of destroying a stargate. Negative to refund", 0),
    USE_COST("economy.useCost", "The cost of using (teleporting through) a stargate", 0),
    TO_OWNER("economy.toOwner", "Whether any teleportation fees should go to the owner of the used stargate", false),
    CHARGE_FREE_DESTINATION("economy.chargeFreeDestination", "Whether to require payment if the destination is free, but the entrance stargate is not", true),
    FREE_GATES_COLORED("economy.freeGatesColored", "Whether to use coloring to mark all free stargates", false),
    FREE_GATES_COLOR("economy.freeGatesColor", "The color to use for marking free stargates", "DARK_GREEN"),
    DEBUG("debugging.debug", "Whether to enable debugging output", false),
    PERMISSION_DEBUG("debugging.permissionDebug", "Whether to enable permission debugging output", false),
    ADMIN_UPDATE_ALERT("adminUpdateAlert", "Whether to alert admins about new plugin updates", true),
    EXIT_VELOCITY("gates.exitVelocity", "The velocity of players exiting stargates, relative to the entry velocity", 0.1),
    ENABLE_DYNMAP("dynmap.enableDynmap", "Whether to display Stargates in Dynmap's map", true),
    DYNMAP_ICONS_DEFAULT_HIDDEN("dynmap.dynmapIconsHiddenByDefault", "Whether to hide Stargate's Dynmap icons by default, requiring the user to enable them.", true);

    private final String configNode;
    private final String description;
    private final Object defaultValue;
    private final OptionDataType dataType;

    private ConfigOption(String configNode, String description, Object defaultValue) {
        this.configNode = configNode;
        this.description = description;
        this.defaultValue = defaultValue;
        if (defaultValue instanceof String[]) {
            this.dataType = OptionDataType.STRING_LIST;
        } else if (defaultValue instanceof String) {
            this.dataType = OptionDataType.STRING;
        } else if (defaultValue instanceof Boolean) {
            this.dataType = OptionDataType.BOOLEAN;
        } else if (defaultValue instanceof Integer) {
            this.dataType = OptionDataType.INTEGER;
        } else if (defaultValue instanceof Double) {
            this.dataType = OptionDataType.DOUBLE;
        } else {
            throw new IllegalArgumentException("Unknown config data type encountered: " + defaultValue);
        }
    }

    public static ConfigOption getByName(String name) {
        for (ConfigOption option : ConfigOption.values()) {
            if (!option.getName().equalsIgnoreCase(name)) continue;
            return option;
        }
        return null;
    }

    public String getName() {
        if (!this.configNode.contains(".")) {
            return this.configNode;
        }
        String[] pathParts = this.configNode.split("\\.");
        return pathParts[pathParts.length - 1];
    }

    public OptionDataType getDataType() {
        return this.dataType;
    }

    public String getConfigNode() {
        return this.configNode;
    }

    public String getDescription() {
        return this.description;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }
}

