/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.knarcraft.stargate.command.ConfigTabCompleter;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StarGateTabCompleter
implements TabCompleter {
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 1) {
            List<String> commands = this.getAvailableCommands(commandSender);
            ArrayList<String> matchingCommands = new ArrayList<String>();
            for (String availableCommand : commands) {
                if (!availableCommand.startsWith(args[0])) continue;
                matchingCommands.add(availableCommand);
            }
            return matchingCommands;
        }
        if (args.length > 1 && args[0].equalsIgnoreCase("config")) {
            String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
            return new ConfigTabCompleter().onTabComplete(commandSender, command, s, subArgs);
        }
        return new ArrayList<String>();
    }

    private List<String> getAvailableCommands(CommandSender commandSender) {
        Player player;
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("about");
        if (!(commandSender instanceof Player) || (player = (Player)commandSender).hasPermission("stargate.admin.reload")) {
            commands.add("reload");
        }
        if (!(commandSender instanceof Player) || (player = (Player)commandSender).hasPermission("stargate.admin.config")) {
            commands.add("config");
        }
        return commands;
    }
}

