/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.command;

import java.util.ArrayList;
import java.util.List;
import net.knarcraft.stargate.config.ConfigOption;
import net.knarcraft.stargate.config.OptionDataType;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigTabCompleter
implements TabCompleter {
    private List<String> signTypes;
    private List<String> booleans;
    private List<String> integers;
    private List<String> chatColors;
    private List<String> languages;
    private List<String> extendedColors;
    private List<String> doubles;

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (this.signTypes == null || this.booleans == null || this.integers == null || this.chatColors == null || this.languages == null) {
            this.initializeAutoCompleteLists();
        }
        if (args.length > 1) {
            ConfigOption selectedOption = ConfigOption.getByName(args[0]);
            if (selectedOption == null) {
                return new ArrayList<String>();
            }
            if (selectedOption.getDataType() == OptionDataType.STRING_LIST) {
                return this.getPossibleStringListOptionValues(selectedOption, args);
            }
            return this.getPossibleOptionValues(selectedOption, args[1]);
        }
        ArrayList<String> configOptionNames = new ArrayList<String>();
        for (ConfigOption option : ConfigOption.values()) {
            configOptionNames.add(option.getName());
        }
        return this.filterMatching(configOptionNames, args[0]);
    }

    private List<String> filterMatching(List<String> values, String typedText) {
        ArrayList<String> configValues = new ArrayList<String>();
        for (String value : values) {
            if (!value.toLowerCase().startsWith(typedText.toLowerCase())) continue;
            configValues.add(value);
        }
        return configValues;
    }

    private List<String> getPossibleOptionValues(ConfigOption selectedOption, String typedText) {
        switch (selectedOption) {
            case LANGUAGE: {
                return this.filterMatching(this.languages, typedText);
            }
            case GATE_FOLDER: 
            case PORTAL_FOLDER: 
            case DEFAULT_GATE_NETWORK: {
                if (typedText.trim().isEmpty()) {
                    return this.putStringInList((String)selectedOption.getDefaultValue());
                }
                return new ArrayList<String>();
            }
            case MAIN_SIGN_COLOR: 
            case HIGHLIGHT_SIGN_COLOR: 
            case FREE_GATES_COLOR: {
                return this.filterMatching(this.chatColors, typedText);
            }
        }
        if (selectedOption.getDataType() == OptionDataType.BOOLEAN) {
            return this.filterMatching(this.booleans, typedText);
        }
        if (selectedOption.getDataType() == OptionDataType.INTEGER) {
            if (typedText.trim().isEmpty()) {
                return this.integers;
            }
            return new ArrayList<String>();
        }
        if (selectedOption.getDataType() == OptionDataType.DOUBLE) {
            if (typedText.trim().isEmpty()) {
                return this.doubles;
            }
            return new ArrayList<String>();
        }
        return null;
    }

    private List<String> getPossibleStringListOptionValues(ConfigOption selectedOption, String[] args) {
        if (selectedOption == ConfigOption.PER_SIGN_COLORS) {
            return this.getPerSignColorCompletion(args);
        }
        return null;
    }

    private List<String> getPerSignColorCompletion(String[] args) {
        if (args.length < 3) {
            return this.filterMatching(this.signTypes, args[1]);
        }
        if (args.length < 4) {
            return this.filterMatching(this.extendedColors, args[2]);
        }
        if (args.length < 5) {
            return this.filterMatching(this.extendedColors, args[3]);
        }
        return new ArrayList<String>();
    }

    private List<String> putStringInList(String value) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(value);
        return list;
    }

    private void initializeAutoCompleteLists() {
        this.booleans = new ArrayList<String>();
        this.booleans.add("true");
        this.booleans.add("false");
        this.integers = new ArrayList<String>();
        this.integers.add("0");
        this.integers.add("5");
        this.signTypes = new ArrayList<String>();
        for (Material material : Material.values()) {
            if (!Tag.STANDING_SIGNS.isTagged((Keyed)material)) continue;
            this.signTypes.add(material.toString().replace("_SIGN", ""));
        }
        this.getColors();
        this.initializeLanguages();
        this.extendedColors = new ArrayList<String>(this.chatColors);
        this.extendedColors.add("default");
        this.extendedColors.add("inverted");
        this.doubles = new ArrayList<String>();
        this.doubles.add("5");
        this.doubles.add("1");
        this.doubles.add("0.5");
        this.doubles.add("0.1");
    }

    private void getColors() {
        this.chatColors = new ArrayList<String>();
        for (ChatColor color : this.getChatColors()) {
            this.chatColors.add(color.getName());
        }
    }

    private List<ChatColor> getChatColors() {
        char[] colors;
        ArrayList<ChatColor> chatColors = new ArrayList<ChatColor>();
        for (char color : colors = new char[]{'a', 'b', 'c', 'd', 'e', 'f', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'}) {
            chatColors.add(ChatColor.getByChar((char)color));
        }
        chatColors.add(ChatColor.of((String)"#ed76d9"));
        chatColors.add(ChatColor.of((String)"#ffecb7"));
        return chatColors;
    }

    private void initializeLanguages() {
        this.languages = new ArrayList<String>();
        this.languages.add("de");
        this.languages.add("en");
        this.languages.add("es");
        this.languages.add("fr");
        this.languages.add("hu");
        this.languages.add("it");
        this.languages.add("ja");
        this.languages.add("nb-no");
        this.languages.add("nl");
        this.languages.add("nn-no");
        this.languages.add("pt-br");
        this.languages.add("ru");
        this.languages.add("zh_cn");
    }
}

