/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate.command;

import java.util.ArrayList;
import java.util.List;
import net.knarcraft.stargate.Stargate;
import net.knarcraft.stargate.config.ConfigOption;
import net.knarcraft.stargate.config.ConfigTag;
import net.knarcraft.stargate.config.DynmapManager;
import net.knarcraft.stargate.config.OptionDataType;
import net.knarcraft.stargate.portal.Portal;
import net.knarcraft.stargate.portal.PortalRegistry;
import net.knarcraft.stargate.portal.PortalSignDrawer;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class CommandConfig
implements CommandExecutor {
    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        Player player;
        if (commandSender instanceof Player && !(player = (Player)commandSender).hasPermission("stargate.admin.config")) {
            Stargate.getMessageSender().sendErrorMessage(commandSender, "Permission Denied");
            return true;
        }
        if (args.length > 0) {
            ConfigOption selectedOption = ConfigOption.getByName(args[0]);
            if (selectedOption == null) {
                return false;
            }
            if (args.length > 1) {
                if (selectedOption.getDataType() == OptionDataType.STRING_LIST) {
                    this.updateListConfigValue(selectedOption, commandSender, args);
                } else {
                    this.updateConfigValue(selectedOption, commandSender, args[1]);
                }
            } else {
                this.printConfigOptionValue(commandSender, selectedOption);
            }
            return true;
        }
        this.displayConfigValues(commandSender);
        return true;
    }

    private void updateConfigValue(ConfigOption selectedOption, CommandSender commandSender, String value) {
        FileConfiguration configuration = Stargate.getInstance().getConfig();
        if (ConfigTag.COLOR.isTagged(selectedOption)) {
            try {
                ChatColor.of((String)value.toUpperCase());
            }
            catch (IllegalArgumentException | NullPointerException ignored) {
                commandSender.sendMessage(ChatColor.RED + "Invalid color given");
                return;
            }
        }
        switch (selectedOption.getDataType()) {
            case BOOLEAN: {
                this.updateBooleanConfigValue(selectedOption, value, configuration);
                break;
            }
            case INTEGER: {
                Integer intValue = this.getInteger(commandSender, selectedOption, value);
                if (intValue == null) {
                    return;
                }
                Stargate.getStargateConfig().getConfigOptionsReference().put(selectedOption, intValue);
                configuration.set(selectedOption.getConfigNode(), (Object)intValue);
                break;
            }
            case DOUBLE: {
                Double doubleValue = this.getDouble(commandSender, selectedOption, value);
                if (doubleValue == null) {
                    return;
                }
                Stargate.getStargateConfig().getConfigOptionsReference().put(selectedOption, doubleValue);
                configuration.set(selectedOption.getConfigNode(), (Object)doubleValue);
                break;
            }
            case STRING: {
                this.updateStringConfigValue(selectedOption, commandSender, value);
                configuration.set(selectedOption.getConfigNode(), (Object)value);
                break;
            }
            default: {
                Stargate.getStargateConfig().getConfigOptionsReference().put(selectedOption, value);
                configuration.set(selectedOption.getConfigNode(), (Object)value);
            }
        }
        this.saveAndReload(selectedOption, commandSender);
    }

    private void updateBooleanConfigValue(ConfigOption selectedOption, String value, FileConfiguration configuration) {
        boolean newValue = Boolean.parseBoolean(value);
        if (selectedOption == ConfigOption.ENABLE_BUNGEE && newValue != Stargate.getGateConfig().enableBungee()) {
            Stargate.getStargateConfig().startStopBungeeListener(newValue);
        }
        Stargate.getStargateConfig().getConfigOptionsReference().put(selectedOption, newValue);
        configuration.set(selectedOption.getConfigNode(), (Object)newValue);
    }

    private void updateStringConfigValue(ConfigOption selectedOption, CommandSender commandSender, String value) {
        if ((selectedOption == ConfigOption.GATE_FOLDER || selectedOption == ConfigOption.PORTAL_FOLDER || selectedOption == ConfigOption.DEFAULT_GATE_NETWORK) && (value.contains("../") || value.contains("..\\"))) {
            commandSender.sendMessage(ChatColor.RED + "Path traversal characters cannot be used");
            return;
        }
        if (ConfigTag.COLOR.isTagged(selectedOption) && !this.registerColor(selectedOption, value, commandSender)) {
            return;
        }
        if (selectedOption == ConfigOption.LANGUAGE) {
            Stargate.getStargateConfig().getLanguageLoader().setChosenLanguage(value);
        }
        Stargate.getStargateConfig().getConfigOptionsReference().put(selectedOption, value);
    }

    private void updateListConfigValue(ConfigOption selectedOption, CommandSender commandSender, String[] arguments) {
        FileConfiguration configuration = Stargate.getInstance().getConfig();
        if (selectedOption == ConfigOption.PER_SIGN_COLORS) {
            if (arguments.length < 4) {
                Stargate.getMessageSender().sendErrorMessage(commandSender, "Usage: /sg config perSignColors <SIGN_TYPE> <MAIN_COLOR> <HIGHLIGHTING_COLOR>");
                return;
            }
            String colorString = this.parsePerSignColorInput(commandSender, arguments);
            if (colorString == null) {
                return;
            }
            this.updatePerSignColors(arguments[1], colorString, configuration);
        }
        this.saveAndReload(selectedOption, commandSender);
    }

    private String parsePerSignColorInput(CommandSender commandSender, String[] arguments) {
        if (Material.matchMaterial((String)(arguments[1] + "_SIGN")) == null) {
            Stargate.getMessageSender().sendErrorMessage(commandSender, "The given sign type is invalid");
            return null;
        }
        String colorString = arguments[1] + ":";
        String[] errorMessage = new String[]{"The given main sign color is invalid!", "The given highlight sign color is invalid!"};
        CharSequence[] newColors = new String[2];
        for (int i = 0; i < 2; ++i) {
            if (!this.validatePerSignColor(arguments[i + 2])) {
                Stargate.getMessageSender().sendErrorMessage(commandSender, errorMessage[i]);
                return null;
            }
            newColors[i] = arguments[i + 2];
        }
        colorString = colorString + String.join((CharSequence)",", newColors);
        return colorString;
    }

    private void updatePerSignColors(String signType, String colorString, FileConfiguration configuration) {
        ArrayList<String> newColorStrings = new ArrayList<String>();
        List oldColors = (List)Stargate.getStargateConfig().getConfigOptionsReference().get((Object)ConfigOption.PER_SIGN_COLORS);
        for (Object object : oldColors) {
            newColorStrings.add(String.valueOf(object));
        }
        newColorStrings.removeIf(item -> item.startsWith(signType));
        newColorStrings.add(colorString);
        Stargate.getStargateConfig().getConfigOptionsReference().put(ConfigOption.PER_SIGN_COLORS, newColorStrings);
        configuration.set(ConfigOption.PER_SIGN_COLORS.getConfigNode(), newColorStrings);
    }

    private boolean validatePerSignColor(String color) {
        ChatColor newHighlightColor = this.parseColor(color);
        return newHighlightColor != null || color.equalsIgnoreCase("default") || color.equalsIgnoreCase("inverted");
    }

    private void saveAndReload(ConfigOption selectedOption, CommandSender commandSender) {
        Stargate.getInstance().saveConfig();
        Stargate.getMessageSender().sendSuccessMessage(commandSender, "Config updated");
        this.reloadIfNecessary(commandSender, selectedOption);
    }

    private boolean registerColor(ConfigOption selectedOption, String value, CommandSender commandSender) {
        ChatColor parsedColor = this.parseColor(value);
        if (parsedColor == null) {
            commandSender.sendMessage(ChatColor.RED + "Invalid color given");
            return false;
        }
        if (selectedOption == ConfigOption.FREE_GATES_COLOR) {
            PortalSignDrawer.setFreeColor(parsedColor);
        } else if (selectedOption == ConfigOption.MAIN_SIGN_COLOR) {
            PortalSignDrawer.setMainColor(parsedColor);
        } else if (selectedOption == ConfigOption.HIGHLIGHT_SIGN_COLOR) {
            PortalSignDrawer.setHighlightColor(parsedColor);
        }
        return true;
    }

    private ChatColor parseColor(String value) {
        try {
            return ChatColor.of((String)value.toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException ignored) {
            return null;
        }
    }

    private Integer getInteger(CommandSender commandSender, ConfigOption selectedOption, String value) {
        try {
            int intValue = Integer.parseInt(value);
            if ((selectedOption == ConfigOption.USE_COST || selectedOption == ConfigOption.CREATE_COST) && intValue < 0) {
                commandSender.sendMessage(ChatColor.RED + "This config option cannot be negative.");
                return null;
            }
            return intValue;
        }
        catch (NumberFormatException exception) {
            commandSender.sendMessage(ChatColor.RED + "Invalid number given");
            return null;
        }
    }

    private Double getDouble(CommandSender commandSender, ConfigOption selectedOption, String value) {
        try {
            double doubleValue = Double.parseDouble(value);
            if (selectedOption == ConfigOption.EXIT_VELOCITY && doubleValue < 0.0) {
                commandSender.sendMessage(ChatColor.RED + "This config option cannot be negative.");
                return null;
            }
            return doubleValue;
        }
        catch (NumberFormatException exception) {
            commandSender.sendMessage(ChatColor.RED + "Invalid number given");
            return null;
        }
    }

    private void reloadIfNecessary(CommandSender commandSender, ConfigOption configOption) {
        if (ConfigTag.requiresFullReload(configOption)) {
            Stargate.getStargateConfig().reload(commandSender);
        } else {
            if (ConfigTag.requiresColorReload(configOption)) {
                Stargate.getStargateConfig().getStargateGateConfig().loadPerSignColors();
            }
            if (ConfigTag.requiresPortalReload(configOption)) {
                Stargate.getStargateConfig().unloadAllPortals();
                Stargate.getStargateConfig().loadAllPortals();
            }
            if (ConfigTag.requiresLanguageReload(configOption)) {
                Stargate.getStargateConfig().getLanguageLoader().reload();
                for (Portal portal : PortalRegistry.getAllPortals()) {
                    portal.drawSign();
                }
            }
            if (ConfigTag.requiresEconomyReload(configOption)) {
                Stargate.getStargateConfig().reloadEconomy();
            }
            if (ConfigTag.requiresDynmapReload(configOption)) {
                DynmapManager.addAllPortalMarkers();
            }
        }
    }

    private void printConfigOptionValue(CommandSender sender, ConfigOption option) {
        Object value = Stargate.getStargateConfig().getConfigOptions().get((Object)option);
        sender.sendMessage(this.getOptionDescription(option));
        sender.sendMessage(ChatColor.GREEN + "Current value: " + ChatColor.GOLD + value);
    }

    private void displayConfigValues(CommandSender sender) {
        sender.sendMessage(ChatColor.GREEN + Stargate.getBackupString("prefix") + ChatColor.GOLD + "Config values:");
        for (ConfigOption option : ConfigOption.values()) {
            sender.sendMessage(this.getOptionDescription(option));
        }
    }

    private String getOptionDescription(ConfigOption option) {
        Object defaultValue = option.getDefaultValue();
        Object stringValue = String.valueOf(defaultValue);
        if (option.getDataType() == OptionDataType.STRING_LIST) {
            stringValue = "[" + String.join((CharSequence)",", (String[])defaultValue) + "]";
        }
        return ChatColor.GOLD + option.getName() + ChatColor.WHITE + " - " + ChatColor.GREEN + option.getDescription() + ChatColor.DARK_GRAY + " (Default: " + ChatColor.GRAY + (String)stringValue + ChatColor.DARK_GRAY + ")";
    }
}

