/*
 * Decompiled with CFR 0.152.
 */
package net.knarcraft.stargate;

import java.io.File;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.knarcraft.stargate.command.CommandStarGate;
import net.knarcraft.stargate.command.StarGateTabCompleter;
import net.knarcraft.stargate.config.EconomyConfig;
import net.knarcraft.stargate.config.MessageSender;
import net.knarcraft.stargate.config.StargateConfig;
import net.knarcraft.stargate.config.StargateGateConfig;
import net.knarcraft.stargate.container.BlockChangeRequest;
import net.knarcraft.stargate.container.ChunkUnloadRequest;
import net.knarcraft.stargate.listener.BlockEventListener;
import net.knarcraft.stargate.listener.EntityEventListener;
import net.knarcraft.stargate.listener.EntitySpawnListener;
import net.knarcraft.stargate.listener.PlayerEventListener;
import net.knarcraft.stargate.listener.PluginEventListener;
import net.knarcraft.stargate.listener.PortalEventListener;
import net.knarcraft.stargate.listener.TeleportEventListener;
import net.knarcraft.stargate.listener.VehicleEventListener;
import net.knarcraft.stargate.listener.WorldEventListener;
import net.knarcraft.stargate.portal.PortalHandler;
import net.knarcraft.stargate.portal.PortalRegistry;
import net.knarcraft.stargate.thread.BlockChangeThread;
import net.knarcraft.stargate.thread.ChunkUnloadThread;
import net.knarcraft.stargate.thread.StarGateThread;
import net.knarcraft.stargate.utility.UpdateChecker;
import org.bukkit.Server;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.scheduler.BukkitScheduler;

public class Stargate
extends JavaPlugin {
    private static final Queue<BlockChangeRequest> blockChangeRequestQueue = new LinkedList<BlockChangeRequest>();
    private static final Queue<ChunkUnloadRequest> chunkUnloadQueue = new PriorityQueue<ChunkUnloadRequest>();
    private static Logger logger;
    private static Stargate stargate;
    private static String pluginVersion;
    private static PluginManager pluginManager;
    private static StargateConfig stargateConfig;
    private static String updateAvailable;

    public Stargate() {
    }

    protected Stargate(JavaPluginLoader loader, PluginDescriptionFile descriptionFile, File dataFolder, File file) {
        super(loader, descriptionFile, dataFolder, file);
    }

    public static void setUpdateAvailable(String version) {
        updateAvailable = version;
    }

    public static String getUpdateAvailable() {
        return updateAvailable;
    }

    public static Stargate getInstance() {
        return stargate;
    }

    public static void addBlockChangeRequest(BlockChangeRequest request) {
        if (request != null) {
            blockChangeRequestQueue.add(request);
        }
    }

    public static Queue<BlockChangeRequest> getBlockChangeRequestQueue() {
        return blockChangeRequestQueue;
    }

    public static MessageSender getMessageSender() {
        return stargateConfig.getMessageSender();
    }

    public static StargateGateConfig getGateConfig() {
        return stargateConfig.getStargateGateConfig();
    }

    public static String getPluginVersion() {
        return pluginVersion;
    }

    public static Logger getConsoleLogger() {
        return logger;
    }

    public static int getMaxNameNetworkLength() {
        return 13;
    }

    public static void debug(String route, String message) {
        if (stargateConfig == null || stargateConfig.isDebuggingEnabled()) {
            logger.info("[Stargate::" + route + "] " + message);
        } else {
            logger.log(Level.FINEST, "[Stargate::" + route + "] " + message);
        }
    }

    public static void logInfo(String message) {
        logger.info(Stargate.getBackupString("prefix") + message);
    }

    public static void logSevere(String message) {
        Stargate.log(Level.SEVERE, message);
    }

    public static void logWarning(String message) {
        Stargate.log(Level.WARNING, message);
    }

    private static void log(Level severity, String message) {
        logger.log(severity, Stargate.getBackupString("prefix") + message);
    }

    public static String getPortalFolder() {
        return stargateConfig.getPortalFolder();
    }

    public static String getGateFolder() {
        return stargateConfig.getGateFolder();
    }

    public static String getDefaultNetwork() {
        return stargateConfig.getStargateGateConfig().getDefaultPortalNetwork();
    }

    public static String getString(String name) {
        return stargateConfig.getLanguageLoader().getString(name);
    }

    public static String getBackupString(String name) {
        return stargateConfig.getLanguageLoader().getBackupString(name);
    }

    public static String replaceVars(String input, String[] search, String[] values) {
        if (search.length != values.length) {
            throw new IllegalArgumentException("The number of search values and replace values do not match.");
        }
        for (int i = 0; i < search.length; ++i) {
            input = Stargate.replaceVars(input, search[i], values[i]);
        }
        return input;
    }

    public static String replaceVars(String input, String search, String value) {
        return input.replace(search, value);
    }

    public static PluginManager getPluginManager() {
        return pluginManager;
    }

    public static EconomyConfig getEconomyConfig() {
        return stargateConfig.getEconomyConfig();
    }

    public void onDisable() {
        PortalHandler.closeAllPortals();
        PortalRegistry.clearPortals();
        stargateConfig.clearManagedWorlds();
        this.getServer().getScheduler().cancelTasks((Plugin)this);
    }

    public void onEnable() {
        PluginDescriptionFile pluginDescriptionFile = this.getDescription();
        pluginManager = this.getServer().getPluginManager();
        FileConfiguration newConfig = this.getConfig();
        this.saveDefaultConfig();
        newConfig.options().copyDefaults(true);
        logger = Logger.getLogger("Minecraft");
        Server server = this.getServer();
        stargate = this;
        stargateConfig = new StargateConfig(logger);
        stargateConfig.finishSetup();
        pluginVersion = pluginDescriptionFile.getVersion();
        logger.info(pluginDescriptionFile.getName() + " v." + pluginDescriptionFile.getVersion() + " is enabled.");
        this.registerEventListeners();
        this.runThreads();
        this.registerCommands();
        UpdateChecker.checkForUpdate();
    }

    private void runThreads() {
        BukkitScheduler scheduler = this.getServer().getScheduler();
        scheduler.runTaskTimer((Plugin)this, (Runnable)new StarGateThread(), 0L, 100L);
        scheduler.runTaskTimer((Plugin)this, (Runnable)new BlockChangeThread(), 0L, 1L);
        scheduler.runTaskTimer((Plugin)this, (Runnable)new ChunkUnloadThread(), 0L, 100L);
    }

    private void registerEventListeners() {
        pluginManager.registerEvents((Listener)new PlayerEventListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new BlockEventListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new VehicleEventListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new EntityEventListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new PortalEventListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new WorldEventListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new PluginEventListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new TeleportEventListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new EntitySpawnListener(), (Plugin)this);
    }

    private void registerCommands() {
        PluginCommand stargateCommand = this.getCommand("stargate");
        if (stargateCommand != null) {
            stargateCommand.setExecutor((CommandExecutor)new CommandStarGate());
            stargateCommand.setTabCompleter((TabCompleter)new StarGateTabCompleter());
        }
    }

    public static Queue<ChunkUnloadRequest> getChunkUnloadQueue() {
        return chunkUnloadQueue;
    }

    public static void addChunkUnloadRequest(ChunkUnloadRequest request) {
        chunkUnloadQueue.removeIf(item -> item.getChunkToUnload().equals(request.getChunkToUnload()));
        chunkUnloadQueue.add(request);
    }

    public static StargateConfig getStargateConfig() {
        return stargateConfig;
    }

    static {
        updateAvailable = null;
    }
}

