/*
 * Decompiled with CFR 0.152.
 */
package net.melion.rgbchat.chat;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.melion.rgbchat.chat.TextColor;

public final class RGBUtils {
    public static final RGBUtils INSTANCE = new RGBUtils();
    private final Pattern hex = Pattern.compile("#[0-9a-fA-F]{6}");
    private final Pattern fix2 = Pattern.compile("\\{#[0-9a-fA-F]{6}\\}");
    private final Pattern fix3 = Pattern.compile("\\&x[\\&0-9a-fA-F]{12}");
    private final Pattern gradient1 = Pattern.compile("<#[0-9a-fA-F]{6}>[^<]*</#[0-9a-fA-F]{6}>");
    private final Pattern gradient2 = Pattern.compile("\\{#[0-9a-fA-F]{6}>\\}[^\\{]*\\{#[0-9a-fA-F]{6}<\\}");

    private RGBUtils() {
    }

    private String toChatColor(String hexCode) {
        StringBuilder magic = new StringBuilder("\u00a7x");
        for (char c : hexCode.substring(1).toCharArray()) {
            magic.append('\u00a7').append(c);
        }
        return magic.toString();
    }

    private String toHexString(int red, int green, int blue) {
        StringBuilder sb = new StringBuilder(Integer.toHexString((red << 16) + (green << 8) + blue));
        while (sb.length() < 6) {
            sb.insert(0, "0");
        }
        return sb.toString();
    }

    private String applyFormats(String textInput) {
        textInput = this.fixFormat1(textInput);
        textInput = this.fixFormat2(textInput);
        textInput = this.fixFormat3(textInput);
        textInput = this.setGradient1(textInput);
        textInput = this.setGradient2(textInput);
        return textInput;
    }

    public String toChatColorString(String textInput) {
        textInput = this.applyFormats(textInput);
        Matcher m = this.hex.matcher(textInput);
        while (m.find()) {
            String hexCode = m.group();
            textInput = textInput.replace(hexCode, this.toChatColor(hexCode));
        }
        return textInput;
    }

    private String fixFormat1(String text) {
        return text.replace("&#", "#");
    }

    private String fixFormat2(String input) {
        Matcher m = this.fix2.matcher(input);
        while (m.find()) {
            String hexcode = m.group();
            input = input.replace(hexcode, "#" + hexcode.substring(2, 8));
        }
        return input;
    }

    private String fixFormat3(String text) {
        text = text.replace('\u00a7', '&');
        Matcher m = this.fix3.matcher(text);
        while (m.find()) {
            String hexcode = m.group();
            StringBuilder fixed = new StringBuilder("#");
            fixed.append(hexcode.charAt(3));
            fixed.append(hexcode.charAt(5));
            fixed.append(hexcode.charAt(7));
            fixed.append(hexcode.charAt(9));
            fixed.append(hexcode.charAt(11));
            fixed.append(hexcode.charAt(13));
            text = text.replace(hexcode, fixed);
        }
        return text;
    }

    private String setGradient1(String input) {
        Matcher m = this.gradient1.matcher(input);
        while (m.find()) {
            String format = m.group();
            TextColor start = new TextColor(format.substring(2, 8));
            String message = format.substring(9, format.length() - 10);
            TextColor end = new TextColor(format.substring(format.length() - 7, format.length() - 1));
            input = input.replace(format, this.asGradient(start, message, end));
        }
        return input;
    }

    private String setGradient2(String input) {
        Matcher m = this.gradient2.matcher(input);
        while (m.find()) {
            String format = m.group();
            int length = format.length();
            TextColor start = new TextColor(format.substring(2, 8));
            String message = format.substring(10, length - 10);
            TextColor end = new TextColor(format.substring(length - 8, length - 2));
            input = input.replace(format, this.asGradient(start, message, end));
        }
        return input;
    }

    private String asGradient(TextColor start, String text, TextColor end) {
        StringBuilder sb = new StringBuilder();
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            int red = (int)((float)start.red + (float)(end.red - start.red) / (float)(length - 1) * (float)i);
            int green = (int)((float)start.green + (float)(end.green - start.green) / (float)(length - 1) * (float)i);
            int blue = (int)((float)start.blue + (float)(end.blue - start.blue) / (float)(length - 1) * (float)i);
            sb.append("#").append(this.toHexString(red, green, blue)).append(text.charAt(i));
        }
        return sb.toString();
    }
}

