/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.templates;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class TextProcessing {
    private static final AtomicReference<InternalColorProcessor> INTERNAL_COLOR_PROCESSOR = new AtomicReference();

    @Contract(value="null -> null")
    public static String translateColor(String text) {
        if (text == null) {
            return null;
        }
        return INTERNAL_COLOR_PROCESSOR.updateAndGet(i -> {
            if (i != null) {
                return i;
            }
            return new InternalColorProcessor();
        }).process(text);
    }

    public static String[] splitAtNewline(String text) {
        if (text == null) {
            return new String[0];
        }
        return text.split("\\n|\\\\n");
    }

    static class InternalColorProcessor {
        static final Pattern HEX_PATTERN = Pattern.compile("&(#(\\d|[A-F]|[a-f]){6})");
        static final Pattern VERSION_TEST = Pattern.compile("MC: (?:1\\.(?:1[6-9]\\d*|2\\d+)|[2-9]\\.\\d+)\\.?");
        final boolean doesHex = VERSION_TEST.matcher(Bukkit.getVersion()).find();
        final boolean isSpigot = InternalColorProcessor.checkIsSpigot();

        InternalColorProcessor() {
        }

        @NotNull
        String process(@NotNull String text) {
            Matcher matcher;
            if (this.isSpigot && this.doesHex) {
                Matcher matcher2;
                if (text.contains("&#") && (matcher2 = HEX_PATTERN.matcher(text)).find()) {
                    text = InternalColorProcessor.processHex(matcher2, this::processHexBungeeLib);
                }
            } else if (this.doesHex && text.contains("&#") && (matcher = HEX_PATTERN.matcher(text)).find()) {
                text = InternalColorProcessor.processHex(matcher, this::processHexCustom);
            }
            return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
        }

        private static String processHex(Matcher matcher, UnaryOperator<String> colorFunction) {
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, (String)colorFunction.apply(matcher.group(1)));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }

        private String processHexBungeeLib(String hexCode) {
            return net.md_5.bungee.api.ChatColor.of((String)hexCode).toString();
        }

        private String processHexCustom(String hexCode) {
            StringBuilder sb = new StringBuilder("\u00a7x");
            for (int i = 1; i < hexCode.length(); ++i) {
                sb.append('\u00a7').append(hexCode.charAt(i));
            }
            return sb.toString();
        }

        private static boolean checkIsSpigot() {
            for (Class<?> declaredClass : Bukkit.getServer().getClass().getDeclaredClasses()) {
                if (!declaredClass.getSimpleName().equals("Spigot")) continue;
                return true;
            }
            return false;
        }
    }
}

