/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.templates;

import com.github.sanctum.templates.SimpleTemplate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SerializableAs(value="SanctumTemplate")
@DelegateDeserialization(value=SimpleTemplate.class)
public interface Template
extends ConfigurationSerializable {
    public static final String NAME_PLACEHOLDER = "%original_name%";
    public static final String LORE_PLACEHOLDER = "%original_lore%";
    public static final Template EMPTY = new SimpleTemplate(null, null, null, null, null, null);

    @NotNull
    public Optional<String> getName();

    @Nullable
    public String rawNameTransform();

    default public boolean colorName() {
        return true;
    }

    @NotNull
    public Optional<List<String>> getLore();

    @Nullable
    public String rawLoreTransform();

    default public boolean colorLore() {
        return true;
    }

    @NotNull
    public Optional<Integer> getCount();

    @NotNull
    public Optional<Map<Enchantment, Integer>> getEnchantments();

    @NotNull
    public Optional<List<ItemFlag>> getItemFlagsToAdd();

    @NotNull
    public Optional<List<ItemFlag>> getItemFlagsToRemove();

    @NotNull
    default public ItemStack produce(@NotNull Material material) {
        return this.produce(() -> new ItemStack(material));
    }

    @NotNull
    default public ItemStack produce(@NotNull ItemStack original) {
        return this.produce(() -> new ItemStack(original));
    }

    @NotNull
    default public ItemStack produce(@NotNull @NotNull Supplier<@NotNull ItemStack> supplier) {
        ItemStack toStyle = supplier.get();
        this.getCount().ifPresent(arg_0 -> ((ItemStack)toStyle).setAmount(arg_0));
        ItemMeta meta = toStyle.getItemMeta();
        if (meta == null) {
            throw new IllegalStateException();
        }
        this.getName().ifPresent(newName -> {
            if (!newName.contains(NAME_PLACEHOLDER)) {
                meta.setDisplayName(newName);
                return;
            }
            meta.setDisplayName(newName.replace(NAME_PLACEHOLDER, Optional.of(meta).filter(ItemMeta::hasDisplayName).map(ItemMeta::getDisplayName).orElse("")));
        });
        this.getLore().ifPresent(newLore -> {
            if (newLore.stream().noneMatch(str -> str.contains(LORE_PLACEHOLDER))) {
                meta.setLore(newLore);
                return;
            }
            ImmutableList.Builder finalLore = ImmutableList.builder();
            for (String line : newLore) {
                if (!line.contains(LORE_PLACEHOLDER)) {
                    finalLore.add((Object)line);
                    continue;
                }
                List originalLore = meta.getLore();
                if (line.equals(LORE_PLACEHOLDER) && originalLore != null) {
                    originalLore.forEach(arg_0 -> ((ImmutableList.Builder)finalLore).add(arg_0));
                    continue;
                }
                String[] split = line.split(LORE_PLACEHOLDER, 0);
                for (int i = 0; i < split.length; ++i) {
                    if (i > 0 && originalLore != null) {
                        finalLore.addAll((Iterable)originalLore);
                    }
                    finalLore.add((Object)split[i]);
                }
            }
            meta.setLore((List)finalLore.build());
        });
        this.getEnchantments().ifPresent(map -> map.forEach((enchantment, level) -> meta.addEnchant(enchantment, level.intValue(), true)));
        this.getItemFlagsToAdd().ifPresent(list -> list.forEach(xva$0 -> meta.addItemFlags(new ItemFlag[]{xva$0})));
        this.getItemFlagsToRemove().ifPresent(list -> list.forEach(xva$0 -> meta.removeItemFlags(new ItemFlag[]{xva$0})));
        toStyle.setItemMeta(meta);
        return toStyle;
    }

    @NotNull
    default public Map<String, Object> serialize() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.getName().ifPresent(name -> builder.put((Object)"name", name));
        this.getLore().map(list -> String.join((CharSequence)"\n", list)).ifPresent(lore -> builder.put((Object)"lore", lore));
        this.getEnchantments().filter(map -> !map.isEmpty()).ifPresent(enchants -> enchants.forEach((enchantment, value) -> {
            NamespacedKey key = enchantment.getKey();
            builder.put((Object)(key.getNamespace().equals("minecraft") ? key.getKey() : key.toString()), value);
        }));
        this.getItemFlagsToAdd().filter(list -> !list.isEmpty()).ifPresent(flags -> {
            ImmutableList.Builder flagList = ImmutableList.builder();
            flags.forEach(itemFlag -> flagList.add((Object)itemFlag.name()));
            builder.put((Object)"flags", (Object)flagList);
        });
        this.getItemFlagsToRemove().filter(list -> !list.isEmpty()).ifPresent(removeFlags -> {
            ImmutableList.Builder removeFlagList = ImmutableList.builder();
            removeFlags.forEach(itemFlag -> removeFlagList.add((Object)itemFlag.name()));
            builder.put((Object)"remove-flags", (Object)removeFlagList);
        });
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String lore;
        private Integer count = null;
        private Map<String, Integer> enchantments;
        private List<ItemFlag> flags;
        private List<ItemFlag> removeFlags;
        private boolean skipColorName;
        private boolean skipColorLore;

        @Nullable
        public String getName() {
            return this.name;
        }

        public Builder setName(@Nullable String name) {
            this.name = name;
            return this;
        }

        public Builder transformName(Function<@Nullable String, @Nullable String> processing) {
            return this.setName(processing.apply(this.getName()));
        }

        public Builder skipColorName(boolean skip) {
            this.skipColorName = skip;
            return this;
        }

        @Nullable
        public String getLore() {
            return this.lore;
        }

        public Builder setLore(@Nullable String lore) {
            this.lore = lore;
            return this;
        }

        public Builder transformLore(Function<@Nullable String, @Nullable String> processing) {
            return this.setLore(processing.apply(this.getLore()));
        }

        public Builder skipColorLore(boolean skip) {
            this.skipColorLore = skip;
            return this;
        }

        @Nullable
        public Integer getCount() {
            return this.count;
        }

        public Builder setCount(@Nullable Integer count) {
            this.count = count;
            return this;
        }

        public Builder setEnchantments(@Nullable Map<String, Integer> enchantments) {
            this.enchantments = enchantments == null ? null : ImmutableMap.copyOf(enchantments);
            return this;
        }

        public Builder setItemFlagsToAdd(@Nullable List<ItemFlag> flagsToAdd) {
            this.flags = flagsToAdd == null ? null : ImmutableList.copyOf(flagsToAdd);
            return this;
        }

        public Builder setItemFlagsToRemove(@Nullable List<ItemFlag> flagsToRemove) {
            this.removeFlags = flagsToRemove == null ? null : ImmutableList.copyOf(flagsToRemove);
            return this;
        }

        public Template build() throws IllegalArgumentException {
            return new SimpleTemplate(this.name, this.lore, this.count, this.enchantments, this.flags, this.removeFlags, this.skipColorName, this.skipColorLore);
        }

        public Builder copy() {
            Builder copy = new Builder();
            copy.name = this.name;
            copy.lore = this.lore;
            copy.count = this.count;
            copy.enchantments = this.enchantments;
            copy.flags = this.flags;
            copy.removeFlags = this.removeFlags;
            copy.skipColorName = this.skipColorName;
            copy.skipColorLore = this.skipColorLore;
            return copy;
        }
    }
}

