/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.skulls;

import com.github.sanctum.skulls.CustomHeadLoader;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class HeadLookup {
    protected String name = null;
    protected String id = null;
    protected String value = null;

    public HeadLookup(String name) {
        this.name = name;
        try {
            Gson g = new Gson();
            String signature = this.getNonSessionContent(name);
            JsonObject obj = (JsonObject)g.fromJson(signature, JsonObject.class);
            this.id = obj.get("id").toString().replace("\"", "");
            String sessionContent = this.getSessionContent(this.id);
            obj = (JsonObject)g.fromJson(sessionContent, JsonObject.class);
            String value = obj.getAsJsonArray("properties").get(0).getAsJsonObject().get("value").getAsString();
            String decoded = new String(Base64.getDecoder().decode(value));
            obj = (JsonObject)g.fromJson(decoded, JsonObject.class);
            String skinURL = obj.getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
            byte[] skinByte = ("{\"textures\":{\"SKIN\":{\"url\":\"" + skinURL + "\"}}}").getBytes();
            this.value = new String(Base64.getEncoder().encode(skinByte));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public HeadLookup(UUID id) {
        try {
            Gson g = new Gson();
            String signature = this.getSessionContent(id.toString());
            JsonObject obj = (JsonObject)g.fromJson(signature, JsonObject.class);
            this.id = obj.get("id").toString().replace("\"", "");
            this.name = obj.get("name").toString().replace("\"", "");
            String value = obj.getAsJsonArray("properties").get(0).getAsJsonObject().get("value").getAsString();
            String decoded = new String(Base64.getDecoder().decode(value));
            obj = (JsonObject)g.fromJson(decoded, JsonObject.class);
            String skinURL = obj.getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
            byte[] skinByte = ("{\"textures\":{\"SKIN\":{\"url\":\"" + skinURL + "\"}}}").getBytes();
            this.value = new String(Base64.getEncoder().encode(skinByte));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    public UUID getUUID() {
        return this.id != null ? UUID.fromString(this.id) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSessionContent(String string) {
        BufferedReader in = null;
        StringBuilder sb = new StringBuilder();
        try {
            String str;
            URL url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + string);
            in = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
            while ((str = in.readLine()) != null) {
                sb.append(str);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNonSessionContent(String string) {
        BufferedReader in = null;
        StringBuilder sb = new StringBuilder();
        try {
            String str;
            URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + string);
            in = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
            while ((str = in.readLine()) != null) {
                sb.append(str);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }

    @Nullable
    public ItemStack getResult() {
        if (this.value != null) {
            return CustomHeadLoader.provide(this.value);
        }
        return null;
    }
}

