/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.skulls;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.data.FileList;
import com.github.sanctum.panther.file.MemorySpace;
import com.github.sanctum.panther.file.Node;
import com.github.sanctum.skulls.CustomHead;
import com.github.sanctum.skulls.HeadContext;
import com.github.sanctum.skulls.HeadLookup;
import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public final class CustomHeadLoader {
    private final MemorySpace memory;
    private boolean loaded;
    private final Map<HeadContext, HeadLookup> queue;
    private final Map<HeadContext, ItemStack> additions;

    public CustomHeadLoader(MemorySpace memory) {
        this.memory = memory;
        this.queue = new HashMap<HeadContext, HeadLookup>();
        this.additions = new HashMap<HeadContext, ItemStack>();
    }

    public CustomHeadLoader(Plugin plugin, String fileName, String directory) {
        this.memory = FileList.search(plugin).get(fileName, directory).getRoot();
        this.queue = new HashMap<HeadContext, HeadLookup>();
        this.additions = new HashMap<HeadContext, ItemStack>();
    }

    public CustomHeadLoader look(String section) {
        if (this.memory.isNode(section)) {
            Node parent = this.memory.getNode(section);
            for (String id : parent.getKeys(false)) {
                boolean isID;
                String category;
                boolean custom = parent.getNode(id).getNode("custom").toPrimitive().getBoolean();
                String name = parent.getNode(id).getNode("name").toPrimitive().getString();
                if (name == null) continue;
                if (custom) {
                    category = parent.getNode(id).getNode("category").toPrimitive().getString();
                    String value = null;
                    if (parent.getNode(id).getNode("value").toPrimitive().isString()) {
                        value = parent.getNode(id).getNode("value").toPrimitive().getString();
                    }
                    if (value != null) {
                        this.additions.put(new HeadContext(name, category), CustomHeadLoader.provide(value));
                        continue;
                    }
                    LabyrinthProvider.getInstance().getLogger().severe("- Custom head #" + id + " has no value to use.");
                    continue;
                }
                category = parent.getNode(id).getNode("category").toPrimitive().getString();
                String user = parent.getNode(id).getNode("user").toPrimitive().getString();
                boolean bl = isID = user != null && user.contains("-");
                if (isID) {
                    this.queue.put(new HeadContext(name, category), new HeadLookup(UUID.fromString(user)));
                    continue;
                }
                this.queue.put(new HeadContext(name, category), new HeadLookup(user));
            }
        }
        return this;
    }

    public CustomHeadLoader load() {
        this.loaded = true;
        for (Map.Entry<HeadContext, HeadLookup> entry : this.queue.entrySet()) {
            ItemStack result = entry.getValue().getResult();
            if (result != null) {
                this.additions.put(entry.getKey(), result);
                continue;
            }
            LabyrinthProvider.getInstance().getLogger().severe("- Custom named head '" + entry.getKey().getName() + "' unable to load.");
        }
        return this;
    }

    public void complete() {
        if (!this.getHeads().isEmpty()) {
            CustomHead.Manager.load(this);
        } else {
            LabyrinthProvider.getInstance().getLogger().warning("- No heads were loaded from memory space " + this.memory.getPath());
        }
    }

    Map<HeadContext, ItemStack> getHeads() {
        return this.additions;
    }

    boolean isLoaded() {
        return this.loaded;
    }

    public static ItemStack provide(String headValue) {
        boolean isNew = Arrays.stream(Material.values()).map(Enum::name).collect(Collectors.toList()).contains("PLAYER_HEAD");
        Material type = Material.matchMaterial((String)(isNew ? "PLAYER_HEAD" : "SKULL_ITEM"));
        Preconditions.checkNotNull((Object)type);
        ItemStack skull = isNew ? new ItemStack(type) : new ItemStack(type, 1, 3);
        if (headValue != null) {
            SkullMeta skullMeta = (SkullMeta)skull.getItemMeta();
            GameProfile profile = new GameProfile(UUID.randomUUID(), null);
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", headValue));
            if (LabyrinthProvider.getInstance().isLegacy()) {
                try {
                    Field profileField = skullMeta.getClass().getDeclaredField("profile");
                    profileField.setAccessible(true);
                    profileField.set(skullMeta, profile);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e1) {
                    e1.printStackTrace();
                }
            } else {
                try {
                    Method mtd = skullMeta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
                    mtd.setAccessible(true);
                    mtd.invoke((Object)skullMeta, profile);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    ex.printStackTrace();
                }
            }
            skull.setItemMeta((ItemMeta)skullMeta);
            return skull;
        }
        return skull;
    }
}

