/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.skulls;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.api.LabyrinthAPI;
import com.github.sanctum.labyrinth.data.container.CollectionTask;
import com.github.sanctum.labyrinth.data.service.Counter;
import com.github.sanctum.labyrinth.data.service.LabyrinthOption;
import com.github.sanctum.labyrinth.library.Item;
import com.github.sanctum.labyrinth.library.Items;
import com.github.sanctum.labyrinth.task.BukkitTaskPredicate;
import com.github.sanctum.labyrinth.task.TaskScheduler;
import com.github.sanctum.panther.file.MemorySpace;
import com.github.sanctum.panther.util.HUID;
import com.github.sanctum.skulls.CustomHeadLoader;
import com.github.sanctum.skulls.DefaultHead;
import com.github.sanctum.skulls.HeadContext;
import com.github.sanctum.skulls.HeadLookup;
import com.github.sanctum.skulls.SkullObject;
import com.github.sanctum.skulls.SkullType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomHead
implements SkullObject {
    private static final boolean LOADED;
    private static final List<CustomHead> HEADS;
    protected UUID owner;

    protected CustomHead() {
    }

    protected CustomHead(UUID owner) {
        this.owner = owner;
    }

    @Override
    @NotNull
    public abstract ItemStack get();

    @Override
    @NotNull
    public abstract String name();

    @Override
    @NotNull
    public abstract String category();

    @Override
    public Optional<UUID> id() {
        return Optional.ofNullable(this.owner);
    }

    @Override
    public SkullType getType() {
        return this.id().isPresent() ? SkullType.PLAYER : SkullType.CUSTOM;
    }

    static {
        if (LabyrinthOption.HEAD_PRE_CACHE.enabled()) {
            HEADS = new LinkedList<CustomHead>(Manager.loadOffline());
            TaskScheduler.of(() -> {
                HEADS.stream().filter(h -> h.getType() == SkullType.PLAYER).forEach(h -> TaskScheduler.of(() -> HEADS.remove(h)).schedule());
                HEADS.addAll(Manager.loadOffline());
            }).scheduleTimerAsync(HUID.randomID().toString(), 0L, 88000L, BukkitTaskPredicate.cancelAfter(task -> {
                Plugin pl = Bukkit.getPluginManager().getPlugin("Labyrinth");
                if (pl == null || !pl.isEnabled()) {
                    task.cancel();
                    return false;
                }
                return true;
            }));
        } else {
            HEADS = new LinkedList<CustomHead>();
        }
        LOADED = true;
    }

    public static class Manager {
        public static void load(CustomHead object) {
            boolean isNew = Arrays.stream(Material.values()).map(Enum::name).collect(Collectors.toList()).contains("PLAYER_HEAD");
            Material type = Items.findMaterial(isNew ? "PLAYER_HEAD" : "SKULL_ITEM");
            if (object.get().getType() != type) {
                throw new IllegalStateException(object.get().getType().name() + " is not a direct representation of " + type.name());
            }
            HEADS.add(object);
        }

        static List<CustomHead> loadOffline() {
            LinkedList<CustomHead> list = new LinkedList<CustomHead>();
            if (!LOADED) {
                OfflinePlayer[] players = Bukkit.getOfflinePlayers();
                LabyrinthAPI api = LabyrinthProvider.getInstance();
                if (players.length >= 500) {
                    Counter count = Counter.newInstance();
                    CollectionTask<OfflinePlayer> cache = CollectionTask.process(players, "USER-CACHE", 20, player -> {
                        HeadLookup search = new HeadLookup(player.getUniqueId());
                        if (search.getResult() != null) {
                            if (player.getName() != null) {
                                list.add(new DefaultHead(player.getName(), "Human", search.getResult(), player.getUniqueId()));
                            }
                        } else {
                            count.add();
                            HeadLookup search2 = new HeadLookup(player.getName());
                            if (search2.getResult() != null && player.getName() != null) {
                                list.add(new DefaultHead(player.getName(), "Deceased", search2.getResult()));
                            }
                        }
                    });
                    api.getLogger().warning("- A-lot of players, splitting the workload...");
                    api.getLogger().warning("- You can turn off skull pre-caching in the labyrinth config.");
                    api.getScheduler(1).repeat(cache, 0L, 50L);
                    while (cache.getCompletion() < 100.0) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if ((Long)count.get() > 0L) {
                        api.getLogger().warning(count.get() + " non-premium players accounted for.");
                    }
                } else {
                    TaskScheduler.of(() -> {
                        int count = 0;
                        for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                            HeadLookup search = new HeadLookup(player.getUniqueId());
                            if (search.getResult() != null) {
                                if (player.getName() == null) continue;
                                list.add(new DefaultHead(player.getName(), "Human", search.getResult(), player.getUniqueId()));
                                continue;
                            }
                            ++count;
                            HeadLookup search2 = new HeadLookup(player.getName());
                            if (search2.getResult() == null || player.getName() == null) continue;
                            list.add(new DefaultHead(player.getName(), "Deceased", search2.getResult()));
                        }
                        if (count > 0) {
                            api.getLogger().warning(count + " non-premium players accounted for.");
                        }
                    }).scheduleAsync();
                }
            }
            return list;
        }

        public static void load(CustomHeadLoader loader) {
            if (loader.isLoaded()) {
                for (Map.Entry<HeadContext, ItemStack> entry : loader.getHeads().entrySet()) {
                    Manager.load(entry.getKey().getName(), entry.getKey().getCategory(), entry.getValue());
                }
            } else {
                for (Map.Entry<HeadContext, ItemStack> entry : loader.load().getHeads().entrySet()) {
                    Manager.load(entry.getKey().getName(), entry.getKey().getCategory(), entry.getValue());
                }
            }
        }

        @Nullable
        public static ItemStack get(OfflinePlayer player) {
            return HEADS.stream().filter(h -> h.id().isPresent() && h.id().get().equals(player.getUniqueId())).map(CustomHead::get).findFirst().orElseGet(() -> {
                HeadLookup search = new HeadLookup(player.getUniqueId());
                if (search.getResult() != null) {
                    DefaultHead head = new DefaultHead(player.getName(), "Human", search.getResult(), player.getUniqueId());
                    HEADS.add(head);
                    return ((CustomHead)head).get();
                }
                return null;
            });
        }

        @Nullable
        public static ItemStack get(UUID id) {
            return HEADS.stream().filter(h -> h.id().isPresent() && h.id().get().equals(id)).map(CustomHead::get).findFirst().orElseGet(() -> {
                HeadLookup search = new HeadLookup(id);
                if (search.getResult() != null) {
                    DefaultHead head = new DefaultHead(Bukkit.getOfflinePlayer((UUID)id).getName(), "Human", search.getResult(), id);
                    HEADS.add(head);
                    return ((CustomHead)head).get();
                }
                return null;
            });
        }

        @Nullable
        public static ItemStack get(String name) {
            return HEADS.stream().filter(h -> h.name().equals(name)).map(CustomHead::get).findFirst().orElseGet(() -> {
                HeadLookup search = new HeadLookup(name);
                if (search.getResult() != null) {
                    DefaultHead head = new DefaultHead(name, "Human", search.getResult());
                    HEADS.add(head);
                    return ((CustomHead)head).get();
                }
                return null;
            });
        }

        @Nullable
        public static CustomHead pick(String name) {
            return HEADS.stream().filter(h -> h.name().equals(name)).findFirst().orElseGet(() -> {
                HeadLookup search = new HeadLookup(name);
                if (search.getResult() != null) {
                    DefaultHead head = new DefaultHead(name, "Human", search.getResult());
                    HEADS.add(head);
                    return head;
                }
                return null;
            });
        }

        @Nullable
        public static CustomHead pick(UUID id) {
            return HEADS.stream().filter(h -> h.id().isPresent() && h.id().get().equals(id)).findFirst().orElseGet(() -> {
                HeadLookup search = new HeadLookup(id);
                if (search.getResult() != null) {
                    DefaultHead head = new DefaultHead(Bukkit.getOfflinePlayer((UUID)id).getName(), "Human", search.getResult(), id);
                    HEADS.add(head);
                    return head;
                }
                return null;
            });
        }

        @Nullable
        public static CustomHead pick(OfflinePlayer player) {
            return HEADS.stream().filter(h -> h.id().isPresent() && h.id().get().equals(player.getUniqueId())).findFirst().orElseGet(() -> {
                HeadLookup search = new HeadLookup(player.getUniqueId());
                if (search.getResult() != null) {
                    DefaultHead head = new DefaultHead(player.getName(), "Human", search.getResult(), player.getUniqueId());
                    HEADS.add(head);
                    return head;
                }
                return null;
            });
        }

        public static List<String> getCategories() {
            return HEADS.stream().map(CustomHead::category).collect(Collectors.toList());
        }

        public static List<ItemStack> getCategory(String category) {
            if (!Manager.getCategories().contains(category)) {
                return new ArrayList<ItemStack>();
            }
            return HEADS.stream().filter(h -> h.category().equals(category)).map(CustomHead::get).collect(Collectors.toList());
        }

        public static List<CustomHead> getHeads() {
            return Collections.unmodifiableList(HEADS);
        }

        public static CustomHeadLoader newLoader(Plugin plugin, String fileName, String directory) {
            return new CustomHeadLoader(plugin, fileName, directory);
        }

        public static CustomHeadLoader newLoader(MemorySpace memory) {
            return new CustomHeadLoader(memory);
        }

        @Deprecated
        protected static void load(String name, String category, ItemStack item) {
            boolean isNew = Arrays.stream(Material.values()).map(Enum::name).collect(Collectors.toList()).contains("PLAYER_HEAD");
            Material type = Items.findMaterial(isNew ? "PLAYER_HEAD" : "SKULL_ITEM");
            if (item.getType() != type) {
                throw new IllegalStateException(item.getType().name() + " is not a direct representation of " + type.name());
            }
            Manager.load(new DefaultHead(name, category, item));
        }

        public static ItemStack modifyItemStack(ItemStack item, String name) {
            ItemStack itemStack;
            boolean isNew = Arrays.stream(Material.values()).map(Enum::name).collect(Collectors.toList()).contains("PLAYER_HEAD");
            Material type = Items.findMaterial(isNew ? "PLAYER_HEAD" : "SKULL_ITEM");
            if (item.getType() != type) {
                throw new IllegalStateException(item.getType().name() + " is not a direct representation of " + type.name());
            }
            CustomHead head = Manager.pick(name);
            if (head != null) {
                String[] stringArray;
                Item.Edit edit = new Item.Edit(head.get()).setTitle(item.getItemMeta() != null ? item.getItemMeta().getDisplayName() : head.name());
                if (item.getItemMeta() != null && item.getItemMeta().getLore() != null) {
                    stringArray = item.getItemMeta().getLore().toArray(new String[0]);
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "";
                }
                itemStack = edit.setLore(stringArray).build();
            } else {
                itemStack = item;
            }
            return itemStack;
        }
    }
}

