/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.util;

import com.github.sanctum.panther.annotation.Note;
import com.github.sanctum.panther.annotation.Synchronized;
import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherList;
import com.github.sanctum.panther.util.Applicable;
import com.github.sanctum.panther.util.OrdinalProcedure;
import com.github.sanctum.panther.util.TaskChain;
import com.github.sanctum.panther.util.TaskPredicate;
import com.github.sanctum.panther.util.TypeAdapter;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

@Note(value="This class requires a no argument method with ordinal level 0")
public abstract class Task
implements Applicable {
    public static final TypeAdapter<Task> FLAG = () -> Task.class;
    public static final int SINGULAR = 0;
    public static final int REPEATABLE = 1;
    private static final long serialVersionUID = 5781615452181138418L;
    protected TaskChain parent;
    private final PantherCollection<TaskPredicate<Task>> predicates = new PantherList<TaskPredicate<Task>>();
    private final OrdinalProcedure<Task> ordinal;
    private final String key;
    private Future<?> future;
    private Synchronizer synchronizer;
    private Runnable runnable;
    private final int type;
    private boolean async;

    public Task(String key, @NotNull TaskChain parent) {
        this.type = 0;
        this.key = key;
        this.parent = parent;
        this.ordinal = OrdinalProcedure.of(this);
    }

    public Task(String key, @NotNull TaskChain parent, @NotNull Runnable runnable) {
        this.type = 0;
        this.key = key;
        this.runnable = runnable;
        this.parent = parent;
        this.ordinal = OrdinalProcedure.of(this);
    }

    public Task(String key, int type, @NotNull TaskChain parent) {
        this.parent = parent;
        this.type = type;
        this.key = key;
        this.ordinal = OrdinalProcedure.of(this);
    }

    public Task(String key, int type, @NotNull TaskChain parent, @NotNull Runnable runnable) {
        this.parent = parent;
        this.type = type;
        this.key = key;
        this.runnable = runnable;
        this.ordinal = OrdinalProcedure.of(this);
    }

    public final Task setSynchronizer(@NotNull Synchronizer synchronizer) {
        this.synchronizer = synchronizer;
        return this;
    }

    public final Task setAsync(boolean async) {
        this.async = async;
        return this;
    }

    public final Task setChain(@NotNull TaskChain parent) {
        this.parent = parent;
        return this;
    }

    public final void setFuture(@NotNull Future<?> future) {
        this.future = future;
    }

    public final Task listen(TaskPredicate<?> ... predicates) {
        for (TaskPredicate<?> p : predicates) {
            this.predicates.add(p);
        }
        return this;
    }

    public final String getKey() {
        return this.key;
    }

    public final boolean isCancelled() {
        return this.future != null && this.future.isCancelled();
    }

    public final boolean isDone() {
        return this.future != null && this.future.isDone();
    }

    public final boolean isAsync() {
        return this.async;
    }

    public final <T extends Task> T cast(TypeAdapter<T> flag) {
        return (T)((Task)flag.cast(this));
    }

    @Note(value="This method only responds true if your class is annotated with a delay period of execution.")
    public final @Note(value="This method only responds true if your class is annotated with a delay period of execution.") boolean isRepeatable() {
        return this.getClass().isAnnotationPresent(Period.class);
    }

    @Override
    public final void run() {
        try {
            Runnable r;
            Runnable runnable = r = this.runnable != null ? () -> {
                if (!this.predicates.isEmpty() && this.predicates.stream().anyMatch(p -> !p.accept(this))) {
                    return;
                }
                this.runnable.run();
            } : () -> {
                if (!this.predicates.isEmpty() && this.predicates.stream().anyMatch(p -> !p.accept(this))) {
                    return;
                }
                this.ordinal.run(0);
            };
            if (this.isAsync()) {
                r.run();
            } else {
                this.synchronizer.sync(r);
            }
            if (this.type == 0 && this.parent != null) {
                this.parent.map.remove(this.getKey());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.cancel();
        }
    }

    public final boolean cancel() {
        if (!this.future.isCancelled()) {
            if (this.parent != null) {
                this.parent.map.remove(this.key);
            }
            return this.future.cancel(true);
        }
        return false;
    }

    public static interface Synchronizer {
        @Synchronized
        public void sync(@NotNull Runnable var1);
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.TYPE_USE})
    public static @interface Period {
        public long value() default 0L;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.TYPE_USE})
    public static @interface Delay {
        public long value() default 0L;
    }
}

