/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.util;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public interface ParsedTimeFormat {
    public long getDays();

    public long getHours();

    public long getMinutes();

    public long getSeconds();

    default public long toSeconds() {
        return TimeUnit.DAYS.toSeconds(this.getDays()) + TimeUnit.HOURS.toSeconds(this.getHours()) + TimeUnit.MINUTES.toSeconds(this.getMinutes()) + this.getSeconds();
    }

    @NotNull
    default public Date getDate() {
        long seconds = this.toSeconds();
        long time = System.currentTimeMillis() + seconds * 1000L;
        return new Date(time);
    }

    public static ParsedTimeFormat of(long sec) {
        long hours = sec / 3600L;
        long minutes = sec % 3600L / 60L;
        long seconds = sec % 60L;
        return ParsedTimeFormat.of(0L, hours, minutes, seconds);
    }

    public static ParsedTimeFormat of(@NotNull String format) {
        Pattern pattern = Pattern.compile("(\\d+)(d|hr|m|s)");
        Matcher matcher = pattern.matcher(format);
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        while (matcher.find()) {
            switch (matcher.group(2)) {
                case "d": {
                    days = Long.parseLong(matcher.group(1));
                    break;
                }
                case "hr": {
                    hours = Long.parseLong(matcher.group(1));
                    break;
                }
                case "m": {
                    minutes = Long.parseLong(matcher.group(1));
                    break;
                }
                case "s": {
                    seconds = Long.parseLong(matcher.group(1));
                }
            }
        }
        if (days == 0L && hours == 0L && minutes == 0L && seconds == 0L) {
            return null;
        }
        final long finalDays = days;
        final long finalHours = hours;
        final long finalMinutes = minutes;
        final long finalSeconds = seconds;
        return new ParsedTimeFormat(){

            @Override
            public long getDays() {
                return finalDays;
            }

            @Override
            public long getHours() {
                return finalHours;
            }

            @Override
            public long getMinutes() {
                return finalMinutes;
            }

            @Override
            public long getSeconds() {
                return finalSeconds;
            }

            public String toString() {
                ZonedDateTime time = new Date().toInstant().atZone(ZoneId.systemDefault());
                String month = time.getMonth().getDisplayName(TextStyle.FULL, Locale.ENGLISH);
                String year = String.valueOf(time.getYear());
                String day = String.valueOf((long)time.getDayOfMonth() + this.getDays());
                Date date = this.getDate();
                ZonedDateTime current = date.toInstant().atZone(ZoneId.systemDefault());
                String clock = current.getHour() + ":" + current.getMinute();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return month + " " + day + ", " + year + " @ " + clock + (calendar.get(9) == 1 ? "pm" : "am");
            }
        };
    }

    @NotNull
    public static ParsedTimeFormat of(final long days, final long hours, final long minutes, final long seconds) {
        return new ParsedTimeFormat(){

            @Override
            public long getDays() {
                return days;
            }

            @Override
            public long getHours() {
                return hours;
            }

            @Override
            public long getMinutes() {
                return minutes;
            }

            @Override
            public long getSeconds() {
                return seconds;
            }

            public String toString() {
                ZonedDateTime time = new Date().toInstant().atZone(ZoneId.systemDefault());
                String month = time.getMonth().getDisplayName(TextStyle.FULL, Locale.ENGLISH);
                String year = String.valueOf(time.getYear());
                String day = String.valueOf((long)time.getDayOfMonth() + this.getDays());
                Date date = this.getDate();
                ZonedDateTime current = date.toInstant().atZone(ZoneId.systemDefault());
                String clock = current.getHour() + ":" + current.getMinute();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return month + " " + day + ", " + year + " @ " + clock + (calendar.get(9) == 1 ? "pm" : "am");
            }
        };
    }
}

