/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.util;

import com.github.sanctum.panther.annotation.Note;
import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherCollectors;
import com.github.sanctum.panther.container.PantherList;
import com.github.sanctum.panther.util.AbstractPaginatedCollection;
import com.github.sanctum.panther.util.Deployable;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public interface Page<T>
extends Iterable<T> {
    public boolean isModifiable();

    public int getNumber();

    public int size();

    public T get(int var1);

    public boolean add(T var1);

    public boolean remove(T var1);

    public boolean contains(T var1);

    @Note(value="This is an optional method, you should nether need to use it but instead call the main AbstractPaginatedCollecction#reorder() method.")
    public @Note(value="This is an optional method, you should nether need to use it but instead call the main AbstractPaginatedCollecction#reorder() method.") Deployable<Page<T>> reorder();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public static class Impl<T>
    implements Page<T> {
        private final AbstractPaginatedCollection<T> parent;
        private PantherCollection<T> collection;
        private final int page;

        public Impl(AbstractPaginatedCollection<T> parent, int number) {
            this.parent = parent;
            this.collection = new PantherList<T>();
            this.page = number;
        }

        @Override
        @Note(value="Labyrinth impl is modifiable by default. (elements can be added)")
        public @Note(value="Labyrinth impl is modifiable by default. (elements can be added)") boolean isModifiable() {
            return true;
        }

        @Override
        public int getNumber() {
            return this.page;
        }

        @Override
        public int size() {
            return this.collection.size();
        }

        @Override
        public T get(int index) {
            return this.collection.get(index);
        }

        @Override
        public boolean add(T t) {
            if (!this.isModifiable()) {
                return false;
            }
            return this.collection.add(t);
        }

        @Override
        public boolean remove(T t) {
            if (!this.isModifiable()) {
                return false;
            }
            return this.collection.remove(t);
        }

        @Override
        public boolean contains(T t) {
            return this.collection.contains(t);
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return this.collection.iterator();
        }

        @Override
        public Deployable<Page<T>> reorder() {
            return Deployable.of(() -> {
                PantherCollection copy = this.collection;
                if (this.parent.predicate != null) {
                    copy = this.collection.stream().filter(this.parent.predicate).collect(PantherCollectors.toList());
                }
                if (this.parent.comparator != null) {
                    copy = copy.stream().sorted(this.parent.comparator).collect(PantherCollectors.toSet());
                }
                this.collection.clear();
                this.collection = copy;
                return this;
            }, 0);
        }
    }
}

