/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.util;

import com.github.sanctum.panther.annotation.AnnotationDiscovery;
import com.github.sanctum.panther.annotation.Ordinal;
import com.github.sanctum.panther.util.GenericOrdinalElement;
import com.github.sanctum.panther.util.OrdinalElement;
import com.github.sanctum.panther.util.OrdinalProcessException;
import com.github.sanctum.panther.util.OrdinalResult;
import com.github.sanctum.panther.util.ProcessedOrdinalElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public abstract class OrdinalProcedure<E> {
    private E e;
    private Iterable<E> eI;

    protected OrdinalProcedure(E e) {
        this.e = e;
    }

    protected OrdinalProcedure(Iterable<E> e) {
        this.eI = e;
    }

    public OrdinalResult<E> run() {
        if (this.isIterable()) {
            ArrayList<OrdinalElement<E>> processed = new ArrayList<OrdinalElement<E>>();
            for (E o : this.eI) {
                processed.add(this.run(o));
            }
            return OrdinalResult.of(processed);
        }
        return OrdinalResult.of(this.run(this.e));
    }

    public OrdinalResult<E> run(int ordinal) {
        if (this.isIterable()) {
            ArrayList<OrdinalElement<E>> processed = new ArrayList<OrdinalElement<E>>();
            for (E o : this.eI) {
                processed.add(this.run(o, ordinal));
            }
            return OrdinalResult.of(processed);
        }
        return OrdinalResult.of(this.run(this.e, ordinal));
    }

    public OrdinalResult<E> max(int ordinal) {
        if (this.isIterable()) {
            ArrayList<OrdinalElement<E>> processed = new ArrayList<OrdinalElement<E>>();
            for (E o : this.eI) {
                processed.add(this.max(o, ordinal));
            }
            return OrdinalResult.of(processed);
        }
        return OrdinalResult.of(this.max(this.e, ordinal));
    }

    public OrdinalResult<E> min(int ordinal) {
        if (this.isIterable()) {
            ArrayList<OrdinalElement<E>> processed = new ArrayList<OrdinalElement<E>>();
            for (E o : this.eI) {
                processed.add(this.min(o, ordinal));
            }
            return OrdinalResult.of(processed);
        }
        return OrdinalResult.of(this.min(this.e, ordinal));
    }

    public OrdinalResult<Object> get(int ordinal) {
        if (this.isIterable()) {
            ArrayList<GenericOrdinalElement> processed = new ArrayList<GenericOrdinalElement>();
            for (E o : this.eI) {
                processed.add(this.get(o, ordinal));
            }
            return OrdinalResult.of(processed);
        }
        return OrdinalResult.of(this.get(this.e, ordinal));
    }

    public OrdinalResult<Object> get(int ordinal, Object ... args) {
        if (this.isIterable()) {
            ArrayList<GenericOrdinalElement> processed = new ArrayList<GenericOrdinalElement>();
            for (E o : this.eI) {
                processed.add(this.get(o, ordinal, args));
            }
            return OrdinalResult.of(processed);
        }
        return OrdinalResult.of(this.get(this.e, ordinal, args));
    }

    public boolean isIterable() {
        return this.eI != null;
    }

    private OrdinalElement<E> run(E element) {
        AnnotationDiscovery<Ordinal, E> discovery = AnnotationDiscovery.of(Ordinal.class, element).filter(true).sort(Comparator.comparingInt(value -> value.getAnnotation(Ordinal.class).value()));
        for (Method m : discovery) {
            try {
                m.invoke(element, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new ProcessedOrdinalElement<E>(element);
    }

    private OrdinalElement<E> run(E element, int ordinal) {
        AnnotationDiscovery<Ordinal, E> discovery = AnnotationDiscovery.of(Ordinal.class, element).filter(true);
        discovery.ifPresent((ord, method) -> {
            if (ord.value() == ordinal) {
                try {
                    method.invoke(element, new Object[0]);
                }
                catch (Exception e) {
                    if (e.getCause() != null) {
                        if (e.getCause().getMessage() == null) {
                            throw new OrdinalProcessException("Ordinal processing failed on #" + ordinal + " for object " + element.getClass().getTypeName(), e.getCause().getStackTrace());
                        }
                        throw new OrdinalProcessException("Ordinal failure (#" + ordinal + ") @ " + element.getClass().getTypeName() + " : " + '\"' + e.getCause().getMessage() + '\"', e.getCause().getStackTrace());
                    }
                    throw new OrdinalProcessException("Ordinal processing failed on #" + ordinal + " for object " + element.getClass().getSimpleName());
                }
            }
        });
        return new ProcessedOrdinalElement<E>(element);
    }

    private OrdinalElement<E> max(E element, int ordinal) {
        AnnotationDiscovery<Ordinal, E> discovery = AnnotationDiscovery.of(Ordinal.class, element).filter(true).sort(Comparator.comparingInt(value -> value.getAnnotation(Ordinal.class).value()));
        discovery.ifPresent((ord, method) -> {
            if (ord.value() <= ordinal) {
                try {
                    method.invoke(element, new Object[0]);
                }
                catch (Exception e) {
                    if (e.getCause() != null) {
                        if (e.getCause().getMessage() == null) {
                            throw new OrdinalProcessException("Ordinal processing failed on #" + ordinal + " for object " + element.getClass().getTypeName(), e.getCause().getStackTrace());
                        }
                        throw new OrdinalProcessException("Ordinal failure (#" + ordinal + ") @ " + element.getClass().getTypeName() + " : " + '\"' + e.getCause().getMessage() + '\"', e.getCause().getStackTrace());
                    }
                    throw new OrdinalProcessException("Ordinal processing failed on #" + ordinal + " for object " + element.getClass().getSimpleName());
                }
            }
        });
        return new ProcessedOrdinalElement<E>(element);
    }

    private OrdinalElement<E> min(E element, int ordinal) {
        AnnotationDiscovery<Ordinal, E> discovery = AnnotationDiscovery.of(Ordinal.class, element).filter(true).sort(Comparator.comparingInt(value -> value.getAnnotation(Ordinal.class).value()));
        discovery.ifPresent((ord, method) -> {
            if (ord.value() >= ordinal) {
                try {
                    method.invoke(element, new Object[0]);
                }
                catch (Exception e) {
                    if (e.getCause() != null) {
                        if (e.getCause().getMessage() == null) {
                            throw new OrdinalProcessException("Ordinal processing failed on #" + ordinal + " for object " + element.getClass().getTypeName(), e.getCause().getStackTrace());
                        }
                        throw new OrdinalProcessException("Ordinal failure (#" + ordinal + ") @ " + element.getClass().getTypeName() + " : " + '\"' + e.getCause().getMessage() + '\"', e.getCause().getStackTrace());
                    }
                    throw new OrdinalProcessException("Ordinal processing failed on #" + ordinal + " for object " + element.getClass().getSimpleName());
                }
            }
        });
        return new ProcessedOrdinalElement<E>(element);
    }

    private GenericOrdinalElement get(E element, int ordinal) {
        AnnotationDiscovery<Ordinal, E> discovery = AnnotationDiscovery.of(Ordinal.class, element).filter(true);
        return discovery.methods().stream().filter(m -> m.getAnnotation(Ordinal.class).value() == ordinal).findFirst().map(method -> {
            try {
                return new GenericOrdinalElement(method.invoke(element, new Object[0]));
            }
            catch (Exception exception) {
                if (exception.getCause() != null) {
                    if (exception.getCause().getMessage() == null) {
                        throw new OrdinalProcessException("Ordinal processing failed on #" + ordinal + " for object " + element.getClass().getTypeName(), exception.getCause().getStackTrace());
                    }
                    throw new OrdinalProcessException("Ordinal failure (#" + ordinal + ") @ " + element.getClass().getTypeName() + " : " + '\"' + exception.getCause().getMessage() + '\"', exception.getCause().getStackTrace());
                }
                throw new OrdinalProcessException("Ordinal processing failed on #" + ordinal + " for object " + element.getClass().getSimpleName());
            }
        }).orElseThrow(() -> new RuntimeException("Ordinal " + ordinal + " either not found or access failed."));
    }

    private GenericOrdinalElement get(E element, int ordinal, Object ... args) {
        AnnotationDiscovery<Ordinal, E> discovery = AnnotationDiscovery.of(Ordinal.class, element).filter(true);
        return discovery.methods().stream().filter(m -> m.getAnnotation(Ordinal.class).value() == ordinal).findFirst().map(method -> {
            try {
                return new GenericOrdinalElement(method.invoke(element, args));
            }
            catch (Exception exception) {
                if (exception.getCause() != null) {
                    if (exception.getCause().getMessage() == null) {
                        throw new OrdinalProcessException("Ordinal processing failed on #" + ordinal + " for object " + element.getClass().getTypeName(), exception.getCause().getStackTrace());
                    }
                    throw new OrdinalProcessException("Ordinal failure (#" + ordinal + ") @ " + element.getClass().getTypeName() + " : " + '\"' + exception.getCause().getMessage() + '\"', exception.getCause().getStackTrace());
                }
                throw new OrdinalProcessException("Ordinal processing failed on #" + ordinal + " for object " + element.getClass().getSimpleName());
            }
        }).orElseThrow(() -> new RuntimeException("Ordinal " + ordinal + " either not found or access failed."));
    }

    public static <E> OrdinalProcedure<E> of(E e) {
        return new OrdinalProcedure<E>((Object)e){};
    }

    public static <E> OrdinalProcedure<E> of(Iterable<E> e) {
        return new OrdinalProcedure<E>((Iterable)e){};
    }

    public static <E> List<OrdinalElement<E>> process(Iterable<E> elements) {
        ArrayList<OrdinalElement<OrdinalElement<E>>> processed = new ArrayList<OrdinalElement<OrdinalElement<E>>>();
        for (E o : elements) {
            processed.add(OrdinalProcedure.process(o));
        }
        return processed;
    }

    public static <E> OrdinalElement<E> process(E element) {
        AnnotationDiscovery<Ordinal, E> discovery = AnnotationDiscovery.of(Ordinal.class, element).filter(true).sort(Comparator.comparingInt(value -> value.getAnnotation(Ordinal.class).value()));
        for (Method m : discovery) {
            try {
                m.invoke(element, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new ProcessedOrdinalElement<E>(element);
    }

    public static <E> OrdinalElement<E> process(E element, int ordinal) {
        AnnotationDiscovery<Ordinal, E> discovery = AnnotationDiscovery.of(Ordinal.class, element).filter(true);
        discovery.ifPresent((ord, method) -> {
            if (ord.value() == ordinal) {
                try {
                    method.invoke(element, new Object[0]);
                }
                catch (Exception e) {
                    if (e.getCause() != null) {
                        if (e.getCause().getMessage() == null) {
                            throw new OrdinalProcessException("Ordinal processing failed on #" + ordinal + " for object " + element.getClass().getTypeName(), e.getCause().getStackTrace());
                        }
                        throw new OrdinalProcessException("Ordinal failure (#" + ordinal + ") @ " + element.getClass().getTypeName() + " : " + '\"' + e.getCause().getMessage() + '\"', e.getCause().getStackTrace());
                    }
                    throw new OrdinalProcessException("Ordinal processing failed on #" + ordinal + " for object " + element.getClass().getSimpleName());
                }
            }
        });
        return new ProcessedOrdinalElement<E>(element);
    }

    public static <E> OrdinalElement<E> processMax(E element, int ordinal) {
        AnnotationDiscovery<Ordinal, E> discovery = AnnotationDiscovery.of(Ordinal.class, element).filter(true).sort(Comparator.comparingInt(value -> value.getAnnotation(Ordinal.class).value()));
        discovery.ifPresent((ord, method) -> {
            if (ord.value() <= ordinal) {
                try {
                    method.invoke(element, new Object[0]);
                }
                catch (Exception e) {
                    if (e.getCause() != null) {
                        if (e.getCause().getMessage() == null) {
                            throw new OrdinalProcessException("Ordinal processing failed on #" + ordinal + " for object " + element.getClass().getTypeName(), e.getCause().getStackTrace());
                        }
                        throw new OrdinalProcessException("Ordinal failure (#" + ordinal + ") @ " + element.getClass().getTypeName() + " : " + '\"' + e.getCause().getMessage() + '\"', e.getCause().getStackTrace());
                    }
                    throw new OrdinalProcessException("Ordinal processing failed on #" + ordinal + " for object " + element.getClass().getSimpleName());
                }
            }
        });
        return new ProcessedOrdinalElement<E>(element);
    }

    public static <E> OrdinalElement<E> processMin(E element, int ordinal) {
        AnnotationDiscovery<Ordinal, E> discovery = AnnotationDiscovery.of(Ordinal.class, element).filter(true).sort(Comparator.comparingInt(value -> value.getAnnotation(Ordinal.class).value()));
        discovery.ifPresent((ord, method) -> {
            if (ord.value() >= ordinal) {
                try {
                    method.invoke(element, new Object[0]);
                }
                catch (Exception e) {
                    if (e.getCause() != null) {
                        if (e.getCause().getMessage() == null) {
                            throw new OrdinalProcessException("Ordinal processing failed on #" + ordinal + " for object " + element.getClass().getTypeName(), e.getCause().getStackTrace());
                        }
                        throw new OrdinalProcessException("Ordinal failure (#" + ordinal + ") @ " + element.getClass().getTypeName() + " : " + '\"' + e.getCause().getMessage() + '\"', e.getCause().getStackTrace());
                    }
                    throw new OrdinalProcessException("Ordinal processing failed on #" + ordinal + " for object " + element.getClass().getSimpleName());
                }
            }
        });
        return new ProcessedOrdinalElement<E>(element);
    }

    public static <E> GenericOrdinalElement select(E element, int ordinal) {
        AnnotationDiscovery<Ordinal, E> discovery = AnnotationDiscovery.of(Ordinal.class, element).filter(true);
        return discovery.methods().stream().filter(m -> m.getAnnotation(Ordinal.class).value() == ordinal).findFirst().map(method -> {
            try {
                return new GenericOrdinalElement(method.invoke(element, new Object[0]));
            }
            catch (Exception exception) {
                if (exception.getCause() != null) {
                    if (exception.getCause().getMessage() == null) {
                        throw new OrdinalProcessException("Ordinal processing failed on #" + ordinal + " for object " + element.getClass().getTypeName(), exception.getCause().getStackTrace());
                    }
                    throw new OrdinalProcessException("Ordinal failure (#" + ordinal + ") @ " + element.getClass().getTypeName() + " : " + '\"' + exception.getCause().getMessage() + '\"', exception.getCause().getStackTrace());
                }
                throw new OrdinalProcessException("Ordinal processing failed on #" + ordinal + " for object " + element.getClass().getSimpleName());
            }
        }).orElseThrow(() -> new RuntimeException("Ordinal " + ordinal + " either not found or access failed."));
    }

    public static <E> GenericOrdinalElement select(E element, int ordinal, Object ... args) {
        AnnotationDiscovery<Ordinal, E> discovery = AnnotationDiscovery.of(Ordinal.class, element).filter(true);
        return discovery.methods().stream().filter(m -> m.getAnnotation(Ordinal.class).value() == ordinal).findFirst().map(method -> {
            try {
                return new GenericOrdinalElement(method.invoke(element, args));
            }
            catch (Exception exception) {
                if (exception.getCause() != null) {
                    if (exception.getCause().getMessage() == null) {
                        throw new OrdinalProcessException("Ordinal processing failed on #" + ordinal + " for object " + element.getClass().getTypeName(), exception.getCause().getStackTrace());
                    }
                    throw new OrdinalProcessException("Ordinal failure (#" + ordinal + ") @ " + element.getClass().getTypeName() + " : " + '\"' + exception.getCause().getMessage() + '\"', exception.getCause().getStackTrace());
                }
                throw new OrdinalProcessException("Ordinal processing failed on #" + ordinal + " for object " + element.getClass().getSimpleName());
            }
        }).orElseThrow(() -> new RuntimeException("Ordinal " + ordinal + " either not found or access failed."));
    }
}

