/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.util;

import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherEntryMap;
import com.github.sanctum.panther.container.PantherMap;
import com.github.sanctum.panther.container.PantherSet;
import com.github.sanctum.panther.recursive.Service;
import com.github.sanctum.panther.recursive.ServiceFactory;
import com.github.sanctum.panther.recursive.ServiceLoader;
import com.github.sanctum.panther.util.EntryMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MapDecompression
implements Service {
    final Service.Obligation obligation = () -> "To allow the unraveling of configurable standard keyed entries within a map.";

    MapDecompression() {
    }

    @Override
    @NotNull
    public Service.Obligation getObligation() {
        return this.obligation;
    }

    private String appendChild(String key, char divider, String text) {
        return key != null ? key + divider + text : text;
    }

    public EntryMapper decompress(@NotNull Iterable<? extends Map.Entry<String, Object>> iterable, char divider) {
        return this.decompress(iterable, divider, null);
    }

    public Map<String, Object> convert(@NotNull PantherMap<String, Object> map) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (Map.Entry entry : map) {
            if (entry.getValue() instanceof PantherMap) {
                m.putAll(this.convert((PantherMap)entry.getValue()));
                continue;
            }
            if (entry.getValue() instanceof PantherCollection) {
                ArrayList list = new ArrayList();
                ((PantherCollection)entry.getValue()).forEach(list::add);
                m.put((String)entry.getKey(), list);
                continue;
            }
            m.put((String)entry.getKey(), entry.getValue());
        }
        return m;
    }

    public EntryMapper decompress(final @NotNull Iterable<? extends Map.Entry<String, Object>> iterable, final char divider, final @Nullable String parentKey) {
        return new EntryMapper(){

            @Override
            public Set<String> toSet() {
                return MapDecompression.this.decompressNormalKeys(iterable, divider, parentKey);
            }

            @Override
            public PantherCollection<String> toPantherSet() {
                return MapDecompression.this.decompressLabyrinthKeys(iterable, divider, parentKey);
            }

            @Override
            public Map<String, Object> toMap() {
                return MapDecompression.this.decompressNormalValues(iterable, divider, parentKey);
            }

            @Override
            public PantherMap<String, Object> toPantherMap() {
                return MapDecompression.this.decompressLabyrinthValues(iterable, divider, parentKey);
            }
        };
    }

    Set<String> decompressNormalKeys(@NotNull Iterable<? extends Map.Entry<String, Object>> iterable, char divider, @Nullable String parent) {
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<String, Object> entry : iterable) {
            if (entry.getValue() instanceof Map) {
                set.addAll(this.decompressNormalKeys(((Map)entry.getValue()).entrySet(), divider, this.appendChild(parent, divider, entry.getKey())));
                continue;
            }
            if (entry.getValue() instanceof PantherMap) {
                this.decompressLabyrinthKeys(((PantherMap)entry.getValue()).entries(), divider, this.appendChild(parent, divider, entry.getKey())).forEach(set::add);
                continue;
            }
            set.add(this.appendChild(parent, divider, entry.getKey()));
        }
        return set;
    }

    Map<String, Object> decompressNormalValues(@NotNull Iterable<? extends Map.Entry<String, Object>> iterable, char divider, @Nullable String parent) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : iterable) {
            if (entry.getValue() instanceof Map) {
                m.putAll(this.decompressNormalValues(((Map)entry.getValue()).entrySet(), divider, this.appendChild(parent, divider, entry.getKey())));
                continue;
            }
            if (entry.getValue() instanceof PantherMap) {
                this.decompressLabyrinthValues(((PantherMap)entry.getValue()).entries(), divider, this.appendChild(parent, divider, entry.getKey())).forEach(e -> m.put((String)e.getKey(), e.getValue()));
                continue;
            }
            m.put(this.appendChild(parent, divider, entry.getKey()), entry.getValue());
        }
        return m;
    }

    PantherCollection<String> decompressLabyrinthKeys(@NotNull Iterable<? extends Map.Entry<String, Object>> iterable, char divider, @Nullable String parent) {
        PantherSet<String> set = new PantherSet<String>();
        for (Map.Entry<String, Object> entry : iterable) {
            if (entry.getValue() instanceof PantherMap) {
                set.addAll(this.decompressLabyrinthKeys(((PantherMap)entry.getValue()).entries(), divider, this.appendChild(parent, divider, entry.getKey())));
                continue;
            }
            if (entry.getValue() instanceof Map) {
                set.addAll(this.decompressNormalKeys(((Map)entry.getValue()).entrySet(), divider, this.appendChild(parent, divider, entry.getKey())));
                continue;
            }
            set.add(this.appendChild(parent, divider, entry.getKey()));
        }
        return set;
    }

    PantherMap<String, Object> decompressLabyrinthValues(@NotNull Iterable<? extends Map.Entry<String, Object>> iterable, char divider, @Nullable String parent) {
        PantherEntryMap<String, Object> m = new PantherEntryMap<String, Object>();
        for (Map.Entry<String, Object> entry : iterable) {
            if (entry.getValue() instanceof PantherMap) {
                this.decompressLabyrinthValues(((PantherMap)entry.getValue()).entries(), divider, this.appendChild(parent, divider, entry.getKey())).forEach(e -> m.put((String)e.getKey(), e.getValue()));
                continue;
            }
            if (entry.getValue() instanceof Map) {
                this.decompressNormalValues(((Map)entry.getValue()).entrySet(), divider, this.appendChild(parent, divider, entry.getKey())).forEach(m::put);
                continue;
            }
            m.put(this.appendChild(parent, divider, entry.getKey()), entry.getValue());
        }
        return m;
    }

    @NotNull
    public static MapDecompression getInstance() {
        MapDecompression service = ServiceFactory.getInstance().getService(MapDecompression.class);
        if (service == null) {
            ServiceLoader loader = ServiceFactory.getInstance().newLoader(MapDecompression.class);
            loader.supply(new MapDecompression());
            return (MapDecompression)loader.load();
        }
        return service;
    }
}

