/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.util;

import com.github.sanctum.panther.annotation.AnnotationDiscovery;
import com.github.sanctum.panther.annotation.Json;
import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherEntryMap;
import com.github.sanctum.panther.container.PantherList;
import com.github.sanctum.panther.container.PantherMap;
import com.github.sanctum.panther.file.JsonAdapter;
import com.github.sanctum.panther.file.Node;
import com.github.sanctum.panther.util.Check;
import com.github.sanctum.panther.util.DummyReducer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface JsonIntermediate {
    default public JsonObject toJsonObject() {
        return JsonIntermediate.toJsonObject(this);
    }

    default public JsonArray toJsonArray() {
        if (this instanceof Iterable) {
            return JsonIntermediate.toJsonArray(this);
        }
        return null;
    }

    default public String toJsonString() {
        return JsonIntermediate.toJsonString(this);
    }

    public static JsonArray toJsonArray(Object object) {
        JsonArray array = new JsonArray();
        if (object instanceof String && Check.isJson((String)object)) {
            return (JsonArray)JsonAdapter.getJsonBuilder().create().fromJson((String)object, JsonArray.class);
        }
        if (object instanceof Iterable) {
            for (Object o : Check.forNull((Iterable)object)) {
                JsonPrimitive element;
                if (o instanceof Number) {
                    element = new JsonPrimitive((Number)o);
                    array.add((JsonElement)element);
                    continue;
                }
                if (o instanceof Boolean) {
                    element = new JsonPrimitive((Boolean)o);
                    array.add((JsonElement)element);
                    continue;
                }
                if (o instanceof String) {
                    element = new JsonPrimitive((String)o);
                    array.add((JsonElement)element);
                    continue;
                }
                element = JsonIntermediate.toJsonObject(o);
                array.add((JsonElement)element);
            }
        }
        return array;
    }

    public static JsonObject toJsonObject(Object o) {
        JsonObject object = new JsonObject();
        if (o instanceof String && Check.isJson((String)o)) {
            return (JsonObject)JsonAdapter.getJsonBuilder().create().fromJson((String)o, JsonObject.class);
        }
        if (o instanceof Map) {
            for (Map.Entry entry : ((Map)o).entrySet()) {
                if (entry.getValue() instanceof String) {
                    object.addProperty((String)entry.getKey(), (String)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof Integer) {
                    object.addProperty((String)entry.getKey(), (Number)((Integer)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof Float) {
                    object.addProperty((String)entry.getKey(), (Number)((Float)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof Long) {
                    object.addProperty((String)entry.getKey(), (Number)((Long)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof Double) {
                    object.addProperty((String)entry.getKey(), (Number)((Double)entry.getValue()));
                    continue;
                }
                if (!(entry.getValue() instanceof Map)) continue;
                object.add((String)entry.getKey(), (JsonElement)JsonIntermediate.toJsonObject(entry.getValue()));
            }
            return object;
        }
        if (o instanceof PantherMap) {
            for (Map.Entry entry : ((PantherMap)o).entries()) {
                if (entry.getValue() instanceof String) {
                    object.addProperty((String)entry.getKey(), (String)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof Integer) {
                    object.addProperty((String)entry.getKey(), (Number)((Integer)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof Float) {
                    object.addProperty((String)entry.getKey(), (Number)((Float)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof Long) {
                    object.addProperty((String)entry.getKey(), (Number)((Long)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof Double) {
                    object.addProperty((String)entry.getKey(), (Number)((Double)entry.getValue()));
                    continue;
                }
                if (!(entry.getValue() instanceof PantherMap)) continue;
                object.add((String)entry.getKey(), (JsonElement)JsonIntermediate.toJsonObject(entry.getValue()));
            }
            return object;
        }
        AnnotationDiscovery<Json, Object> discovery = AnnotationDiscovery.of(Json.class, Check.forNull(o)).filter(true);
        HashMap<Class<? extends Json.Reducer>, Json.Reducer> hashMap = new HashMap<Class<? extends Json.Reducer>, Json.Reducer>();
        if (discovery.isPresent()) {
            for (Method m : discovery) {
                try {
                    Json annotation = m.getAnnotation(Json.class);
                    Object invoke = m.invoke(o, new Object[0]);
                    if (invoke instanceof String) {
                        object.addProperty(annotation.key(), (String)invoke);
                        continue;
                    }
                    if (invoke instanceof Integer) {
                        object.addProperty(annotation.key(), (Number)((Integer)invoke));
                        continue;
                    }
                    if (invoke instanceof Float) {
                        object.addProperty(annotation.key(), (Number)((Float)invoke));
                        continue;
                    }
                    if (invoke instanceof Long) {
                        object.addProperty(annotation.key(), (Number)((Long)invoke));
                        continue;
                    }
                    if (invoke instanceof Double) {
                        object.addProperty(annotation.key(), (Number)((Double)invoke));
                        continue;
                    }
                    if (invoke instanceof Iterable) {
                        object.add(annotation.key(), (JsonElement)JsonIntermediate.toJsonArray(invoke));
                        continue;
                    }
                    if (!annotation.reducer().equals(DummyReducer.class)) {
                        Class<? extends Json.Reducer> clazz = annotation.reducer();
                        if (hashMap.get(clazz) == null) {
                            Constructor<? extends Json.Reducer> constructor = clazz.getDeclaredConstructor(new Class[0]);
                            constructor.setAccessible(true);
                            Json.Reducer reducer = constructor.newInstance(new Object[0]);
                            hashMap.put(clazz, reducer);
                            Object n = reducer.reduce(invoke);
                            if (n instanceof String) {
                                object.addProperty(annotation.key(), (String)n);
                                continue;
                            }
                            if (n instanceof Integer) {
                                object.addProperty(annotation.key(), (Number)((Integer)n));
                                continue;
                            }
                            if (n instanceof Float) {
                                object.addProperty(annotation.key(), (Number)((Float)n));
                                continue;
                            }
                            if (n instanceof Long) {
                                object.addProperty(annotation.key(), (Number)((Long)n));
                                continue;
                            }
                            if (n instanceof Double) {
                                object.addProperty(annotation.key(), (Number)((Double)n));
                                continue;
                            }
                            object.add(annotation.key(), (JsonElement)JsonIntermediate.toJsonObject(n));
                            continue;
                        }
                        Json.Reducer reducer = (Json.Reducer)hashMap.get(clazz);
                        Object n = reducer.reduce(invoke);
                        if (n instanceof String) {
                            object.addProperty(annotation.key(), (String)n);
                            continue;
                        }
                        if (n instanceof Integer) {
                            object.addProperty(annotation.key(), (Number)((Integer)n));
                            continue;
                        }
                        if (n instanceof Float) {
                            object.addProperty(annotation.key(), (Number)((Float)n));
                            continue;
                        }
                        if (n instanceof Long) {
                            object.addProperty(annotation.key(), (Number)((Long)n));
                            continue;
                        }
                        if (n instanceof Double) {
                            object.addProperty(annotation.key(), (Number)((Double)n));
                            continue;
                        }
                        object.add(annotation.key(), (JsonElement)JsonIntermediate.toJsonObject(n));
                        continue;
                    }
                    object.add(annotation.key(), (JsonElement)JsonIntermediate.toJsonObject(invoke));
                }
                catch (Exception exception) {}
            }
            String key = AnnotationDiscovery.of(Node.Pointer.class, o).mapFromClass((r, u) -> r.value());
            JsonObject parent = new JsonObject();
            if (key == null) {
                return object;
            }
            parent.add(key, (JsonElement)object);
            return parent;
        }
        throw new NullPointerException(o.getClass() + " doesn't contain any json keys.");
    }

    public static String toJsonString(Object o) {
        if (o instanceof Iterable) {
            return JsonIntermediate.toJsonArray(o).toString();
        }
        return JsonIntermediate.toJsonObject(o).toString();
    }

    public static List<Object> convertToList(JsonArray array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (JsonElement element : array) {
            if (element.isJsonObject()) {
                list.add(JsonIntermediate.convertToMap(element.getAsJsonObject()));
            }
            if (element.isJsonArray()) {
                list.add(JsonIntermediate.convertToList(element.getAsJsonArray()));
            }
            if (!element.isJsonPrimitive()) continue;
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                list.add(primitive.getAsBoolean());
            }
            if (primitive.isNumber()) {
                list.add(primitive.getAsNumber());
            }
            if (!primitive.isString()) continue;
            list.add(primitive.getAsString());
        }
        return list;
    }

    public static PantherCollection<Object> convertToPantherList(JsonArray array) {
        PantherList<Object> list = new PantherList<Object>();
        for (JsonElement element : array) {
            if (element.isJsonObject()) {
                list.add(JsonIntermediate.convertToPantherMap(element.getAsJsonObject()));
            }
            if (element.isJsonArray()) {
                list.add(JsonIntermediate.convertToPantherList(element.getAsJsonArray()));
            }
            if (!element.isJsonPrimitive()) continue;
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                list.add(primitive.getAsBoolean());
            }
            if (primitive.isNumber()) {
                list.add(primitive.getAsNumber());
            }
            if (!primitive.isString()) continue;
            list.add(primitive.getAsString());
        }
        return list;
    }

    public static Map<String, Object> convertToMap(JsonObject object) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry entry : object.entrySet()) {
            if (((JsonElement)entry.getValue()).isJsonObject()) {
                map.put((String)entry.getKey(), JsonIntermediate.convertToMap(((JsonElement)entry.getValue()).getAsJsonObject()));
            }
            if (((JsonElement)entry.getValue()).isJsonArray()) {
                map.put((String)entry.getKey(), JsonIntermediate.convertToList(((JsonElement)entry.getValue()).getAsJsonArray()));
            }
            if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
            JsonPrimitive primitive = ((JsonElement)entry.getValue()).getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                map.put((String)entry.getKey(), primitive.getAsBoolean());
            }
            if (primitive.isNumber()) {
                map.put((String)entry.getKey(), primitive.getAsNumber());
            }
            if (!primitive.isString()) continue;
            map.put((String)entry.getKey(), primitive.getAsString());
        }
        return map;
    }

    public static PantherMap<String, Object> convertToPantherMap(JsonObject object) {
        PantherEntryMap<String, Object> map = new PantherEntryMap<String, Object>();
        for (Map.Entry entry : object.entrySet()) {
            if (((JsonElement)entry.getValue()).isJsonObject()) {
                map.put((String)entry.getKey(), JsonIntermediate.convertToPantherMap(((JsonElement)entry.getValue()).getAsJsonObject()));
            }
            if (((JsonElement)entry.getValue()).isJsonArray()) {
                map.put((String)entry.getKey(), JsonIntermediate.convertToPantherList(((JsonElement)entry.getValue()).getAsJsonArray()));
            }
            if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
            JsonPrimitive primitive = ((JsonElement)entry.getValue()).getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                map.put((String)entry.getKey(), primitive.getAsBoolean());
            }
            if (primitive.isNumber()) {
                map.put((String)entry.getKey(), primitive.getAsNumber());
            }
            if (!primitive.isString()) continue;
            map.put((String)entry.getKey(), primitive.getAsString());
        }
        return map;
    }
}

