/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.util;

import com.github.sanctum.panther.util.ParsedHUID;
import com.github.sanctum.panther.util.RandomID;
import com.github.sanctum.panther.util.SpecialID;
import java.io.Serializable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class HUID
implements CharSequence,
Serializable {
    private static final String WHITESPACE = "";
    private static final char DIVIDER = '-';
    private static final long serialVersionUID = -1397776894898458349L;
    private final String id;

    HUID(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HUID)) {
            return false;
        }
        HUID huid = (HUID)o;
        return huid.id.equals(this.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    @Override
    public int length() {
        return this.id.length();
    }

    @Override
    public char charAt(int index) {
        return this.id.charAt(index);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return this.id.subSequence(start, end);
    }

    @Override
    @NotNull
    public String toString() {
        return new StringBuilder(this.id).insert(4, '-').insert(9, '-').toString();
    }

    static boolean isAlphanumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetterOrDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static HUID randomID() {
        return new HUID(new RandomID(12).generate());
    }

    public static ParsedHUID parseID(final @NotNull Object value) {
        return new ParsedHUID(){
            private final String test;
            private final SpecialID.Builder builder;
            {
                this.test = value.toString().replace(String.valueOf('-'), HUID.WHITESPACE);
                this.builder = SpecialID.builder().setLength(12);
            }

            @Override
            public boolean isValid() {
                return HUID.isAlphanumeric(this.test) && this.test.length() == 12;
            }

            @Override
            public HUID toID() {
                if (value instanceof HUID) {
                    return (HUID)value;
                }
                return new HUID(this.test);
            }

            @Override
            public HUID newID() {
                return new HUID(this.builder.build(value).toString());
            }

            @Override
            public HUID newID(Character ... characters) {
                return new HUID(this.builder.setOptions(characters).build(value).toString());
            }

            @Override
            public String toString() {
                return this.isValid() ? this.test : this.newID().toString();
            }
        };
    }

    @Deprecated
    public static HUID fromString(String id) {
        String test = id.replace(String.valueOf('-'), WHITESPACE);
        return !HUID.isAlphanumeric(test) || test.length() != 12 ? null : new HUID(test);
    }
}

