/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.util;

import com.github.sanctum.panther.annotation.Note;
import com.github.sanctum.panther.util.PantherLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HFEncoded {
    private final Object obj;

    public HFEncoded(Object obj) {
        this.obj = obj;
    }

    @Note(value="Delegation for both serialization & deserialization transactions")
    public static @Note(value="Delegation for both serialization & deserialization transactions") HFEncoded of(@NotNull Object obj) {
        return new HFEncoded(obj);
    }

    public byte[] toByteArray(@Nullable Function<ByteArrayOutputStream, ObjectOutputStream> function) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ObjectOutputStream outputStream = function != null ? function.apply(output) : new ObjectOutputStream(output);
            outputStream.writeObject(this.obj);
            outputStream.flush();
            return output.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException("This should never happen", e);
        }
    }

    public String serialize(@Nullable Function<ByteArrayOutputStream, ObjectOutputStream> function) throws IllegalStateException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            ObjectOutputStream outputStream = function != null ? function.apply(output) : new ObjectOutputStream(output);
            outputStream.writeObject(this.obj);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("This should never happen", e);
        }
        byte[] serial = output.toByteArray();
        return Base64.getEncoder().encodeToString(serial);
    }

    public <T> T fromByteArray(@Nullable Function<ByteArrayInputStream, ObjectInputStream> function) throws IOException, ClassNotFoundException {
        if (this.obj == null || !byte[].class.isAssignableFrom(this.obj.getClass())) {
            return null;
        }
        byte[] ar = (byte[])this.obj;
        ByteArrayInputStream input = new ByteArrayInputStream(ar);
        ObjectInputStream inputStream = function != null ? function.apply(input) : new ObjectInputStream(input);
        return (T)inputStream.readObject();
    }

    public Object deserialized(@Nullable Function<ByteArrayInputStream, ObjectInputStream> function, ClassLookup ... lookups) throws IOException, ClassNotFoundException {
        byte[] serial = Base64.getDecoder().decode(this.obj.toString());
        ByteArrayInputStream input = new ByteArrayInputStream(serial);
        ObjectInputStream inputStream = function != null ? function.apply(input) : new ObjectInputStream(input);
        for (ClassLookup l : lookups) {
            if (!(inputStream instanceof ClassLookup.Input)) continue;
            ((ClassLookup.Input)((Object)inputStream)).add(l);
        }
        return inputStream.readObject();
    }

    public <T> T fromByteArray(@Nullable Function<ByteArrayInputStream, ObjectInputStream> function, ClassLookup ... lookups) throws IOException, ClassNotFoundException {
        if (this.obj == null || !byte[].class.isAssignableFrom(this.obj.getClass())) {
            return null;
        }
        byte[] ar = (byte[])this.obj;
        ByteArrayInputStream input = new ByteArrayInputStream(ar);
        ObjectInputStream inputStream = function != null ? function.apply(input) : new ObjectInputStream(input);
        for (ClassLookup l : lookups) {
            if (!(inputStream instanceof ClassLookup.Input)) continue;
            ((ClassLookup.Input)((Object)inputStream)).add(l);
        }
        return (T)inputStream.readObject();
    }

    public Object deserialized(@Nullable Function<ByteArrayInputStream, ObjectInputStream> function) throws IOException, ClassNotFoundException {
        byte[] serial = Base64.getDecoder().decode(this.obj.toString());
        ByteArrayInputStream input = new ByteArrayInputStream(serial);
        ObjectInputStream inputStream = function != null ? function.apply(input) : new ObjectInputStream(input);
        return inputStream.readObject();
    }

    public <T> T fromByteArray(@Nullable Function<ByteArrayInputStream, ObjectInputStream> function, @NotNull ClassLoader classLoader) throws IOException, ClassNotFoundException {
        if (this.obj == null || !byte[].class.isAssignableFrom(this.obj.getClass())) {
            return null;
        }
        byte[] ar = (byte[])this.obj;
        ByteArrayInputStream input = new ByteArrayInputStream(ar);
        ObjectInputStream inputStream = function != null ? function.apply(input) : new ObjectInputStream(input);
        if (inputStream instanceof LoaderInput) {
            ((LoaderInput)((Object)inputStream)).setLoader(classLoader);
        }
        return (T)inputStream.readObject();
    }

    public Object deserialized(@Nullable Function<ByteArrayInputStream, ObjectInputStream> function, @NotNull ClassLoader classLoader) throws IOException, ClassNotFoundException {
        byte[] serial = Base64.getDecoder().decode(this.obj.toString());
        ByteArrayInputStream input = new ByteArrayInputStream(serial);
        ObjectInputStream inputStream = function != null ? function.apply(input) : new ObjectInputStream(input);
        if (inputStream instanceof LoaderInput) {
            ((LoaderInput)((Object)inputStream)).setLoader(classLoader);
        }
        return inputStream.readObject();
    }

    @Nullable
    public <R> R deserialize(@Nullable Function<ByteArrayInputStream, ObjectInputStream> function, @NotNull Class<R> type) {
        try {
            Object o = this.deserialized(function);
            if (o == null) {
                return null;
            }
            if (type.isAssignableFrom(o.getClass())) {
                return (R)o;
            }
            throw new IllegalArgumentException(o.getClass().getSimpleName() + " is not assignable from " + type.getSimpleName());
        }
        catch (IOException | ClassNotFoundException e) {
            PantherLogger.getInstance().getLogger().severe("- " + e.getMessage());
            return null;
        }
    }

    @Nullable
    public <R> R deserialize(@Nullable Function<ByteArrayInputStream, ObjectInputStream> function, @NotNull Class<R> type, @NotNull ClassLoader classLoader) {
        try {
            Object o = this.deserialized(function, classLoader);
            if (o == null) {
                return null;
            }
            if (type.isAssignableFrom(o.getClass())) {
                return (R)o;
            }
            throw new IllegalArgumentException(o.getClass().getSimpleName() + " is not assignable from " + type.getSimpleName());
        }
        catch (IOException | ClassNotFoundException e) {
            PantherLogger.getInstance().getLogger().severe("- " + e.getMessage());
            return null;
        }
    }

    @FunctionalInterface
    public static interface ClassLookup {
        public Class<?> accept(@NotNull String var1);

        public static interface Input {
            public void add(@NotNull ClassLookup var1);
        }
    }

    public static interface LoaderInput {
        public void setLoader(@NotNull ClassLoader var1);
    }
}

