/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.placeholder;

import com.github.sanctum.panther.container.ImmutablePantherCollection;
import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherList;
import com.github.sanctum.panther.placeholder.Placeholder;
import com.github.sanctum.panther.placeholder.PlaceholderRegistration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class PlaceholderTranslationUtility {
    final PlaceholderRegistration registration = new PlaceholderRegistration(){
        private final PantherCollection<Placeholder.Translation> translations = new PantherList<Placeholder.Translation>();

        @Override
        public void registerTranslation(@NotNull Placeholder.Translation translation) {
            this.translations.add(translation);
        }

        @Override
        public void unregisterTranslation(@NotNull Placeholder.Translation translation) {
            this.translations.remove(translation);
        }

        @Override
        public Placeholder.Translation getTranslation(@NotNull Placeholder.Identifier identifier) {
            return this.translations.stream().filter(placeholderTranslation -> placeholderTranslation.hasCustomIdentifier() && placeholderTranslation.getIdentifier().get().equals(identifier.get())).findFirst().orElse(null);
        }

        @Override
        public Placeholder.Translation getTranslation(@NotNull String name) {
            return this.translations.stream().filter(translation -> translation.getInformation() != null && translation.getInformation().getName().equals(name)).findFirst().orElse(null);
        }

        @Override
        public void runAction(@NotNull Consumer<Placeholder.Translation> consumer) {
            this.translations.forEach(consumer);
        }

        @Override
        public boolean isRegistered(@NotNull Placeholder.Translation translation) {
            return this.translations.contains(translation);
        }

        @Override
        public boolean isEmpty(@NotNull String text) {
            return this.isEmpty(text, null);
        }

        @Override
        public boolean isEmpty(@NotNull String text, @Nullable Placeholder.Identifier identifier) {
            boolean empty = false;
            Iterator conversionIterator = this.translations.iterator();
            do {
                Placeholder.Translation conversion = (Placeholder.Translation)conversionIterator.next();
                for (Placeholder hold : conversion.getPlaceholders()) {
                    empty = PlaceholderTranslationUtility.this.isEmpty(text, identifier != null ? identifier : conversion.getIdentifier(), hold);
                }
            } while (conversionIterator.hasNext());
            return empty;
        }

        @Override
        @NotNull
        public String replaceAll(@NotNull String text) {
            if (this.translations.isEmpty()) {
                return text;
            }
            return this.replaceAll(text, null);
        }

        @Override
        @NotNull
        public String replaceAll(@NotNull String text, @Nullable Object receiver) {
            if (this.translations.isEmpty()) {
                return text;
            }
            String result = text;
            Placeholder.Variable variable = () -> receiver;
            Iterator conversionIterator = this.translations.iterator();
            do {
                Placeholder.Translation conversion = (Placeholder.Translation)conversionIterator.next();
                for (Placeholder hold : conversion.getPlaceholders()) {
                    result = this.replaceAll(result, variable, conversion.getIdentifier(), hold);
                }
            } while (conversionIterator.hasNext());
            return result;
        }

        @Override
        @NotNull
        public String replaceAll(@NotNull String text, @Nullable Placeholder.Variable receiver) {
            if (this.translations.isEmpty()) {
                return text;
            }
            String result = text;
            Iterator conversionIterator = this.translations.iterator();
            do {
                Placeholder.Translation conversion = (Placeholder.Translation)conversionIterator.next();
                for (Placeholder hold : conversion.getPlaceholders()) {
                    result = this.replaceAll(result, receiver, conversion.getIdentifier(), hold);
                }
            } while (conversionIterator.hasNext());
            return result;
        }

        @Override
        @NotNull
        public String replaceAll(@NotNull String text, @Nullable Placeholder.Variable receiver, Placeholder placeholder) {
            if (this.translations.isEmpty()) {
                return text;
            }
            return this.replaceAll(text, receiver, null, placeholder);
        }

        @Override
        @NotNull
        public String replaceAll(@NotNull String text, @Nullable Placeholder.Variable receiver, @Nullable Placeholder.Identifier identifier, @NotNull Placeholder placeholder) {
            if (this.translations.isEmpty()) {
                return text;
            }
            return PlaceholderTranslationUtility.this.getTranslation(text, identifier, receiver, placeholder);
        }

        @Override
        @NotNull
        public String replaceAll(@NotNull String text, @NotNull Placeholder placeholder, @NotNull String replacement) {
            Pattern pattern = PlaceholderTranslationUtility.this.getPattern(null, placeholder);
            Matcher matcher = pattern.matcher(text);
            if (!matcher.find()) {
                return text;
            }
            StringBuffer builder = new StringBuffer();
            do {
                matcher.appendReplacement(builder, replacement);
            } while (matcher.find());
            return matcher.appendTail(builder).toString();
        }

        @Override
        @Nullable
        public String findFirst(@NotNull String text, @NotNull Placeholder placeholder) {
            Pattern pattern = PlaceholderTranslationUtility.this.getPattern(null, placeholder);
            Matcher matcher = pattern.matcher(text);
            if (!matcher.find()) {
                return null;
            }
            return matcher.group("parameters");
        }

        @Override
        @NotNull
        public PantherCollection<String> findAny(@NotNull String text, @NotNull Placeholder placeholder) {
            ImmutablePantherCollection.Builder<String> builder = ImmutablePantherCollection.builder();
            Pattern pattern = PlaceholderTranslationUtility.this.getPattern(null, placeholder);
            Matcher matcher = pattern.matcher(text);
            StringBuffer buffer = new StringBuffer();
            if (!matcher.find()) {
                return new PantherList<String>();
            }
            do {
                builder.add(matcher.group("parameters"));
                matcher.appendReplacement(buffer, "");
            } while (matcher.find());
            return builder.build();
        }

        @Override
        @NotNull
        public Placeholder[] findAny(@NotNull String text, @NotNull Placeholder.Translation placeholder) {
            return PlaceholderTranslationUtility.this.getPlaceholders(text, placeholder);
        }
    };

    PlaceholderTranslationUtility() {
    }

    boolean isEmpty(String text, Placeholder.Identifier identifier, Placeholder placeholder) {
        Pattern pattern = this.getPattern(identifier, placeholder);
        Matcher matcher = pattern.matcher(text);
        return !matcher.find();
    }

    @NotNull
    String getTranslation(String text, Placeholder.Identifier identifier, Placeholder.Variable receiver, final Placeholder placeholder) {
        Pattern pattern = this.getPattern(identifier, placeholder);
        Matcher matcher = pattern.matcher(text);
        if (!matcher.find()) {
            return text;
        }
        StringBuffer builder = new StringBuffer();
        do {
            if (identifier != null) {
                String actualId = matcher.group("identifier");
                final String parameters = matcher.group("parameters");
                Placeholder.Translation conversion2 = PlaceholderRegistration.getInstance().getTranslation(identifier);
                if (conversion2 != null) {
                    boolean valid;
                    String translation = conversion2.onTranslation(parameters, receiver != null ? receiver : () -> null);
                    Map<String, Placeholder> placeholderMap = PlaceholderRegistration.history.get(identifier.get() + identifier.spacer());
                    boolean bl = valid = translation != null && !translation.equals(parameters) && !translation.isEmpty();
                    if (placeholderMap != null) {
                        if (placeholderMap.get(placeholder.start() + parameters.toLowerCase(Locale.ROOT) + placeholder.end()) == null && valid) {
                            Placeholder record = new Placeholder(){

                                @Override
                                public char start() {
                                    return placeholder.start();
                                }

                                @Override
                                public CharSequence parameters() {
                                    return parameters;
                                }

                                @Override
                                public char end() {
                                    return placeholder.end();
                                }
                            };
                            placeholderMap.put(placeholder.start() + parameters.toLowerCase(Locale.ROOT) + placeholder.end(), record);
                        }
                    } else {
                        HashMap<String, 3> map = new HashMap<String, 3>();
                        if (valid) {
                            Placeholder record = new Placeholder(){

                                @Override
                                public char start() {
                                    return placeholder.start();
                                }

                                @Override
                                public CharSequence parameters() {
                                    return parameters;
                                }

                                @Override
                                public char end() {
                                    return placeholder.end();
                                }
                            };
                            map.put(placeholder.start() + parameters.toLowerCase(Locale.ROOT) + placeholder.end(), record);
                        }
                        PlaceholderRegistration.history.put(identifier.get() + identifier.spacer(), map);
                    }
                    matcher.appendReplacement(builder, translation != null ? translation : placeholder.start() + actualId + identifier.spacer() + parameters + placeholder.end());
                    continue;
                }
                matcher.appendReplacement(builder, placeholder.start() + actualId + identifier.spacer() + parameters + placeholder.end());
                continue;
            }
            PlaceholderRegistration.getInstance().runAction(conversion -> {
                String parameters = matcher.group("parameters");
                if (parameters != null && !parameters.isEmpty()) {
                    String translation = conversion.onTranslation(parameters, receiver != null ? receiver : () -> null);
                    matcher.appendReplacement(builder, translation != null && !translation.isEmpty() ? translation : placeholder.start() + parameters + placeholder.end());
                }
            });
        } while (matcher.find());
        return matcher.appendTail(builder).toString();
    }

    @NotNull
    Placeholder[] getPlaceholders(String text, Placeholder.Translation conversion) {
        ArrayList<4> placeholderList = new ArrayList<4>();
        for (final Placeholder p : conversion.getPlaceholders()) {
            Pattern pattern = this.getPattern(conversion.getIdentifier(), p);
            Matcher matcher = pattern.matcher(text);
            if (!matcher.find()) continue;
            do {
                final String parameters = matcher.group("parameters");
                placeholderList.add(new Placeholder(){

                    @Override
                    public char start() {
                        return p.start();
                    }

                    @Override
                    public CharSequence parameters() {
                        return parameters;
                    }

                    @Override
                    public char end() {
                        return p.end();
                    }
                });
            } while (matcher.find());
        }
        return placeholderList.toArray(new Placeholder[0]);
    }

    @NotNull
    Pattern getPattern(Placeholder.Identifier identifier, Placeholder placeholder) {
        Pattern pattern = identifier == null ? Pattern.compile(String.format("\\%s(?<parameters>[^%s%s]+)\\%s", Character.valueOf(placeholder.start()), Character.valueOf(placeholder.start()), Character.valueOf(placeholder.end()), Character.valueOf(placeholder.end()))) : Pattern.compile(String.format("\\%s((?<identifier>[a-zA-Z0-9]+)" + identifier.spacer() + ")(?<parameters>[^%s%s]+)\\%s", Character.valueOf(placeholder.start()), Character.valueOf(placeholder.start()), Character.valueOf(placeholder.end()), Character.valueOf(placeholder.end())));
        return pattern;
    }
}

