/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.placeholder;

import com.github.sanctum.panther.placeholder.PlaceholderRegistration;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Placeholder {
    public static final Placeholder ANGLE_BRACKETS = new Placeholder(){

        @Override
        public char start() {
            return '<';
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public char end() {
            return '>';
        }
    };
    public static final Placeholder CURLEY_BRACKETS = new Placeholder(){

        @Override
        public char start() {
            return '{';
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public char end() {
            return '}';
        }
    };
    public static final Placeholder PERCENT = new Placeholder(){

        @Override
        public char start() {
            return '%';
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public char end() {
            return '%';
        }
    };

    public char start();

    default public CharSequence parameters() {
        return "";
    }

    public char end();

    default public boolean isSame(Placeholder placeholder) {
        return this.start() == placeholder.start() && this.end() == placeholder.end() && this.parameters().equals(placeholder.parameters());
    }

    default public boolean isSame(char start, char end) {
        return this.start() == start && this.end() == end;
    }

    default public boolean isEmpty() {
        return this.parameters().length() == 0 || this.parameters().equals(" ");
    }

    default public boolean isDefault() {
        return false;
    }

    @NotNull
    default public String toRaw() {
        return String.valueOf(this.start()) + this.parameters() + this.end();
    }

    @NotNull
    default public String toTranslated(@Nullable Variable variable) {
        return PlaceholderRegistration.getInstance().replaceAll(this.toRaw(), variable, this);
    }

    public static Placeholder[] values() {
        return new Placeholder[]{ANGLE_BRACKETS, CURLEY_BRACKETS, PERCENT};
    }

    @NotNull
    public static Placeholder valueOf(final char start, final char end) {
        return Arrays.stream(Placeholder.values()).filter(v -> v.isSame(start, end)).findFirst().orElse(new Placeholder(){

            @Override
            public char start() {
                return start;
            }

            @Override
            public char end() {
                return end;
            }
        });
    }

    public static interface Signature {
        @NotNull
        public String getName();

        @NotNull
        public String[] getAuthors();

        @NotNull
        public String getVersion();
    }

    @FunctionalInterface
    public static interface Variable {
        public Object get();

        default public boolean exists() {
            return this.get() != null;
        }
    }

    @FunctionalInterface
    public static interface Translation {
        @Nullable
        public String onTranslation(String var1, Variable var2);

        @Nullable
        default public Signature getInformation() {
            return null;
        }

        @NotNull
        default public Placeholder[] getPlaceholders() {
            return Placeholder.values();
        }

        @Nullable
        default public Identifier getIdentifier() {
            return null;
        }

        default public Placeholder[] getPlaceholders(String text) {
            return PlaceholderRegistration.getInstance().findAny(text, this);
        }

        default public boolean hasCustomIdentifier() {
            return this.getIdentifier() != null;
        }

        default public boolean isRegistered() {
            return PlaceholderRegistration.getInstance().isRegistered(this);
        }

        default public void register() {
            PlaceholderRegistration.getInstance().registerTranslation(this);
        }

        default public void unregister() {
            PlaceholderRegistration.getInstance().unregisterTranslation(this);
        }
    }

    @FunctionalInterface
    public static interface Identifier {
        @NotNull
        public String get();

        @NotNull
        default public String spacer() {
            return "_";
        }
    }
}

