/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.paste;

import com.github.sanctum.panther.annotation.Note;
import com.github.sanctum.panther.paste.operative.PasteResponse;
import com.github.sanctum.panther.paste.option.Context;
import com.github.sanctum.panther.paste.option.Expiration;
import com.github.sanctum.panther.paste.option.Visibility;
import com.github.sanctum.panther.paste.type.HasteOptions;
import com.github.sanctum.panther.paste.type.Hastebin;
import com.github.sanctum.panther.paste.type.PasteOptions;
import com.github.sanctum.panther.paste.type.Pastebin;
import com.github.sanctum.panther.paste.type.PastebinUser;
import com.github.sanctum.panther.recursive.Service;
import com.github.sanctum.panther.recursive.ServiceFactory;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PasteManager
extends Service {
    @Note(value="This is an overridable provision!")
    public static @Note(value="This is an overridable provision!") PasteManager getInstance() {
        PasteManager manager = ServiceFactory.getInstance().getService(PasteManager.class);
        if (manager != null) {
            return manager;
        }
        PasteManager instance = new PasteManager(){
            final Service.Obligation obligation = () -> "To provide easy access to both hastebin and pastebin web api.";

            @Override
            @NotNull
            public Service.Obligation getObligation() {
                return this.obligation;
            }

            @Override
            @NotNull
            public Hastebin newHaste() {
                return new Hastebin(){
                    private final HasteOptions options = HasteOptions.empty();

                    @Override
                    @NotNull
                    public String getApiKey() {
                        return "NA";
                    }

                    @Override
                    @NotNull
                    public HasteOptions getOptions() {
                        return this.options;
                    }

                    @Override
                    public PasteResponse read(final String id) {
                        return new PasteResponse(){

                            @Override
                            public String get() {
                                return this.getAll()[0];
                            }

                            @Override
                            public String[] getAll() {
                                String response = "Unable to receive proper response.";
                                try {
                                    String requestURL = id.contains("http") && !id.contains("raw") ? id.replace("hastebin.skyra.pw", "hastebin.skyra.pw/raw") : "https://hastebin.skyra.pw/raw/" + id;
                                    URL url = new URL(requestURL);
                                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                                    conn.setDoInput(true);
                                    conn.setInstanceFollowRedirects(false);
                                    conn.setRequestMethod("GET");
                                    conn.setRequestProperty("User-Agent", "Hastebin Java Api");
                                    conn.setUseCaches(false);
                                    List lines = Resources.readLines((URL)conn.getURL(), (Charset)Charsets.UTF_8);
                                    return lines.toArray(new String[0]);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    return response.split(" ");
                                }
                            }
                        };
                    }

                    @Override
                    public PasteResponse write(String ... info) {
                        return () -> {
                            String response = "Unable to receive proper response.";
                            StringBuilder builder = new StringBuilder();
                            for (String s : info) {
                                builder.append(s).append("\n");
                            }
                            try {
                                byte[] postData = builder.toString().getBytes(StandardCharsets.UTF_8);
                                int postDataLength = postData.length;
                                URL url = new URL("https://hastebin.skyra.pw/documents");
                                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                                conn.setDoOutput(true);
                                conn.setInstanceFollowRedirects(false);
                                conn.setRequestMethod("POST");
                                conn.setRequestProperty("User-Agent", "Hastebin Java Api");
                                conn.setRequestProperty("Content-Length", Integer.toString(postDataLength));
                                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                                conn.setUseCaches(false);
                                try {
                                    DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
                                    wr.write(postData);
                                    wr.flush();
                                    BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                                    response = reader.readLine();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                if (response.contains("\"key\"")) {
                                    response = response.substring(response.indexOf(":") + 2, response.length() - 2);
                                    String postURL = this.getOptions().isRaw() ? "https://hastebin.skyra.pw/raw/" : "https://hastebin.skyra.pw/";
                                    response = postURL + response;
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            return response;
                        };
                    }

                    @Override
                    public PasteResponse write(Collection<? extends CharSequence> info) {
                        return () -> {
                            String response = "Unable to receive proper response.";
                            StringBuilder builder = new StringBuilder();
                            for (CharSequence s : info) {
                                builder.append("*").append(" ").append(s).append("\n");
                            }
                            try {
                                byte[] postData = builder.toString().getBytes(StandardCharsets.UTF_8);
                                int postDataLength = postData.length;
                                String requestURL = "https://hastebin.skyra.pw/documents";
                                URL url = new URL(requestURL);
                                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                                conn.setDoOutput(true);
                                conn.setInstanceFollowRedirects(false);
                                conn.setRequestMethod("POST");
                                conn.setRequestProperty("User-Agent", "Hastebin Java Api");
                                conn.setRequestProperty("Content-Length", Integer.toString(postDataLength));
                                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                                conn.setUseCaches(false);
                                try {
                                    DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
                                    wr.write(postData);
                                    wr.flush();
                                    BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                                    response = reader.readLine();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                if (response.contains("\"key\"")) {
                                    response = response.substring(response.indexOf(":") + 2, response.length() - 2);
                                    String postURL = this.getOptions().isRaw() ? "https://hastebin.skyra.pw/raw/" : "https://hastebin.skyra.pw/";
                                    response = postURL + response;
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            return response;
                        };
                    }
                };
            }

            @Override
            @NotNull
            public Pastebin newPaste(final @NotNull String apiKey) {
                return new Pastebin(){
                    private final PasteOptions options = new PasteOptions(){
                        private Context language = () -> "text";
                        private Context folder;
                        private Expiration expiration = Expiration.TEN_MINUTE;
                        private Visibility visibility = Visibility.PUBLIC;

                        @Override
                        @NotNull
                        public Context getLanguage() {
                            return this.language;
                        }

                        @Override
                        @Nullable
                        public Context getFolder() {
                            return this.folder;
                        }

                        @Override
                        @NotNull
                        public Expiration getExpiration() {
                            return this.expiration;
                        }

                        @Override
                        @NotNull
                        public Visibility getVisibility() {
                            return this.visibility;
                        }

                        @Override
                        public void setFolder(@NotNull Context context) {
                            this.folder = context;
                        }

                        @Override
                        public void setLanguage(@NotNull Context context) {
                            this.language = context;
                        }

                        @Override
                        public void setExpiration(@NotNull Expiration expiration) {
                            this.expiration = expiration;
                        }

                        @Override
                        public void setVisibility(@NotNull Visibility visibility) {
                            this.visibility = visibility;
                        }
                    };

                    @Override
                    public PasteResponse read(String id) {
                        String response = "Unable to receive proper response.";
                        try {
                            URL url = new URL("https://pastebin.com/raw/");
                            URLConnection con = url.openConnection();
                            HttpURLConnection http = (HttpURLConnection)con;
                            http.setRequestMethod("POST");
                            http.setDoOutput(true);
                            http.setDoInput(true);
                            HashMap<String, String> arguments = new HashMap<String, String>();
                            arguments.put("paste_key", id);
                            StringJoiner sj = new StringJoiner("&");
                            for (Map.Entry entry : arguments.entrySet()) {
                                sj.add(URLEncoder.encode((String)entry.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8"));
                            }
                            http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                            http.connect();
                            OutputStream os = http.getOutputStream();
                            os.write(sj.toString().getBytes(StandardCharsets.UTF_8));
                            InputStream is = http.getInputStream();
                            response = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                        }
                        catch (IOException urlException) {
                            urlException.printStackTrace();
                        }
                        String finalResponse = response;
                        return () -> finalResponse;
                    }

                    @Override
                    @NotNull
                    public String getApiKey() {
                        return apiKey;
                    }

                    @Override
                    @NotNull
                    public PasteOptions getOptions() {
                        return this.options;
                    }

                    @Override
                    @Nullable
                    public PastebinUser login(String username, String password) {
                        try {
                            URL url = new URL("https://pastebin.com/api/api_login.php");
                            URLConnection con = url.openConnection();
                            HttpURLConnection http = (HttpURLConnection)con;
                            http.setRequestMethod("POST");
                            http.setDoOutput(true);
                            http.setDoInput(true);
                            HashMap<String, String> arguments = new HashMap<String, String>();
                            arguments.put("api_dev_key", this.getApiKey());
                            arguments.put("api_user_name", username);
                            arguments.put("api_user_password", password);
                            StringJoiner sj = new StringJoiner("&");
                            for (Map.Entry entry : arguments.entrySet()) {
                                sj.add(URLEncoder.encode((String)entry.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8"));
                            }
                            http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                            http.connect();
                            OutputStream os = http.getOutputStream();
                            os.write(sj.toString().getBytes(StandardCharsets.UTF_8));
                            InputStream is = http.getInputStream();
                            final String result = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                            if (result == null || result.isEmpty()) {
                                return null;
                            }
                            return new PastebinUser(){
                                private final String userId;
                                private final PasteOptions options;
                                {
                                    this.userId = result;
                                    this.options = new PasteOptions(){
                                        private Context language = () -> "text";
                                        private Context folder;
                                        private Expiration expiration = Expiration.NEVER;
                                        private Visibility visibility = Visibility.PUBLIC;

                                        @Override
                                        @NotNull
                                        public Context getLanguage() {
                                            return this.language;
                                        }

                                        @Override
                                        @Nullable
                                        public Context getFolder() {
                                            return this.folder;
                                        }

                                        @Override
                                        @NotNull
                                        public Expiration getExpiration() {
                                            return this.expiration;
                                        }

                                        @Override
                                        @NotNull
                                        public Visibility getVisibility() {
                                            return this.visibility;
                                        }

                                        @Override
                                        public void setFolder(@NotNull Context context) {
                                            this.folder = context;
                                        }

                                        @Override
                                        public void setLanguage(@NotNull Context context) {
                                            this.language = context;
                                        }

                                        @Override
                                        public void setExpiration(@NotNull Expiration expiration) {
                                            this.expiration = expiration;
                                        }

                                        @Override
                                        public void setVisibility(@NotNull Visibility visibility) {
                                            this.visibility = visibility;
                                        }
                                    };
                                }

                                @Override
                                @NotNull
                                public String getId() {
                                    return this.userId;
                                }

                                @Override
                                public boolean remove(@NotNull String id) {
                                    try {
                                        URL url = new URL("https://pastebin.com/api/api_post.php");
                                        URLConnection con = url.openConnection();
                                        HttpURLConnection http = (HttpURLConnection)con;
                                        http.setRequestMethod("POST");
                                        http.setDoOutput(true);
                                        http.setDoInput(true);
                                        HashMap<String, String> arguments = new HashMap<String, String>();
                                        arguments.put("api_dev_key", this.getApiKey());
                                        arguments.put("api_user_key", this.getId());
                                        arguments.put("api_option", "delete");
                                        arguments.put("api_paste_key", id);
                                        StringJoiner sj = new StringJoiner("&");
                                        for (Map.Entry entry : arguments.entrySet()) {
                                            sj.add(URLEncoder.encode((String)entry.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8"));
                                        }
                                        byte[] out = sj.toString().getBytes(StandardCharsets.UTF_8);
                                        http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                                        http.connect();
                                        OutputStream os = http.getOutputStream();
                                        os.write(out);
                                        return true;
                                    }
                                    catch (IOException urlException) {
                                        urlException.printStackTrace();
                                        return false;
                                    }
                                }

                                @Override
                                @NotNull
                                public String getApiKey() {
                                    return apiKey;
                                }

                                @Override
                                @NotNull
                                public PasteOptions getOptions() {
                                    return this.options;
                                }

                                @Override
                                public PasteResponse read(String id) {
                                    return () -> {
                                        String response = "Unable to receive proper response.";
                                        try {
                                            URL url = new URL("https://pastebin.com/api/api_post.php");
                                            URLConnection con = url.openConnection();
                                            HttpURLConnection http = (HttpURLConnection)con;
                                            http.setRequestMethod("POST");
                                            http.setDoOutput(true);
                                            http.setDoInput(true);
                                            HashMap<String, String> arguments = new HashMap<String, String>();
                                            arguments.put("api_dev_key", this.getApiKey());
                                            arguments.put("api_user_key", this.getId());
                                            arguments.put("api_option", "show_paste");
                                            arguments.put("api_paste_key", id);
                                            StringJoiner sj = new StringJoiner("&");
                                            for (Map.Entry entry : arguments.entrySet()) {
                                                sj.add(URLEncoder.encode((String)entry.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8"));
                                            }
                                            byte[] out = sj.toString().getBytes(StandardCharsets.UTF_8);
                                            http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                                            http.connect();
                                            OutputStream os = http.getOutputStream();
                                            os.write(out);
                                            InputStream is = http.getInputStream();
                                            return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                                        }
                                        catch (IOException urlException) {
                                            urlException.printStackTrace();
                                            return response;
                                        }
                                    };
                                }

                                @Override
                                public PasteResponse write(String ... info) {
                                    return () -> {
                                        String response = "Unable to receive proper response.";
                                        StringBuilder builder = new StringBuilder();
                                        for (String s : info) {
                                            builder.append(s).append("\n");
                                        }
                                        try {
                                            URL url = new URL("https://pastebin.com/api/api_post.php");
                                            URLConnection con = url.openConnection();
                                            HttpURLConnection http = (HttpURLConnection)con;
                                            http.setRequestMethod("POST");
                                            http.setDoOutput(true);
                                            http.setDoInput(true);
                                            HashMap<String, String> arguments = new HashMap<String, String>();
                                            arguments.put("api_dev_key", this.getApiKey());
                                            arguments.put("api_user_key", this.getId());
                                            arguments.put("api_option", "paste");
                                            arguments.put("api_paste_code", builder.toString());
                                            arguments.put("api_paste_private", this.getOptions().getVisibility().toString());
                                            arguments.put("api_paste_expire_date", this.getOptions().getExpiration().toString());
                                            arguments.put("api_paste_format", this.getOptions().getLanguage().get().toLowerCase(Locale.ROOT));
                                            if (this.getOptions().getFolder() != null) {
                                                arguments.put("api_folder_key", this.getOptions().getFolder().get());
                                            }
                                            StringJoiner sj = new StringJoiner("&");
                                            for (Map.Entry entry : arguments.entrySet()) {
                                                sj.add(URLEncoder.encode((String)entry.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8"));
                                            }
                                            byte[] out = sj.toString().getBytes(StandardCharsets.UTF_8);
                                            http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                                            http.connect();
                                            OutputStream os = http.getOutputStream();
                                            os.write(out);
                                            InputStream is = http.getInputStream();
                                            return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                                        }
                                        catch (IOException urlException) {
                                            urlException.printStackTrace();
                                            return response;
                                        }
                                    };
                                }

                                @Override
                                public PasteResponse write(Collection<? extends CharSequence> info) {
                                    return () -> {
                                        String response = "Unable to receive proper response.";
                                        StringBuilder builder = new StringBuilder();
                                        for (CharSequence s : info) {
                                            builder.append(s).append("\n");
                                        }
                                        try {
                                            URL url = new URL("https://pastebin.com/api/api_post.php");
                                            URLConnection con = url.openConnection();
                                            HttpURLConnection http = (HttpURLConnection)con;
                                            http.setRequestMethod("POST");
                                            http.setDoOutput(true);
                                            http.setDoInput(true);
                                            HashMap<String, String> arguments = new HashMap<String, String>();
                                            arguments.put("api_dev_key", this.getApiKey());
                                            arguments.put("api_user_key", this.getId());
                                            arguments.put("api_option", "paste");
                                            arguments.put("api_paste_code", builder.toString());
                                            arguments.put("api_paste_private", this.getOptions().getVisibility().toString());
                                            arguments.put("api_paste_expire_date", this.getOptions().getExpiration().toString());
                                            arguments.put("api_paste_format", this.getOptions().getLanguage().get().toLowerCase(Locale.ROOT));
                                            if (this.getOptions().getFolder() != null) {
                                                arguments.put("api_folder_key", this.getOptions().getFolder().get());
                                            }
                                            StringJoiner sj = new StringJoiner("&");
                                            for (Map.Entry entry : arguments.entrySet()) {
                                                sj.add(URLEncoder.encode((String)entry.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8"));
                                            }
                                            byte[] out = sj.toString().getBytes(StandardCharsets.UTF_8);
                                            http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                                            http.connect();
                                            OutputStream os = http.getOutputStream();
                                            os.write(out);
                                            InputStream is = http.getInputStream();
                                            return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                                        }
                                        catch (IOException urlException) {
                                            urlException.printStackTrace();
                                            return response;
                                        }
                                    };
                                }
                            };
                        }
                        catch (IOException urlException) {
                            urlException.printStackTrace();
                            return null;
                        }
                    }

                    @Override
                    public PasteResponse write(String ... info) {
                        return () -> {
                            String response = "Unable to receive proper response.";
                            StringBuilder builder = new StringBuilder();
                            for (String s : info) {
                                builder.append(s).append("\n");
                            }
                            try {
                                URL url = new URL("https://pastebin.com/api/api_post.php");
                                URLConnection con = url.openConnection();
                                HttpURLConnection http = (HttpURLConnection)con;
                                http.setRequestMethod("POST");
                                http.setDoOutput(true);
                                http.setDoInput(true);
                                HashMap<String, String> arguments = new HashMap<String, String>();
                                arguments.put("api_dev_key", this.getApiKey());
                                arguments.put("api_option", "paste");
                                arguments.put("api_paste_code", builder.toString());
                                arguments.put("api_paste_private", this.getOptions().getVisibility().toString());
                                arguments.put("api_paste_expire_date", this.getOptions().getExpiration().toString());
                                arguments.put("api_paste_format", this.getOptions().getLanguage().get().toLowerCase(Locale.ROOT));
                                if (this.getOptions().getFolder() != null) {
                                    arguments.put("api_folder_key", this.getOptions().getFolder().get());
                                }
                                StringJoiner sj = new StringJoiner("&");
                                for (Map.Entry entry : arguments.entrySet()) {
                                    sj.add(URLEncoder.encode((String)entry.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8"));
                                }
                                byte[] out = sj.toString().getBytes(StandardCharsets.UTF_8);
                                http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                                http.connect();
                                OutputStream os = http.getOutputStream();
                                os.write(out);
                                InputStream is = http.getInputStream();
                                return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                            }
                            catch (IOException urlException) {
                                urlException.printStackTrace();
                                return response;
                            }
                        };
                    }

                    @Override
                    public PasteResponse write(Collection<? extends CharSequence> info) {
                        return () -> {
                            String response = "Unable to receive proper response.";
                            StringBuilder builder = new StringBuilder();
                            for (CharSequence s : info) {
                                builder.append(s).append("\n");
                            }
                            try {
                                URL url = new URL("https://pastebin.com/api/api_post.php");
                                URLConnection con = url.openConnection();
                                HttpURLConnection http = (HttpURLConnection)con;
                                http.setRequestMethod("POST");
                                http.setDoOutput(true);
                                http.setDoInput(true);
                                HashMap<String, String> arguments = new HashMap<String, String>();
                                arguments.put("api_dev_key", this.getApiKey());
                                arguments.put("api_option", "paste");
                                arguments.put("api_paste_code", builder.toString());
                                arguments.put("api_paste_private", this.getOptions().getVisibility().toString());
                                arguments.put("api_paste_expire_date", this.getOptions().getExpiration().toString());
                                arguments.put("api_paste_format", this.getOptions().getLanguage().get().toLowerCase(Locale.ROOT));
                                if (this.getOptions().getFolder() != null) {
                                    arguments.put("api_folder_key", this.getOptions().getFolder().get());
                                }
                                StringJoiner sj = new StringJoiner("&");
                                for (Map.Entry entry : arguments.entrySet()) {
                                    sj.add(URLEncoder.encode((String)entry.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8"));
                                }
                                byte[] out = sj.toString().getBytes(StandardCharsets.UTF_8);
                                http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                                http.connect();
                                OutputStream os = http.getOutputStream();
                                os.write(out);
                                InputStream is = http.getInputStream();
                                return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                            }
                            catch (IOException urlException) {
                                urlException.printStackTrace();
                                return response;
                            }
                        };
                    }
                };
            }
        };
        ServiceFactory.getInstance().newLoader(PasteManager.class).supply(instance);
        return instance;
    }

    @NotNull
    public Hastebin newHaste();

    @Note(value="This method requires a unique api key! Make sure you have an account registered")
    @NotNull
    public @Note(value="This method requires a unique api key! Make sure you have an account registered") @NotNull Pastebin newPaste(@NotNull String var1);
}

