/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.net.http;

import com.github.sanctum.panther.net.http.HttpConsumer;
import com.github.sanctum.panther.net.http.HttpConsumerImpl;
import com.github.sanctum.panther.net.http.HttpGetter;
import com.github.sanctum.panther.net.http.HttpGetterImpl;
import com.github.sanctum.panther.net.http.HttpReducer;
import com.github.sanctum.panther.net.http.HttpReducerImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public final class HttpUtils {
    private HttpUtils() throws IllegalAccessException {
        throw new IllegalAccessException("This class must not be instantiated");
    }

    public static <T> HttpGetterBuilder<T> newGetBuilder(String url, Function<String, T> dataBuilder) {
        return new HttpGetterBuilder(url, dataBuilder);
    }

    public static final class ConsumerBuilder<T>
    extends HttpGetterBuilderBase<T, ConsumerBuilder<T>> {
        private final List<Consumer<T>> consumers = new LinkedList<Consumer<T>>();
        private boolean restrictMultipleUsage;

        private ConsumerBuilder(HttpGetterBuilder<T> stage1, Consumer<T> consumer) {
            super(stage1.getUrl(), stage1.getDataBuilder());
            this.subPath = stage1.subPath;
            this.arguments = stage1.arguments;
            this.consumers.add(consumer);
        }

        private ConsumerBuilder(HttpGetterBuilder<T> stage1, Collection<Consumer<T>> consumers) {
            super(stage1.getUrl(), stage1.getDataBuilder());
            this.subPath = stage1.subPath;
            this.arguments = stage1.arguments;
            this.consumers.addAll(consumers);
        }

        public ConsumerBuilder<T> addConsumers(Collection<Consumer<T>> consumers) {
            this.consumers.addAll(consumers);
            return this;
        }

        public ConsumerBuilder<T> addConsumer(Consumer<T> consumer) {
            this.consumers.add(consumer);
            return this;
        }

        public ConsumerBuilder<T> restrictMultipleUsage(boolean restrictMultipleUsage) {
            this.restrictMultipleUsage = restrictMultipleUsage;
            return this;
        }

        public HttpConsumer<T> build() {
            return new HttpConsumerImpl(this.getUrl(), this.subPath, this.arguments, this.getDataBuilder(), this.consumers, this.restrictMultipleUsage);
        }

        public HttpConsumer<T> buildAndLoad() {
            HttpConsumer<T> consumer = this.build();
            consumer.load();
            return consumer;
        }

        public HttpConsumer<T> buildAndConsume() {
            HttpConsumer<T> consumer = this.build();
            consumer.loadAndConsume();
            return consumer;
        }
    }

    public static final class ReducerBuilder<T, R>
    extends HttpGetterBuilderBase<T, ReducerBuilder<T, R>> {
        private final Function<T, R> processor;

        private ReducerBuilder(HttpGetterBuilder<T> stage1, Function<T, R> processor) {
            super(stage1.getUrl(), stage1.getDataBuilder());
            this.subPath = stage1.subPath;
            this.arguments = stage1.arguments;
            this.processor = processor;
        }

        public HttpReducer<T, R> build() {
            return new HttpReducerImpl(this.getUrl(), this.subPath, this.arguments, this.getDataBuilder(), this.processor);
        }

        public HttpReducer<T, R> buildAndLoad() {
            HttpReducer<T, R> result = this.build();
            result.load();
            return result;
        }

        public HttpReducer<T, R> buildAndProcess() {
            HttpReducer<T, R> result = this.build();
            result.load();
            result.process();
            return result;
        }

        public R buildToResult() {
            HttpReducer<T, R> reducer = this.build();
            reducer.load();
            reducer.process();
            return reducer.getResult();
        }
    }

    public static final class HttpGetterBuilder<T>
    extends HttpGetterBuilderBase<T, HttpGetterBuilder<T>> {
        private HttpGetterBuilder(String url, Function<String, T> dataBuilder) {
            super(url, dataBuilder);
        }

        public <R> ReducerBuilder<T, R> setProcessor(Function<T, R> processor) {
            return new ReducerBuilder(this, processor);
        }

        public ConsumerBuilder<T> addConsumers(Collection<Consumer<T>> consumers) {
            return new ConsumerBuilder(this, consumers);
        }

        public ConsumerBuilder<T> addConsumer(Consumer<T> consumer) {
            return new ConsumerBuilder(this, consumer);
        }

        public HttpGetter<T> build() {
            return new HttpGetterImpl(this.getUrl(), this.subPath, this.arguments, this.getDataBuilder());
        }

        public HttpGetter<T> buildAndLoad() {
            HttpGetter<T> getter = this.build();
            getter.load();
            return getter;
        }

        public T buildAndGet() {
            return this.build().loadAndGet();
        }
    }

    private static abstract class HttpGetterBuilderBase<T, B extends HttpGetterBuilderBase<T, B>> {
        private final String url;
        private final Function<String, T> dataBuilder;
        protected String subPath;
        protected Map<String, String> arguments = new HashMap<String, String>();

        private HttpGetterBuilderBase(String url, Function<String, T> dataBuilder) {
            this.url = url;
            if (dataBuilder == null) {
                throw new IllegalArgumentException("You must provide a data building Function!");
            }
            this.dataBuilder = dataBuilder;
        }

        public B setSubPath(String subPath) {
            this.subPath = subPath;
            return (B)this;
        }

        public B addArguments(Map<String, String> arguments) {
            this.arguments.putAll(arguments);
            return (B)this;
        }

        public B addArgument(String key, String value) {
            this.arguments.put(key, value);
            return (B)this;
        }

        protected Function<String, T> getDataBuilder() {
            return this.dataBuilder;
        }

        protected String getUrl() {
            return this.url;
        }
    }
}

