/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.net.http;

import com.github.sanctum.panther.net.http.HttpGetterImpl;
import com.github.sanctum.panther.net.http.HttpReducer;
import java.util.Map;
import java.util.function.Function;

class HttpReducerImpl<T, R>
extends HttpGetterImpl<T>
implements HttpReducer<T, R> {
    private final Function<T, R> processor;
    boolean processed;
    R processedData;

    HttpReducerImpl(String url, String subPath, Map<String, String> arguments, Function<String, T> dataBuilder, Function<T, R> processor) {
        super(url, subPath, arguments, dataBuilder);
        this.processor = processor;
    }

    @Override
    public void process() {
        this.validateLoaded();
        this.doProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProcess() {
        this.processedData = this.processor.apply(this.rawData);
        HttpReducerImpl httpReducerImpl = this;
        synchronized (httpReducerImpl) {
            this.processed = true;
        }
    }

    @Override
    public synchronized boolean isProcessed() {
        return this.processed;
    }

    @Override
    public R getResult() {
        this.validateLoaded();
        this.validateProcessed();
        return this.processedData;
    }

    @Override
    public R processAndGet() {
        this.validateLoaded();
        this.doProcess();
        return this.processedData;
    }

    @Override
    public R loadProcessAndGet() {
        this.load();
        this.doProcess();
        return this.processedData;
    }

    private void validateProcessed() throws IllegalStateException {
        if (!this.processed) {
            throw new IllegalStateException("Data is not processed yet!");
        }
    }
}

