/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.net.http;

import com.github.sanctum.panther.net.http.HttpGetter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.net.URIBuilder;

class HttpGetterImpl<T>
implements HttpGetter<T> {
    protected final String url;
    protected final String subPath;
    protected final Map<String, String> arguments;
    protected final Function<String, T> dataBuilder;
    boolean loaded;
    T rawData;

    public HttpGetterImpl(String url, String subPath, Map<String, String> arguments, Function<String, T> dataBuilder) {
        this.url = url;
        this.subPath = subPath;
        this.arguments = arguments;
        this.dataBuilder = dataBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() {
        try {
            URI uri;
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpGet request = new HttpGet(this.url);
            if (this.subPath != null) {
                request.setPath(this.subPath);
            }
            try {
                URIBuilder builder = new URIBuilder(request.getUri());
                this.arguments.forEach((arg_0, arg_1) -> ((URIBuilder)builder).addParameter(arg_0, arg_1));
                uri = builder.build();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return;
            }
            request.setUri(uri);
            try (CloseableHttpResponse response1 = httpclient.execute((ClassicHttpRequest)request);){
                System.out.println(response1.getCode() + " " + response1.getReasonPhrase());
                HttpEntity entity1 = response1.getEntity();
                BufferedReader connectionReader = new BufferedReader(new InputStreamReader(entity1.getContent(), StandardCharsets.UTF_8));
                String toParse = connectionReader.lines().collect(Collectors.joining(System.lineSeparator()));
                this.rawData = this.dataBuilder.apply(toParse);
                HttpGetterImpl httpGetterImpl = this;
                synchronized (httpGetterImpl) {
                    this.loaded = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            System.err.println("Site could not be loaded!");
            e.printStackTrace();
        }
    }

    @Override
    public T getData() {
        this.validateLoaded();
        return this.doGet();
    }

    protected T doGet() {
        return this.rawData;
    }

    @Override
    public T loadAndGet() {
        this.load();
        return this.doGet();
    }

    @Override
    public synchronized boolean isLoaded() {
        return this.loaded;
    }

    protected void validateLoaded() throws IllegalStateException {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Data is not loaded yet!");
        }
    }
}

