/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.net.http;

import com.github.sanctum.panther.net.http.HttpConsumer;
import com.github.sanctum.panther.net.http.HttpGetterImpl;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

class HttpConsumerImpl<T>
extends HttpGetterImpl<T>
implements HttpConsumer<T> {
    private final List<Consumer<T>> consumers;
    private final boolean restricted;
    private boolean consumed;

    HttpConsumerImpl(String url, String subPath, Map<String, String> arguments, Function<String, T> dataBuilder, List<Consumer<T>> consumers, boolean restricted) {
        super(url, subPath, arguments, dataBuilder);
        this.consumers = consumers;
        this.restricted = restricted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doConsume() {
        this.consumers.forEach(c -> c.accept(this.getData()));
        HttpConsumerImpl httpConsumerImpl = this;
        synchronized (httpConsumerImpl) {
            this.consumed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() {
        super.load();
        HttpConsumerImpl httpConsumerImpl = this;
        synchronized (httpConsumerImpl) {
            this.consumed = false;
        }
    }

    @Override
    public synchronized boolean isConsumed() {
        return this.restricted && this.consumed;
    }

    @Override
    public void consume() {
        this.validateLoaded();
        this.validateNotConsumed();
        this.doConsume();
    }

    @Override
    public void loadAndConsume() {
        this.load();
        this.doConsume();
    }

    private void validateNotConsumed() throws IllegalStateException {
        if (this.isConsumed()) {
            throw new IllegalStateException("Data has already been consumed");
        }
    }
}

