/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.file;

import com.github.sanctum.panther.annotation.AnnotationDiscovery;
import com.github.sanctum.panther.annotation.Ordinal;
import com.github.sanctum.panther.file.InvalidJsonAdapterException;
import com.github.sanctum.panther.file.JsonAdapter;
import com.github.sanctum.panther.file.Node;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

abstract class JsonAdapterInput<T>
implements JsonAdapter<T>,
JsonSerializer<T>,
JsonDeserializer<T> {
    protected final JsonAdapter<T> serializer;
    private final Gson gson = new GsonBuilder().create();

    protected JsonAdapterInput(JsonAdapter<T> serializer) {
        this.serializer = serializer;
    }

    public JsonElement serialize(T t, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject o = new JsonObject();
        if (this.getKey() == null) {
            throw new InvalidJsonAdapterException("Serializable data for JSON files must be annotated with NodePointer");
        }
        o.add(this.getKey(), this.write(t));
        return o;
    }

    public T deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        Map map = (Map)this.gson.fromJson(jsonElement, new TypeToken<Map<String, Object>>(){}.getType());
        return this.read(map);
    }

    public String getKey() {
        String test = AnnotationDiscovery.of(Node.Pointer.class, this.serializer).mapFromClass((r, u) -> r.value());
        return test != null ? test : AnnotationDiscovery.of(Node.Pointer.class, this.serializer.getSerializationSignature()).mapFromClass((r, u) -> r.value());
    }

    @Override
    public JsonElement write(T t) {
        return this.serializer.write(t);
    }

    @Override
    public T read(Map<String, Object> object) {
        return this.serializer.read(object);
    }

    @Ordinal(value=24)
    private String getPointer() {
        return AnnotationDiscovery.of(Node.Pointer.class, this.serializer).mapFromClass((annotation, source) -> annotation.value());
    }

    static class Impl<T>
    extends JsonAdapterInput<T> {
        protected Impl(JsonAdapter<T> serializer) {
            super(serializer);
        }

        @Override
        public Class<? extends T> getSerializationSignature() {
            return this.serializer.getSerializationSignature();
        }

        @Override
        @Ordinal(value=24)
        private String getPointer() {
            return ((JsonAdapterInput)this).getPointer();
        }
    }
}

