/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.file;

import com.github.sanctum.panther.container.PantherEntryMap;
import com.github.sanctum.panther.container.PantherMap;
import com.github.sanctum.panther.file.Configurable;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurableEditorQuery {
    static final PantherMap<String, Map<String, Configurable.Editor>> CACHE = new PantherEntryMap<String, Map<String, Configurable.Editor>>();
    static final PantherMap<String, ConfigurableEditorQuery> REGISTRY = new PantherEntryMap<String, ConfigurableEditorQuery>();
    private final Configurable.Host host;

    ConfigurableEditorQuery(Configurable.Host host) {
        this.host = host;
    }

    public Configurable.Host getHost() {
        return this.host;
    }

    public List<Configurable.Editor> gather() {
        return (List)Optional.ofNullable(CACHE.get(this.host.getName())).map(Map::values).map(ImmutableList::copyOf).orElse(ImmutableList.of());
    }

    public void join(@NotNull Configurable configurable) {
        ConfigurableEditorQuery.cacheFileManager(new Configurable.Editor(this.host, configurable));
    }

    @NotNull
    public Configurable.Editor get(@NotNull String name) throws IllegalArgumentException {
        return this.get(name, (String)null);
    }

    @NotNull
    public Configurable.Editor get(@NotNull String name, @Nullable String desc) throws IllegalArgumentException {
        return this.get(name, desc, Configurable.Type.YAML);
    }

    @NotNull
    public Configurable.Editor get(@NotNull String name, Configurable.Extension data) throws IllegalArgumentException {
        return this.get(name, null, data);
    }

    <T> T test(T o) {
        if (o != null) {
            System.out.println("Grabbing cached editor");
        }
        return o;
    }

    @NotNull
    public Configurable.Editor get(@NotNull String name, @Nullable String desc, Configurable.Extension type) throws IllegalArgumentException {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name cannot be empty!");
        }
        return Optional.ofNullable(CACHE.get(this.host.getName())).map(m -> (Configurable.Editor)this.test(m.get(ConfigurableEditorQuery.fixNullDescription(desc) + ';' + name))).filter(m -> type.getClass().isAssignableFrom(m.getRoot().getType().getClass())).orElseGet(() -> ConfigurableEditorQuery.cacheFileManager(new Configurable.Editor(this.host, name, desc, type)));
    }

    public boolean exists(@NotNull String name, @Nullable String desc) {
        return this.exists(name, desc, Configurable.Type.YAML);
    }

    public boolean exists(@NotNull String name, @Nullable String desc, @NotNull Configurable.Extension extension) {
        File parent;
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name cannot be empty!");
        }
        File file = parent = desc == null || desc.isEmpty() ? this.host.getDataFolder() : new File(this.host.getDataFolder(), desc);
        if (!parent.exists()) {
            return false;
        }
        File test = new File(parent, name.concat(extension.get()));
        return test.exists();
    }

    static String fixNullDescription(String d) {
        if (d == null) {
            return "?";
        }
        return d;
    }

    static Configurable.Editor cacheFileManager(Configurable.Editor fileManager) {
        if (CACHE.containsKey(fileManager.host.getName())) {
            Map<String, Configurable.Editor> map = CACHE.get(fileManager.host.getName());
            map.putIfAbsent(ConfigurableEditorQuery.fixNullDescription(fileManager.configuration.getDirectory()) + ";" + fileManager.configuration.getName(), fileManager);
        } else {
            ((Map)CACHE.put(fileManager.host.getName(), new ConcurrentHashMap())).put(fileManager.configuration.getDirectory() + ';' + fileManager.configuration.getName(), fileManager);
        }
        return fileManager;
    }
}

