/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.container;

import java.util.Map;
import org.jetbrains.annotations.NotNull;

public interface PantherEntry<K, V> {
    @NotNull
    public K getKey();

    public V getValue();

    @NotNull
    public static <K, V> PantherEntry<K, V> of(final K k, final V v) {
        return new PantherEntry<K, V>(){

            @Override
            @NotNull
            public K getKey() {
                return k;
            }

            @Override
            public V getValue() {
                return v;
            }

            public String toString() {
                return "Entry{key=" + k + ", value=" + v + "}";
            }
        };
    }

    public static interface Modifiable<K, V>
    extends PantherEntry<K, V>,
    Map.Entry<K, V> {
        @NotNull
        public static <K, V> Modifiable<K, V> of(final K key, final V value) {
            return new Modifiable<K, V>(){
                private final K k;
                private V v;
                {
                    this.k = key;
                    this.v = value;
                }

                @Override
                public V setValue(V value2) {
                    this.v = value2;
                    return this.v;
                }

                @Override
                @NotNull
                public K getKey() {
                    return this.k;
                }

                @Override
                public V getValue() {
                    return this.v;
                }

                public String toString() {
                    return "Entry{key=" + this.k + ", value=" + this.v + "}";
                }
            };
        }
    }
}

