/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.task;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public abstract class JoinableRepeatingTask<T> {
    private final Set<T> observers = new HashSet<T>();
    private final int runInterval;
    private final Plugin host;
    private BukkitTask task;

    protected JoinableRepeatingTask(int runInterval, Plugin host) {
        this.runInterval = runInterval;
        this.host = host;
    }

    public synchronized void joinTask(T type) {
        this.observers.add(type);
        if (this.task == null) {
            this.start();
        }
    }

    public synchronized void leaveTask(T type) {
        this.observers.remove(type);
        if (this.observers.isEmpty()) {
            this.stop();
        }
    }

    private void start() {
        this.task = Bukkit.getScheduler().runTaskTimer(this.host, this::run, (long)this.runInterval, (long)this.runInterval);
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    private synchronized void run() {
        this.observers.forEach(this::executeTask);
    }

    protected abstract void executeTask(T var1);

    public static <T> JoinableRepeatingTask<T> create(int runInterval, Plugin host, final Consumer<T> task) {
        return new JoinableRepeatingTask<T>(runInterval, host){

            @Override
            protected void executeTask(T type) {
                task.accept(type);
            }
        };
    }
}

