/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.task;

import com.github.sanctum.panther.util.Task;
import com.github.sanctum.panther.util.TaskPredicate;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public interface BukkitTaskPredicate<T extends Task>
extends TaskPredicate<T> {
    @Override
    public boolean accept(T var1);

    public static <T extends Task> BukkitTaskPredicate<T> cancelEmpty() {
        return task -> {
            if (Bukkit.getOnlinePlayers().size() == 0) {
                task.cancel();
                return false;
            }
            return true;
        };
    }

    public static <T extends Task> BukkitTaskPredicate<T> cancelAfter(final int count) {
        return new BukkitTaskPredicate<T>(){
            private int i;
            {
                this.i = count;
            }

            @Override
            public boolean accept(Task task) {
                if (this.i == 0) {
                    task.cancel();
                    return false;
                }
                --this.i;
                return true;
            }
        };
    }

    public static <T extends Task> BukkitTaskPredicate<T> cancelAfter(Player target) {
        return task -> {
            if (target == null || !target.isOnline()) {
                task.cancel();
                return false;
            }
            return true;
        };
    }

    public static <T extends Task> BukkitTaskPredicate<T> cancelAfter(Function<T, Boolean> consumer) {
        return consumer::apply;
    }

    public static <T extends Task> BukkitTaskPredicate<T> reduceEmpty() {
        return new BukkitTaskPredicate<T>(){
            private final Object LOCK_OBJ = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean accept(Task task) {
                Object object = this.LOCK_OBJ;
                synchronized (object) {
                    if (Bukkit.getOnlinePlayers().size() == 0) {
                        return false;
                    }
                }
                return true;
            }
        };
    }
}

