/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.permissions.impl;

import com.github.sanctum.labyrinth.data.service.PlayerSearch;
import com.github.sanctum.labyrinth.permissions.Permissions;
import com.github.sanctum.labyrinth.permissions.entity.Group;
import com.github.sanctum.labyrinth.permissions.entity.Inheritance;
import com.github.sanctum.labyrinth.permissions.entity.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultImplementation
implements Permissions {
    static RegisteredServiceProvider<net.milkbowl.vault.permission.Permission> api;
    final Map<String, User> users = new HashMap<String, User>();
    final Map<String, Group> groups = new HashMap<String, Group>();

    public VaultImplementation() {
        api = Bukkit.getServicesManager().getRegistrations(net.milkbowl.vault.permission.Permission.class).stream().min(RegisteredServiceProvider::compareTo).orElse(null);
    }

    @Override
    public Plugin getProvider() {
        return api.getPlugin();
    }

    @Override
    public boolean isMultiWorld() {
        return false;
    }

    @Override
    public boolean isSuperPerms() {
        return ((net.milkbowl.vault.permission.Permission)api.getProvider()).hasSuperPermsCompat();
    }

    @Override
    public boolean isGroupsAllowed() {
        return ((net.milkbowl.vault.permission.Permission)api.getProvider()).hasGroupSupport();
    }

    @Override
    public User getUser(OfflinePlayer player) {
        return this.users.computeIfAbsent(player.getName(), x$0 -> new UserImpl((String)x$0));
    }

    @Override
    public Group getGroup(String name) {
        return this.groups.computeIfAbsent(name, GroupImpl::new);
    }

    @Override
    public User[] getUsers() {
        if (this.users.isEmpty()) {
            for (PlayerSearch lookup : PlayerSearch.values()) {
                this.getUser(lookup.getPlayer());
            }
        }
        return this.users.values().toArray(new User[0]);
    }

    @Override
    public Group[] getGroups() {
        if (this.groups.isEmpty()) {
            for (String g : ((net.milkbowl.vault.permission.Permission)api.getProvider()).getGroups()) {
                this.getGroup(g);
            }
        }
        return this.groups.values().toArray(new Group[0]);
    }

    class UserImpl
    implements User {
        private final PlayerSearch user;
        private final Inheritance groupInheritance;

        UserImpl(String name) {
            this.user = PlayerSearch.of(name);
            this.groupInheritance = new UserInheritance(this.user);
        }

        @Override
        public PlayerSearch toLabyrinth() {
            return this.user;
        }

        @Override
        public Group getGroup() {
            return VaultImplementation.this.getGroup(((net.milkbowl.vault.permission.Permission)api.getProvider()).getPrimaryGroup(((World)Bukkit.getWorlds().get(0)).getName(), this.user.getPlayer()));
        }

        @Override
        public Group getGroup(String world) {
            return VaultImplementation.this.getGroup(((net.milkbowl.vault.permission.Permission)api.getProvider()).getPrimaryGroup(world, this.user.getPlayer()));
        }

        @Override
        public boolean has(String node) {
            return ((net.milkbowl.vault.permission.Permission)api.getProvider()).playerHas(((World)Bukkit.getWorlds().get(0)).getName(), this.user.getPlayer(), node);
        }

        @Override
        public boolean has(String node, String world) {
            return ((net.milkbowl.vault.permission.Permission)api.getProvider()).playerHas(world, this.user.getPlayer(), node);
        }

        @Override
        public boolean give(String node) {
            return ((net.milkbowl.vault.permission.Permission)api.getProvider()).playerAdd(((World)Bukkit.getWorlds().get(0)).getName(), this.user.getPlayer(), node);
        }

        @Override
        public boolean give(String node, String world) {
            return ((net.milkbowl.vault.permission.Permission)api.getProvider()).playerAdd(world, this.user.getPlayer(), node);
        }

        @Override
        public boolean take(String node) {
            return ((net.milkbowl.vault.permission.Permission)api.getProvider()).playerRemove(((World)Bukkit.getWorlds().get(0)).getName(), this.user.getPlayer(), node);
        }

        @Override
        public boolean take(String node, String world) {
            return ((net.milkbowl.vault.permission.Permission)api.getProvider()).playerRemove(world, this.user.getPlayer(), node);
        }

        @Override
        public String[] getPermissions() {
            return new String[0];
        }

        @Override
        public String[] getPermissions(String world) {
            return new String[0];
        }

        @Override
        public Inheritance getInheritance() {
            return this.groupInheritance;
        }
    }

    static class GroupInheritance
    implements Inheritance {
        private final String name;

        GroupInheritance(String name) {
            this.name = name;
        }

        @Override
        public Group[] getSubGroups() {
            return new Group[0];
        }

        @Override
        public Group[] getSubGroups(String world) {
            return new Group[0];
        }

        @Override
        public boolean has(String group) {
            return false;
        }

        @Override
        public boolean has(String group, String world) {
            return false;
        }

        @Override
        public boolean has(Permission node) {
            return false;
        }

        @Override
        public boolean has(Permission node, String world) {
            return false;
        }

        @Override
        public boolean give(String group) {
            return false;
        }

        @Override
        public boolean give(String group, String world) {
            return false;
        }

        @Override
        public boolean take(String group) {
            return false;
        }

        @Override
        public boolean take(String group, String world) {
            return false;
        }
    }

    class UserInheritance
    implements Inheritance {
        private final PlayerSearch user;

        UserInheritance(PlayerSearch user) {
            this.user = user;
        }

        @Override
        public Group[] getSubGroups() {
            ArrayList<Group> groups = new ArrayList<Group>();
            for (String playerGroup : ((net.milkbowl.vault.permission.Permission)api.getProvider()).getPlayerGroups(((World)Bukkit.getWorlds().get(0)).getName(), this.user.getPlayer())) {
                Group g = VaultImplementation.this.getGroup(playerGroup);
                if (g == null) continue;
                groups.add(g);
            }
            return groups.toArray(new Group[0]);
        }

        @Override
        public Group[] getSubGroups(String world) {
            ArrayList<Group> groups = new ArrayList<Group>();
            for (String playerGroup : ((net.milkbowl.vault.permission.Permission)api.getProvider()).getPlayerGroups(world, this.user.getPlayer())) {
                Group g = VaultImplementation.this.getGroup(playerGroup);
                if (g == null) continue;
                groups.add(g);
            }
            return groups.toArray(new Group[0]);
        }

        @Override
        public boolean has(String group) {
            return ((net.milkbowl.vault.permission.Permission)api.getProvider()).playerInGroup(((World)Bukkit.getWorlds().get(0)).getName(), this.user.getPlayer(), group);
        }

        @Override
        public boolean has(String group, String world) {
            return ((net.milkbowl.vault.permission.Permission)api.getProvider()).playerInGroup(world, this.user.getPlayer(), group);
        }

        @Override
        public boolean has(Permission node) {
            return ((net.milkbowl.vault.permission.Permission)api.getProvider()).has(this.user.getPlayer().getPlayer(), node.getName());
        }

        @Override
        public boolean has(Permission node, String world) {
            return this.has(node);
        }

        @Override
        public boolean give(String group) {
            return ((net.milkbowl.vault.permission.Permission)api.getProvider()).playerAddGroup(((World)Bukkit.getWorlds().get(0)).getName(), this.user.getPlayer(), group);
        }

        @Override
        public boolean give(String group, String world) {
            return ((net.milkbowl.vault.permission.Permission)api.getProvider()).playerAddGroup(world, this.user.getPlayer(), group);
        }

        @Override
        public boolean take(String group) {
            return ((net.milkbowl.vault.permission.Permission)api.getProvider()).playerRemoveGroup(((World)Bukkit.getWorlds().get(0)).getName(), this.user.getPlayer(), group);
        }

        @Override
        public boolean take(String group, String world) {
            return ((net.milkbowl.vault.permission.Permission)api.getProvider()).playerRemoveGroup(world, this.user.getPlayer(), group);
        }
    }

    static class GroupImpl
    implements Group {
        private final String name;
        private final Inheritance groupInheritance;

        public GroupImpl(String name) {
            this.name = name;
            this.groupInheritance = new GroupInheritance(name);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean has(String node) {
            return ((net.milkbowl.vault.permission.Permission)api.getProvider()).groupHas(((World)Bukkit.getWorlds().get(0)).getName(), this.name, node);
        }

        @Override
        public boolean has(String node, String world) {
            return ((net.milkbowl.vault.permission.Permission)api.getProvider()).groupHas(world, this.name, node);
        }

        @Override
        public boolean give(String node) {
            return ((net.milkbowl.vault.permission.Permission)api.getProvider()).groupAdd(((World)Bukkit.getWorlds().get(0)).getName(), this.name, node);
        }

        @Override
        public boolean give(String node, String world) {
            return ((net.milkbowl.vault.permission.Permission)api.getProvider()).groupAdd(world, this.name, node);
        }

        @Override
        public boolean take(String node) {
            return ((net.milkbowl.vault.permission.Permission)api.getProvider()).groupRemove(((World)Bukkit.getWorlds().get(0)).getName(), this.name, node);
        }

        @Override
        public boolean take(String node, String world) {
            return ((net.milkbowl.vault.permission.Permission)api.getProvider()).groupRemove(world, this.name, node);
        }

        @Override
        public String[] getPermissions() {
            return new String[0];
        }

        @Override
        public String[] getPermissions(String world) {
            return new String[0];
        }

        @Override
        public Inheritance getInheritance() {
            return this.groupInheritance;
        }
    }
}

