/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import com.github.sanctum.labyrinth.data.service.PlayerSearch;
import com.github.sanctum.labyrinth.library.CommandUtils;
import com.github.sanctum.labyrinth.library.VaultGroup;
import com.github.sanctum.panther.util.Check;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;

public class VaultPlayer {
    private static final List<VaultPlayer> CACHE = new LinkedList<VaultPlayer>();
    private final PlayerSearch player;

    static net.milkbowl.vault.permission.Permission getPerms() {
        return (net.milkbowl.vault.permission.Permission)Bukkit.getServicesManager().load(net.milkbowl.vault.permission.Permission.class);
    }

    protected VaultPlayer(@NotNull OfflinePlayer player) {
        if (player == null) {
            VaultPlayer.$$$reportNull$$$0(0);
        }
        this.player = PlayerSearch.of(Check.forNull(player.getName(), "Invalid user provided! Name cannot be null"));
    }

    protected VaultPlayer(@NotNull PlayerSearch player) {
        if (player == null) {
            VaultPlayer.$$$reportNull$$$0(1);
        }
        this.player = player;
    }

    public static VaultPlayer wrap(OfflinePlayer player) {
        VaultPlayer play = CACHE.stream().filter(p -> p.player.getName().equals(player.getName())).findFirst().orElse(null);
        if (play != null) {
            return play;
        }
        VaultPlayer pl = new VaultPlayer(player);
        CACHE.add(pl);
        return pl;
    }

    public static VaultPlayer wrap(PlayerSearch player) {
        VaultPlayer play = CACHE.stream().filter(p -> p.player.getId().equals(player.getId())).findFirst().orElse(null);
        if (play != null) {
            return play;
        }
        VaultPlayer pl = new VaultPlayer(player);
        CACHE.add(pl);
        return pl;
    }

    public VaultGroup getGroup(String world) {
        if (VaultPlayer.getPerms() == null) {
            return new VaultGroup("no-vault", world);
        }
        return new VaultGroup(VaultPlayer.getPerms().getPrimaryGroup(world, this.player.getPlayer()), world);
    }

    public VaultGroup[] getGroups(String world) {
        if (VaultPlayer.getPerms() == null) {
            return new VaultGroup[]{new VaultGroup("no-vault", world)};
        }
        return (VaultGroup[])Arrays.stream(VaultPlayer.getPerms().getPlayerGroups(world, this.player.getPlayer())).map(s -> new VaultGroup((String)s, world)).toArray(VaultGroup[]::new);
    }

    public boolean has(Permission permission, String world) {
        if (VaultPlayer.getPerms() == null) {
            return false;
        }
        return VaultPlayer.getPerms().playerHas(world, this.player.getPlayer(), permission.getName());
    }

    public boolean give(Permission permission, String world) {
        if (VaultPlayer.getPerms() == null) {
            return false;
        }
        return VaultPlayer.getPerms().playerAdd(world, this.player.getPlayer(), permission.getName());
    }

    public boolean take(Permission permission, String world) {
        if (VaultPlayer.getPerms() == null) {
            return false;
        }
        return VaultPlayer.getPerms().playerRemove(world, this.player.getPlayer(), permission.getName());
    }

    public boolean has(String permission, String world) {
        if (VaultPlayer.getPerms() == null) {
            return false;
        }
        return VaultPlayer.getPerms().playerHas(world, this.player.getPlayer(), permission);
    }

    public boolean give(String permission, String world) {
        if (VaultPlayer.getPerms() == null) {
            return false;
        }
        return VaultPlayer.getPerms().playerAdd(world, this.player.getPlayer(), permission);
    }

    public boolean take(String permission, String world) {
        if (VaultPlayer.getPerms() == null) {
            return false;
        }
        return VaultPlayer.getPerms().playerRemove(world, this.player.getPlayer(), permission);
    }

    public Permission[] getKnownPermissions(String world) {
        LinkedList<Permission> perms = new LinkedList<Permission>();
        for (String cmd : CommandUtils.getServerCommandListing()) {
            Command command = CommandUtils.getCommandByLabel(cmd);
            if (command == null || command.getPermission() == null || !this.has(command.getPermission(), world)) continue;
            perms.add(new Permission(command.getPermission(), command.getDescription()));
        }
        return perms.toArray(new Permission[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "player", "com/github/sanctum/labyrinth/library/VaultPlayer", "<init>"));
    }
}

