/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import com.github.sanctum.labyrinth.library.CommandUtils;
import com.github.sanctum.labyrinth.library.VaultPlayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.permissions.Permission;

public class VaultGroup {
    private static final List<VaultGroup> LIST = VaultPlayer.getPerms() != null ? Arrays.stream(VaultPlayer.getPerms().getGroups()).map(s -> new VaultGroup((String)s, ((World)Bukkit.getWorlds().get(0)).getName())).collect(Collectors.toList()) : new ArrayList<VaultGroup>();
    private final String name;
    private final String world;

    protected VaultGroup(String name, String world) {
        this.name = name;
        this.world = world;
    }

    public static List<VaultGroup> getAll() {
        return LIST;
    }

    public static Optional<VaultGroup> get(String name) {
        return LIST.stream().filter(g -> g.getName().equalsIgnoreCase(name)).findFirst();
    }

    public String getName() {
        return this.name;
    }

    public World getWorld() {
        return Bukkit.getWorld((String)this.world);
    }

    public boolean has(Permission permission) {
        if (VaultPlayer.getPerms() == null) {
            return false;
        }
        return VaultPlayer.getPerms().groupHas(this.getWorld(), this.getName(), permission.getName());
    }

    public boolean has(String permission) {
        if (VaultPlayer.getPerms() == null) {
            return false;
        }
        return VaultPlayer.getPerms().groupHas(this.getWorld(), this.getName(), permission);
    }

    public boolean give(String permission) {
        if (VaultPlayer.getPerms() == null) {
            return false;
        }
        return VaultPlayer.getPerms().groupAdd(this.getWorld(), this.getName(), permission);
    }

    public boolean give(Permission permission) {
        if (VaultPlayer.getPerms() == null) {
            return false;
        }
        return VaultPlayer.getPerms().groupAdd(this.getWorld(), this.getName(), permission.getName());
    }

    public boolean take(String permission) {
        if (VaultPlayer.getPerms() == null) {
            return false;
        }
        return VaultPlayer.getPerms().groupRemove(this.getWorld(), this.getName(), permission);
    }

    public boolean take(Permission permission) {
        if (VaultPlayer.getPerms() == null) {
            return false;
        }
        return VaultPlayer.getPerms().groupRemove(this.getWorld(), this.getName(), permission.getName());
    }

    public Permission[] getKnownPermissions() {
        LinkedList<Permission> perms = new LinkedList<Permission>();
        for (String cmd : CommandUtils.getServerCommandListing()) {
            Command command = CommandUtils.getCommandByLabel(cmd);
            if (command == null || command.getPermission() == null || !VaultPlayer.getPerms().groupHas(this.getWorld(), this.getName(), command.getPermission())) continue;
            perms.add(new Permission(command.getPermission(), command.getDescription()));
        }
        return perms.toArray(new Permission[0]);
    }
}

