/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import com.github.sanctum.labyrinth.library.TimeWatch;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class TimeUtils {
    public static boolean timeElapsed(long date, long time, TimeUnit threshold) {
        return TimeWatch.start(date).isGreaterThan(threshold, time);
    }

    public static boolean isSecondsSince(Date date, long seconds) {
        return TimeUtils.timeElapsed(date.getTime(), seconds, TimeUnit.SECONDS);
    }

    public static boolean isMinutesSince(Date date, long minutes) {
        return TimeUtils.timeElapsed(date.getTime(), minutes, TimeUnit.MINUTES);
    }

    public static boolean isHoursSince(Date date, long hours) {
        return TimeUtils.timeElapsed(date.getTime(), hours, TimeUnit.HOURS);
    }

    public static boolean isDaysSince(Date date, long days) {
        return TimeUtils.timeElapsed(date.getTime(), days, TimeUnit.DAYS);
    }
}

