/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.formatting.component.NewComponent;
import com.github.sanctum.labyrinth.formatting.component.OldComponent;
import com.github.sanctum.labyrinth.formatting.component.WrappedComponent;
import com.github.sanctum.labyrinth.library.StringUtils;
import com.github.sanctum.panther.util.Applicable;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public abstract class TextLib {
    private static TextLib instance = null;

    protected TextLib() {
    }

    public WrappedComponent wrap(TextComponent component) {
        return new WrappedComponent(component);
    }

    public TextComponent execute(Applicable action, TextComponent component) {
        return this.wrap(component).accept(action).toReal();
    }

    public TextComponent execute(Applicable action, Consumer<TextComponent> component) {
        TextComponent comp = new TextComponent();
        component.accept(comp);
        return this.wrap(comp).accept(action).toReal();
    }

    public TextComponent format(Player source, Consumer<TextComponent> component, String ... messages) {
        TextComponent comp = new TextComponent();
        component.accept(comp);
        ArrayList<Text> array = new ArrayList<Text>();
        for (String msg : messages) {
            array.add(new Text(StringUtils.use(msg).translate((OfflinePlayer)source) + "\n"));
        }
        comp.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, array));
        return comp;
    }

    public TextComponent format(Player source, TextComponent component, String ... messages) {
        ArrayList<Text> array = new ArrayList<Text>();
        for (String msg : messages) {
            array.add(new Text(StringUtils.use(msg).translate((OfflinePlayer)source) + "\n"));
        }
        component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, array));
        return component;
    }

    public abstract TextComponent textHoverable(String var1, String var2, String var3);

    public abstract TextComponent textHoverable(String var1, String var2, String var3, String var4);

    public abstract TextComponent textHoverable(String var1, String var2, String var3, String var4, String var5, String var6);

    public abstract TextComponent textSuggestable(String var1, String var2, String var3, String var4);

    public abstract TextComponent textRunnable(String var1, String var2, String var3, String var4);

    public abstract TextComponent textRunnable(String var1, String var2, String var3, String var4, String var5);

    public abstract TextComponent textRunnable(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8);

    public abstract TextComponent textRunnable(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9);

    public abstract TextComponent textHoverable(OfflinePlayer var1, String var2, String var3, String var4);

    public abstract TextComponent textHoverable(OfflinePlayer var1, String var2, String var3, String var4, String var5);

    public abstract TextComponent textHoverable(OfflinePlayer var1, String var2, String var3, String var4, String var5, String var6, String var7);

    public abstract TextComponent textSuggestable(OfflinePlayer var1, String var2, String var3, String var4, String var5);

    public abstract TextComponent textRunnable(OfflinePlayer var1, String var2, String var3, String var4, String var5);

    public abstract TextComponent textRunnable(OfflinePlayer var1, String var2, String var3, String var4, String var5, String var6);

    public abstract TextComponent textRunnable(OfflinePlayer var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9);

    public abstract TextComponent textRunnable(OfflinePlayer var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10);

    public static void consume(Consumer<TextLib> library) {
        library.accept(TextLib.getInstance());
    }

    public static TextLib getInstance() {
        if (instance == null) {
            instance = LabyrinthProvider.getInstance().isNew() ? new NewComponent() : new OldComponent();
        }
        return instance;
    }
}

