/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.api.PlaceholderFormatService;
import com.github.sanctum.labyrinth.formatting.string.ColoredString;
import com.github.sanctum.labyrinth.formatting.string.CustomColor;
import com.github.sanctum.labyrinth.formatting.string.GradientColor;
import com.github.sanctum.labyrinth.library.IllegalTimeFormatException;
import com.github.sanctum.panther.util.ParsedTimeFormat;
import com.github.sanctum.panther.util.RandomID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public final class StringUtils {
    private static final PlaceholderFormatService formatService = LabyrinthProvider.getService(PlaceholderFormatService.class);
    private final String context;

    StringUtils(String context) {
        this.context = context;
    }

    public static StringUtils use(String context) {
        return new StringUtils(context);
    }

    public boolean containsAnd(CharSequence ... regex) {
        for (CharSequence c : regex) {
            if (this.containsIgnoreCase(c)) continue;
            return false;
        }
        return true;
    }

    public boolean containsIgnoreCase(CharSequence regex) {
        return Pattern.compile(Pattern.quote(regex.toString()), 2).matcher(this.context).find();
    }

    public boolean containsIgnoreCase(CharSequence ... regex) {
        for (CharSequence sequence : regex) {
            if (!this.containsIgnoreCase(sequence)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ParsedTimeFormat parseTime() throws IllegalTimeFormatException {
        Pattern pattern = Pattern.compile("(\\d+)(d|hr|m|s)");
        Matcher matcher = pattern.matcher(this.context);
        String days = null;
        String hours = null;
        String minutes = null;
        String seconds = null;
        while (matcher.find()) {
            switch (matcher.group(2)) {
                case "d": {
                    days = matcher.group(1);
                    break;
                }
                case "hr": {
                    hours = matcher.group(1);
                    break;
                }
                case "m": {
                    minutes = matcher.group(1);
                    break;
                }
                case "s": {
                    seconds = matcher.group(1);
                }
            }
        }
        if (days == null || hours == null || minutes == null || seconds == null) {
            throw new IllegalTimeFormatException("Time format cannot be empty!");
        }
        ParsedTimeFormat parsedTimeFormat = ParsedTimeFormat.of(Long.parseLong(days), Long.parseLong(hours), Long.parseLong(minutes), Long.parseLong(seconds));
        if (parsedTimeFormat == null) {
            StringUtils.$$$reportNull$$$0(0);
        }
        return parsedTimeFormat;
    }

    public String generateID(int size) {
        return new RandomID(size, this.context).generate();
    }

    public CustomColor gradient(CharSequence from, CharSequence to) {
        return new GradientColor(this.context, from, to);
    }

    public GradientColor modifiableGradient(CharSequence from, CharSequence to) {
        return new GradientColor(this.context, from, to);
    }

    public TextComponent toComponent() {
        return new ColoredString(this.context, ColoredString.ColorType.MC_COMPONENT).toComponent();
    }

    public String translate() {
        if (formatService != null) {
            return formatService.replaceAll(new ColoredString(this.context).toString(), null);
        }
        return new ColoredString(this.context).toString();
    }

    public String papi(OfflinePlayer source) {
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            return PlaceholderAPI.setPlaceholders((OfflinePlayer)source, (String)this.context);
        }
        return "{PAPI-MISSING}:" + this.context;
    }

    public String laby(OfflinePlayer source) {
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            return PlaceholderAPI.setPlaceholders((OfflinePlayer)source, (String)this.context);
        }
        if (formatService != null) {
            return formatService.replaceAll(this.context, source);
        }
        return "{LAP-MISSING}:" + this.context;
    }

    public String translate(OfflinePlayer source) {
        if (formatService != null) {
            return new ColoredString(formatService.replaceAll(this.context, source)).toString();
        }
        return this.translate();
    }

    public String replaceIgnoreCase(String regex, String replacement) {
        return Pattern.compile(regex, 82).matcher(this.context).replaceAll(Matcher.quoteReplacement(replacement));
    }

    public boolean isContained(Iterable<String> iterable) {
        for (String s : iterable) {
            if (!this.containsIgnoreCase((CharSequence)s)) continue;
            return true;
        }
        return false;
    }

    public boolean isContained(Iterable<String> iterable, String ... alts) {
        for (String s : iterable) {
            if (this.containsIgnoreCase((CharSequence)s)) {
                return true;
            }
            for (String alt : alts) {
                if (!Pattern.compile(Pattern.quote(alt), 2).matcher(s).find()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDouble() {
        try {
            Double.parseDouble(this.context);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public boolean isInt() {
        try {
            Integer.parseInt(this.context);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public boolean isLong() {
        try {
            Long.parseLong(this.context);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public boolean isFloat() {
        try {
            Float.parseFloat(this.context);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/sanctum/labyrinth/library/StringUtils", "parseTime"));
    }
}

