/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NamespacedKey {
    public static final String MINECRAFT = "minecraft";
    public static final String BUKKIT = "bukkit";
    private final String namespace;
    private final String key;

    @Deprecated
    public NamespacedKey(@NotNull String namespace, @NotNull String key) {
        if (namespace == null) {
            NamespacedKey.$$$reportNull$$$0(0);
        }
        if (key == null) {
            NamespacedKey.$$$reportNull$$$0(1);
        }
        this.namespace = namespace;
        this.key = key;
        String string = this.toString();
        if (string.length() > 256) {
            LabyrinthProvider.getInstance().getLogger().severe("- NamespacedKey must be less than 256 characters; " + string);
        }
    }

    public NamespacedKey(@NotNull(value="Plugin cannot be null!") @NotNull(value="Plugin cannot be null!") Plugin plugin, @NotNull String key) {
        if (plugin == null) {
            NamespacedKey.$$$reportNull$$$0(2);
        }
        if (key == null) {
            NamespacedKey.$$$reportNull$$$0(3);
        }
        this.namespace = plugin.getName().toLowerCase(Locale.ROOT);
        this.key = key.toLowerCase(Locale.ROOT);
        String string = this.toString();
        if (string.length() > 256) {
            LabyrinthProvider.getInstance().getLogger().severe("- NamespacedKey must be less than 256 characters; " + string);
        }
    }

    @NotNull
    public String getNamespace() {
        String string = this.namespace;
        if (string == null) {
            NamespacedKey.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getKey() {
        String string = this.key;
        if (string == null) {
            NamespacedKey.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    Plugin getNamespacePlugin() {
        return Arrays.stream(Bukkit.getPluginManager().getPlugins()).filter(plugin -> plugin.getName().toLowerCase(Locale.ROOT).equals(this.namespace)).findFirst().orElse(null);
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + this.namespace.hashCode();
        hash = 47 * hash + this.key.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamespacedKey other = (NamespacedKey)obj;
        return this.namespace.equals(other.namespace) && this.key.equals(other.key);
    }

    public String toString() {
        return this.namespace + ":" + this.key;
    }

    @Deprecated
    @NotNull
    public static NamespacedKey randomKey() {
        return new NamespacedKey(BUKKIT, UUID.randomUUID().toString());
    }

    @NotNull
    public static NamespacedKey minecraft(@NotNull String key) {
        if (key == null) {
            NamespacedKey.$$$reportNull$$$0(6);
        }
        return new NamespacedKey(MINECRAFT, key);
    }

    public static String toNamespace(@NotNull Plugin plugin) {
        if (plugin == null) {
            NamespacedKey.$$$reportNull$$$0(7);
        }
        return plugin.getName().toLowerCase(Locale.ROOT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "Plugin cannot be null!";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 0;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray = new Object[n2];
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[0] = "namespace";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray = objectArray;
                objectArray[0] = "key";
                break;
            }
            case 2: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[0] = "com/github/sanctum/labyrinth/library/NamespacedKey";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[0] = "plugin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[1] = "com/github/sanctum/labyrinth/library/NamespacedKey";
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[1] = "getNamespace";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = MINECRAFT;
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toNamespace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

