/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;

public final class MathUtils {
    private final Number n;

    MathUtils(Number n) {
        this.n = n;
    }

    public static MathUtils use(Number n) {
        return new MathUtils(n);
    }

    public double format(int precision) {
        BigDecimal b1 = BigDecimal.valueOf(this.n.doubleValue()).setScale(precision, RoundingMode.CEILING);
        return b1.doubleValue();
    }

    public String format(Locale locale) {
        return NumberFormat.getNumberInstance(locale).format(this.n.doubleValue());
    }

    public String format(Locale locale, int precision) {
        return NumberFormat.getNumberInstance(locale).format(this.format(precision));
    }

    public String formatCurrency(Locale locale) {
        return NumberFormat.getCurrencyInstance(locale).format(this.n.doubleValue());
    }
}

