/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.api.Service;
import com.github.sanctum.labyrinth.formatting.ComponentChunk;
import com.github.sanctum.labyrinth.formatting.FancyMessage;
import com.github.sanctum.labyrinth.formatting.TextChunk;
import com.github.sanctum.labyrinth.formatting.string.FormattedString;
import com.github.sanctum.labyrinth.library.MailType;
import com.github.sanctum.labyrinth.library.MailableContext;
import com.github.sanctum.labyrinth.library.MailerPrefix;
import com.github.sanctum.labyrinth.library.MailerResult;
import com.github.sanctum.labyrinth.library.StringUtils;
import com.github.sanctum.panther.util.Check;
import com.github.sanctum.panther.util.Deployable;
import com.github.sanctum.panther.util.DeployableMapping;
import com.github.sanctum.panther.util.HUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Mailer {
    private CommandSender sender;
    private final MailerPrefix prefix;
    private Plugin plugin;

    public Mailer() {
        this.plugin = LabyrinthProvider.getInstance().getPluginInstance();
        this.prefix = new MailerPrefix(this);
    }

    public Mailer(@NotNull CommandSender sender) {
        if (sender == null) {
            Mailer.$$$reportNull$$$0(0);
        }
        this.plugin = LabyrinthProvider.getInstance().getPluginInstance();
        this.sender = sender;
        this.prefix = new MailerPrefix(this);
    }

    public Mailer(@NotNull Plugin plugin) {
        if (plugin == null) {
            Mailer.$$$reportNull$$$0(1);
        }
        this.plugin = LabyrinthProvider.getInstance().getPluginInstance();
        this.plugin = plugin;
        this.prefix = new MailerPrefix(this);
    }

    public static Mailer empty() {
        return new Mailer();
    }

    public static Mailer empty(CommandSender sender) {
        return new Mailer(sender);
    }

    public static Mailer empty(Plugin plugin) {
        return new Mailer(plugin);
    }

    public Mailer accept(@NotNull CommandSender user) {
        if (user == null) {
            Mailer.$$$reportNull$$$0(2);
        }
        this.sender = user;
        return this;
    }

    public Mailer accept(@NotNull Plugin plugin) {
        if (plugin == null) {
            Mailer.$$$reportNull$$$0(3);
        }
        this.plugin = plugin;
        return this;
    }

    public MailerPrefix prefix() {
        return this.prefix;
    }

    public Deployable<Mailer> chat(@NotNull String text) {
        if (text == null) {
            Mailer.$$$reportNull$$$0(4);
        }
        if (!this.prefix.isEmpty()) {
            return new Mailable(this.sender, MailType.CHAT, this.prefix.join() + " " + text);
        }
        return new Mailable(this.sender, MailType.CHAT, text);
    }

    public Deployable<Mailer> chat(BaseComponent ... components) {
        if (components == null) {
            Mailer.$$$reportNull$$$0(5);
        }
        if (!this.prefix.isEmpty()) {
            BaseComponent[] comps = new FancyMessage().append(new TextChunk(this.prefix.join())).append(new TextChunk(" ")).append(new ComponentChunk(components)).build();
            return new Mailable(this.sender, MailType.CHAT, comps);
        }
        return new Mailable(this.sender, MailType.CHAT, components);
    }

    public Deployable<Mailer> action(@NotNull String text) {
        if (text == null) {
            Mailer.$$$reportNull$$$0(6);
        }
        if (!this.prefix.isEmpty()) {
            return new Mailable(this.sender, MailType.ACTION, this.prefix.join() + " " + text);
        }
        return new Mailable(this.sender, MailType.ACTION, text);
    }

    public Deployable<Mailer> action(BaseComponent ... components) {
        if (components == null) {
            Mailer.$$$reportNull$$$0(7);
        }
        if (!this.prefix.isEmpty()) {
            BaseComponent[] comps = new FancyMessage().append(new TextChunk(this.prefix.join())).append(new TextChunk(" ")).append(new ComponentChunk(components)).build();
            return new Mailable(this.sender, MailType.ACTION, comps);
        }
        return new Mailable(this.sender, MailType.ACTION, components);
    }

    public Deployable<Mailer> title(final @NotNull String title, final @Nullable String subtitle) {
        if (title == null) {
            Mailer.$$$reportNull$$$0(8);
        }
        return new Mailable(this.sender, MailType.TITLE, new MailableContext<String>(){

            @Override
            public String getString() {
                return title;
            }

            @Override
            public String getAttachment() {
                return subtitle;
            }
        });
    }

    public Deployable<Mailer> announce(final @NotNull Predicate<Player> predicate, @NotNull String message) {
        if (predicate == null) {
            Mailer.$$$reportNull$$$0(9);
        }
        if (message == null) {
            Mailer.$$$reportNull$$$0(10);
        }
        final String target = !this.prefix.isEmpty() ? this.prefix.join() + " " + message : message;
        return new Mailable((CommandSender)Bukkit.getConsoleSender(), MailType.BROADCAST, new MailableContext<Predicate<Player>>(){

            @Override
            public String getString() {
                return target;
            }

            @Override
            public Predicate<Player> getAttachment() {
                return predicate;
            }
        });
    }

    public Deployable<Mailer> announce(final @NotNull Predicate<Player> predicate, BaseComponent ... components) {
        if (predicate == null) {
            Mailer.$$$reportNull$$$0(11);
        }
        if (components == null) {
            Mailer.$$$reportNull$$$0(12);
        }
        if (!this.prefix.isEmpty()) {
            components = new FancyMessage().append(new TextChunk(this.prefix.join())).append(new TextChunk(" ")).append(new ComponentChunk(components)).build();
        }
        final @NotNull BaseComponent[] finalComponents = components;
        return new Mailable((CommandSender)Bukkit.getConsoleSender(), MailType.BROADCAST, new MailableContext<Predicate<Player>>(){

            @Override
            public String getString() {
                return new ComponentChunk(finalComponents).toJson();
            }

            @Override
            public Predicate<Player> getAttachment() {
                return predicate;
            }
        });
    }

    public Deployable<Mailer> info(@NotNull String text) {
        if (text == null) {
            Mailer.$$$reportNull$$$0(13);
        }
        return new Mailable(this.plugin, Level.INFO, text);
    }

    public Deployable<Mailer> warn(@NotNull String text) {
        if (text == null) {
            Mailer.$$$reportNull$$$0(14);
        }
        return new Mailable(this.plugin, Level.WARNING, text);
    }

    public Deployable<Mailer> error(@NotNull String text) {
        if (text == null) {
            Mailer.$$$reportNull$$$0(15);
        }
        return new Mailable(this.plugin, Level.SEVERE, text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/github/sanctum/labyrinth/library/Mailer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "chat";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "action";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "title";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "announce";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "info";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "warn";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    class Mailable
    implements Deployable<Mailer> {
        private final MailerResult result;
        private String text;
        private Level level;
        private BaseComponent[] components;
        private MailableContext<String> title;
        private MailableContext<Predicate<Player>> predicate;
        private MailType type;

        Mailable(CommandSender player, MailType type, MailableContext<?> context) {
            if (context.getAttachment() instanceof String) {
                this.title = context;
            } else {
                this.predicate = context;
            }
            this.result = new MailerResult(player);
            this.type = type;
        }

        Mailable(CommandSender player, MailType type, BaseComponent ... components) {
            this.result = new MailerResult(player);
            this.type = type;
            this.components = components;
        }

        Mailable(CommandSender player, MailType type, String text) {
            this.result = new MailerResult(player);
            this.type = type;
            this.text = text;
        }

        Mailable(Plugin plugin, Level level, String text) {
            this.result = new MailerResult(plugin);
            this.level = level;
            this.text = text;
        }

        @Override
        public Deployable<Mailer> deploy() {
            this.queue(0L);
            return this;
        }

        @Override
        public Deployable<Mailer> deploy(Consumer<? super Mailer> consumer) {
            this.deploy();
            consumer.accept(Mailer.this);
            return this;
        }

        @Override
        public Deployable<Mailer> queue() {
            this.queue(1L);
            return this;
        }

        @Override
        public Deployable<Mailer> queue(Consumer<? super Mailer> consumer, long timeout) {
            if (this.result.isForPlayer()) {
                if (timeout <= 0L) {
                    switch (this.type) {
                        case ACTION: {
                            if (this.text != null) {
                                ((Player)this.toSender(this.result.getSource())).spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)StringUtils.use(this.text).translate((OfflinePlayer)((Player)this.toSender(this.result.getSource())))));
                            } else {
                                ((Player)this.toSender(this.result.getSource())).spigot().sendMessage(ChatMessageType.ACTION_BAR, new FancyMessage().append(new ComponentChunk(this.components)).build());
                            }
                            consumer.accept(Mailer.this);
                            break;
                        }
                        case CHAT: {
                            if (this.components != null) {
                                ((Player)this.toSender(this.result.getSource())).spigot().sendMessage(this.components);
                            } else {
                                this.toSender(this.result.getSource()).sendMessage(StringUtils.use(this.text).translate((OfflinePlayer)((Player)this.toSender(this.result.getSource()))));
                            }
                            consumer.accept(Mailer.this);
                            break;
                        }
                        case BROADCAST: {
                            for (Player online : Bukkit.getOnlinePlayers()) {
                                if (!this.predicate.getAttachment().test(online)) continue;
                                if (Check.isJson(this.predicate.getString())) {
                                    BaseComponent[] base = new FancyMessage().append(this.predicate.getString()).build();
                                    online.spigot().sendMessage(base);
                                    continue;
                                }
                                online.sendMessage(StringUtils.use(this.predicate.getString()).translate((OfflinePlayer)((Player)this.toSender(this.result.getSource()))));
                            }
                            consumer.accept(Mailer.this);
                            break;
                        }
                        case TITLE: {
                            Player player = (Player)this.toSender(this.result.getSource());
                            if (this.title.getAttachment() != null) {
                                player.sendTitle(StringUtils.use(this.title.getString()).translate((OfflinePlayer)((Player)this.toSender(this.result.getSource()))), StringUtils.use(this.title.getAttachment()).translate((OfflinePlayer)((Player)this.toSender(this.result.getSource()))), 60, 60, 60);
                            } else {
                                player.sendTitle(StringUtils.use(this.title.getString()).translate((OfflinePlayer)((Player)this.toSender(this.result.getSource()))), "", 60, 60, 60);
                            }
                            consumer.accept(Mailer.this);
                        }
                    }
                } else {
                    switch (this.type) {
                        case ACTION: {
                            LabyrinthProvider.getService(Service.TASK).getScheduler(0).wait(() -> {
                                if (this.text != null) {
                                    ((Player)this.toSender(this.result.getSource())).spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)StringUtils.use(this.text).translate((OfflinePlayer)((Player)this.toSender(this.result.getSource())))));
                                } else {
                                    ((Player)this.toSender(this.result.getSource())).spigot().sendMessage(ChatMessageType.ACTION_BAR, new FancyMessage().append(new ComponentChunk(this.components)).build());
                                }
                                consumer.accept(Mailer.this);
                            }, HUID.randomID().toString(), timeout);
                        }
                        case CHAT: {
                            LabyrinthProvider.getService(Service.TASK).getScheduler(0).wait(() -> {
                                if (this.components != null) {
                                    ((Player)this.toSender(this.result.getSource())).spigot().sendMessage(this.components);
                                } else {
                                    this.toSender(this.result.getSource()).sendMessage(StringUtils.use(this.text).translate((OfflinePlayer)((Player)this.toSender(this.result.getSource()))));
                                }
                                consumer.accept(Mailer.this);
                            }, HUID.randomID().toString(), timeout);
                            break;
                        }
                        case BROADCAST: {
                            LabyrinthProvider.getService(Service.TASK).getScheduler(0).wait(() -> {
                                for (Player online : Bukkit.getOnlinePlayers()) {
                                    if (!this.predicate.getAttachment().test(online)) continue;
                                    if (Check.isJson(this.predicate.getString())) {
                                        BaseComponent[] base = new FancyMessage().append(this.predicate.getString()).build();
                                        online.spigot().sendMessage(base);
                                        continue;
                                    }
                                    online.sendMessage(new FormattedString(this.predicate.getString()).translate(this.result.getSource()).color().get());
                                }
                                consumer.accept(Mailer.this);
                            }, HUID.randomID().toString(), timeout);
                            break;
                        }
                        case TITLE: {
                            LabyrinthProvider.getService(Service.TASK).getScheduler(0).wait(() -> {
                                Player player = (Player)this.toSender(this.result.getSource());
                                if (this.title.getAttachment() != null) {
                                    player.sendTitle(StringUtils.use(this.title.getString()).translate((OfflinePlayer)((Player)this.toSender(this.result.getSource()))), StringUtils.use(this.title.getAttachment()).translate((OfflinePlayer)((Player)this.toSender(this.result.getSource()))), 60, 60, 60);
                                } else {
                                    player.sendTitle(StringUtils.use(this.title.getString()).translate((OfflinePlayer)((Player)this.toSender(this.result.getSource()))), "", 60, 60, 60);
                                }
                                consumer.accept(Mailer.this);
                            }, HUID.randomID().toString(), timeout);
                        }
                    }
                }
            } else {
                Plugin plugin = this.toPlugin(this.result.getSource());
                if (timeout <= 0L) {
                    plugin.getLogger().log(this.level, this.text);
                    consumer.accept(Mailer.this);
                } else {
                    LabyrinthProvider.getService(Service.TASK).getScheduler(0).wait(() -> {
                        plugin.getLogger().log(this.level, this.text);
                        consumer.accept(Mailer.this);
                    }, HUID.randomID().toString(), timeout);
                }
            }
            return this;
        }

        @Override
        public <O> DeployableMapping<O> map(@NotNull Function<? super Mailer, ? extends O> mapper) {
            if (mapper == null) {
                Mailable.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        public Deployable<Mailer> queue(long timeout) {
            block21: {
                block19: {
                    block20: {
                        if (!this.result.isForPlayer()) break block19;
                        if (timeout > 0L) break block20;
                        switch (this.type) {
                            case ACTION: {
                                if (this.text != null) {
                                    ((Player)this.toSender(this.result.getSource())).spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)StringUtils.use(this.text).translate((OfflinePlayer)((Player)this.toSender(this.result.getSource())))));
                                    break;
                                }
                                ((Player)this.toSender(this.result.getSource())).spigot().sendMessage(ChatMessageType.ACTION_BAR, new FancyMessage().append(new ComponentChunk(this.components)).build());
                                break;
                            }
                            case CHAT: {
                                if (this.components != null) {
                                    ((Player)this.toSender(this.result.getSource())).spigot().sendMessage(this.components);
                                    break;
                                }
                                this.toSender(this.result.getSource()).sendMessage(StringUtils.use(this.text).translate((OfflinePlayer)((Player)this.toSender(this.result.getSource()))));
                                break;
                            }
                            case BROADCAST: {
                                for (Player online : Bukkit.getOnlinePlayers()) {
                                    if (!this.predicate.getAttachment().test(online)) continue;
                                    if (Check.isJson(this.predicate.getString())) {
                                        BaseComponent[] base = new FancyMessage().append(this.predicate.getString()).build();
                                        online.spigot().sendMessage(base);
                                        continue;
                                    }
                                    online.sendMessage(new FormattedString(this.predicate.getString()).translate(this.result.getSource()).color().get());
                                }
                                break block21;
                            }
                            case TITLE: {
                                Player player = (Player)this.toSender(this.result.getSource());
                                if (this.title.getAttachment() != null) {
                                    player.sendTitle(StringUtils.use(this.title.getString()).translate((OfflinePlayer)((Player)this.toSender(this.result.getSource()))), StringUtils.use(this.title.getAttachment()).translate((OfflinePlayer)((Player)this.toSender(this.result.getSource()))), 60, 60, 60);
                                    break;
                                }
                                player.sendTitle(StringUtils.use(this.title.getString()).translate((OfflinePlayer)((Player)this.toSender(this.result.getSource()))), "", 60, 60, 60);
                            }
                        }
                        break block21;
                    }
                    switch (this.type) {
                        case ACTION: {
                            LabyrinthProvider.getService(Service.TASK).getScheduler(0).wait(() -> {
                                if (this.text != null) {
                                    ((Player)this.toSender(this.result.getSource())).spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)StringUtils.use(this.text).translate((OfflinePlayer)((Player)this.toSender(this.result.getSource())))));
                                } else {
                                    ((Player)this.toSender(this.result.getSource())).spigot().sendMessage(ChatMessageType.ACTION_BAR, new FancyMessage().append(new ComponentChunk(this.components)).build());
                                }
                            }, HUID.randomID().toString(), timeout);
                            break;
                        }
                        case CHAT: {
                            LabyrinthProvider.getService(Service.TASK).getScheduler(0).wait(() -> {
                                if (this.components != null) {
                                    if (this.toSender(this.result.getSource()) instanceof Player) {
                                        ((Player)this.toSender(this.result.getSource())).spigot().sendMessage(this.components);
                                    }
                                } else {
                                    this.toSender(this.result.getSource()).sendMessage(StringUtils.use(this.text).translate((OfflinePlayer)((Player)this.toSender(this.result.getSource()))));
                                }
                            }, HUID.randomID().toString(), timeout);
                            break;
                        }
                        case BROADCAST: {
                            LabyrinthProvider.getService(Service.TASK).getScheduler(0).wait(() -> {
                                for (Player online : Bukkit.getOnlinePlayers()) {
                                    if (!this.predicate.getAttachment().test(online)) continue;
                                    if (Check.isJson(this.predicate.getString())) {
                                        BaseComponent[] base = new FancyMessage().append(this.predicate.getString()).build();
                                        online.spigot().sendMessage(base);
                                        continue;
                                    }
                                    online.sendMessage(new FormattedString(this.predicate.getString()).translate(this.result.getSource()).color().get());
                                }
                            }, HUID.randomID().toString(), timeout);
                            break;
                        }
                        case TITLE: {
                            LabyrinthProvider.getService(Service.TASK).getScheduler(0).wait(() -> {
                                Player player = (Player)this.toSender(this.result.getSource());
                                if (this.title.getAttachment() != null) {
                                    player.sendTitle(StringUtils.use(this.title.getString()).translate((OfflinePlayer)((Player)this.toSender(this.result.getSource()))), StringUtils.use(this.title.getAttachment()).translate((OfflinePlayer)((Player)this.toSender(this.result.getSource()))), 60, 60, 60);
                                } else {
                                    player.sendTitle(StringUtils.use(this.title.getString()).translate((OfflinePlayer)((Player)this.toSender(this.result.getSource()))), "", 60, 60, 60);
                                }
                            }, HUID.randomID().toString(), timeout);
                        }
                    }
                    break block21;
                }
                Plugin plugin = this.toPlugin(this.result.getSource());
                if (timeout <= 0L) {
                    plugin.getLogger().log(this.level, this.text);
                } else {
                    LabyrinthProvider.getService(Service.TASK).getScheduler(0).wait(() -> plugin.getLogger().log(this.level, this.text), HUID.randomID().toString(), timeout);
                }
            }
            return this;
        }

        @Override
        public CompletableFuture<Mailer> submit() {
            return CompletableFuture.supplyAsync(() -> Mailer.this);
        }

        CommandSender toSender(Object o) {
            if (CommandSender.class.isAssignableFrom(o.getClass())) {
                return (CommandSender)o;
            }
            return null;
        }

        Plugin toPlugin(Object o) {
            if (Plugin.class.isAssignableFrom(o.getClass())) {
                return (Plugin)o;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/github/sanctum/labyrinth/library/Mailer$Mailable", "map"));
        }
    }
}

