/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import com.github.sanctum.labyrinth.library.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class ListUtils<T> {
    private LinkedList<T> list;

    protected ListUtils(List<T> list) {
        this.list = new LinkedList<T>(list);
    }

    public static <T> ListUtils<T> use(List<T> list) {
        return new ListUtils<T>(list);
    }

    public static <T> ListUtils<T> use(T[] list) {
        return new ListUtils<T>(Arrays.asList(list));
    }

    public List<T> append(Consumer<T> action) {
        ArrayList<T> array = new ArrayList<T>();
        for (int i = 0; i < this.list.size(); ++i) {
            T t = this.list.get(i);
            if (i != this.list.size() - 1) {
                action.accept(t);
            }
            array.add(t);
        }
        return array;
    }

    public List<T> append(ListOperation<T> object) {
        ArrayList<T> array = new ArrayList<T>();
        for (int i = 0; i < this.list.size(); ++i) {
            T t = this.list.get(i);
            if (i != this.list.size() - 1) {
                array.add(object.append(t));
                continue;
            }
            array.add(t);
        }
        return array;
    }

    public ListUtils<T> consume(Consumer<T> action) {
        ArrayList<T> array = new ArrayList<T>();
        for (int i = 0; i < this.list.size(); ++i) {
            T t = this.list.get(i);
            if (i != this.list.size() - 1) {
                action.accept(t);
            }
            array.add(t);
        }
        this.list = new LinkedList(array);
        return this;
    }

    public ListUtils<T> operate(ListOperation<T> object) {
        ArrayList<T> array = new ArrayList<T>();
        for (int i = 0; i < this.list.size(); ++i) {
            T t = this.list.get(i);
            if (i != this.list.size() - 1) {
                array.add(object.append(t));
                continue;
            }
            array.add(t);
        }
        this.list = new LinkedList(array);
        return this;
    }

    public ListUtils<T> insertFirst(T value) {
        this.list.addFirst(value);
        return this;
    }

    public ListUtils<T> insertLast(T value) {
        this.list.addLast(value);
        return this;
    }

    public List<T> addFirst(T value) {
        this.list.addFirst(value);
        return this.list;
    }

    public List<T> addLast(T value) {
        this.list.addLast(value);
        return this.list;
    }

    public <R> R join(Function<List<T>, R> fun) {
        return fun.apply(this.list);
    }

    public boolean stringContainsIgnoreCase(CharSequence sequence) {
        if (this.list.isEmpty()) {
            return false;
        }
        if (String.class.isAssignableFrom(this.list.get(0).getClass())) {
            for (Object s : this.list) {
                String context = s.toString();
                if (!StringUtils.use(context).containsIgnoreCase(sequence)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean stringContainsIgnoreCase(CharSequence ... sequence) {
        if (this.list.isEmpty()) {
            return false;
        }
        if (String.class.isAssignableFrom(this.list.get(0).getClass())) {
            for (Object s : this.list) {
                String context = s.toString();
                if (!StringUtils.use(context).containsIgnoreCase(sequence)) continue;
                return true;
            }
        }
        return false;
    }

    @FunctionalInterface
    public static interface ListOperation<T> {
        public T append(T var1);
    }
}

