/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import com.github.sanctum.labyrinth.library.Item;
import com.github.sanctum.labyrinth.library.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Items {
    private static final Map<String, Material> MATERIAL_ALIAS = new HashMap<String, Material>();

    @Nullable
    public static Material findMaterial(String name) {
        return Optional.ofNullable(MATERIAL_ALIAS.get(name.toLowerCase().replaceAll("_", ""))).orElseGet(() -> MATERIAL_ALIAS.entrySet().stream().filter(e -> StringUtils.use((String)e.getKey()).containsIgnoreCase((CharSequence)name)).map(Map.Entry::getValue).findFirst().orElse(null));
    }

    @NotNull
    public static Item.Edit edit() {
        return new Item.Edit(Items.findMaterial("dirt"));
    }

    @NotNull
    public static ItemStack edit(Function<Item.Edit, ItemStack> fun) {
        ItemStack itemStack = fun.apply(Items.edit());
        if (itemStack == null) {
            Items.$$$reportNull$$$0(0);
        }
        return itemStack;
    }

    @NotNull
    public static ItemStack edit(ItemStack toEdit, Function<Item.Edit, ItemStack> fun) {
        ItemStack itemStack = fun.apply(Items.edit().setItem(toEdit));
        if (itemStack == null) {
            Items.$$$reportNull$$$0(1);
        }
        return itemStack;
    }

    private Items() {
    }

    static {
        for (Material material : Material.values()) {
            MATERIAL_ALIAS.put(material.name().toLowerCase().replace("_", ""), material);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/sanctum/labyrinth/library/Items", "edit"));
    }
}

