/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.data.container.LegacyContainer;
import com.github.sanctum.labyrinth.library.Entities;
import com.github.sanctum.labyrinth.library.SecretWorkbench;
import com.github.sanctum.labyrinth.library.StringUtils;
import com.github.sanctum.labyrinth.library.Workbench;
import com.github.sanctum.labyrinth.library.WorkbenchSlot;
import com.github.sanctum.panther.annotation.Note;
import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherEntry;
import com.github.sanctum.panther.util.Check;
import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class Item {
    private static final LinkedList<Item> cache = new LinkedList();
    private final ConcurrentMap<Character, Material> recipeMap = new MapMaker().weakKeys().weakValues().makeMap();
    private final ConcurrentMap<Character, ItemStack> recipeStackMap = new MapMaker().weakKeys().weakValues().makeMap();
    private Material mat;
    private String name;
    private NamespacedKey key;
    private ShapedRecipe recipe;
    private ItemStack item;

    public Item(Material appearance, String displayName) {
        this();
        this.mat = appearance;
        this.name = displayName;
    }

    public Item(String displayName) {
        this();
        this.name = displayName;
    }

    public Item() {
        cache.add(this);
    }

    @Deprecated
    @Note(value="Internal usage only!")
    public @Note(value="Internal usage only!") Item setKey(String key) {
        this.key = new NamespacedKey(LabyrinthProvider.getInstance().getPluginInstance(), key);
        return this;
    }

    public Item setKey(String key, Plugin holder) {
        this.key = new NamespacedKey(holder, key);
        return this;
    }

    public Item setItem(char key, Material item) {
        this.recipeMap.put(Character.valueOf(key), item);
        return this;
    }

    public Item setItem(char key, ItemStack item) {
        this.recipeStackMap.put(Character.valueOf(key), item);
        return this;
    }

    public Item process() {
        ItemStack item = new ItemStack(Check.forNull(this.mat, "Material cannot but null!"));
        ItemMeta meta = item.getItemMeta();
        if (this.name != null) {
            meta.setDisplayName(StringUtils.use(this.name).translate());
        }
        item.setItemMeta(meta);
        this.item = item;
        return this;
    }

    public Edit edit() {
        Edit edit = new Edit(this);
        if (this.item != null) {
            edit.setItem(this.item);
        }
        if (this.mat != null) {
            edit.setType(this.mat);
        }
        if (this.name != null) {
            edit.setTitle(this.name);
        }
        return edit;
    }

    public Item shape(Workbench workbench) {
        StringBuilder top = new StringBuilder();
        StringBuilder middle = new StringBuilder();
        StringBuilder bottom = new StringBuilder();
        PantherCollection<PantherEntry.Modifiable<WorkbenchSlot, Character>> set = workbench.get();
        for (int i = 0; i < 9; ++i) {
            if (i > set.size()) continue;
            PantherEntry.Modifiable<WorkbenchSlot, Character> slot = set.get(i);
            int key = ((WorkbenchSlot)((Object)slot.getKey())).toInt();
            if (key == 0 || key == 1 || key == 2) {
                top.append(slot.getValue());
            }
            if (key == 3 || key == 4 || key == 5) {
                middle.append(slot.getValue());
            }
            if (key != 6 && key != 7 && key != 8) continue;
            bottom.append(slot.getValue());
        }
        ShapedRecipe recipe = new ShapedRecipe(this.key, Check.forNull(this.item, "ItemStack not built yet!"));
        recipe.shape(new String[]{top.toString(), middle.toString(), bottom.toString()});
        if (!this.recipeStackMap.isEmpty()) {
            this.setupItemstacks(recipe, top.toString(), middle.toString(), bottom.toString());
        }
        if (!this.recipeMap.isEmpty()) {
            this.setupMaterials(recipe, top.toString(), middle.toString(), bottom.toString());
        }
        this.recipe = recipe;
        return this;
    }

    public Item shape(Consumer<Workbench> consumer) {
        SecretWorkbench workbench = new SecretWorkbench();
        consumer.accept(workbench);
        return this.shape(workbench);
    }

    void setupItemstacks(ShapedRecipe recipe, String top, String middle, String bottom) {
        if (this.recipeStackMap.get(Character.valueOf(top.charAt(0))) != null) {
            recipe.setIngredient(top.charAt(0), (RecipeChoice)new RecipeChoice.ExactChoice((ItemStack)this.recipeStackMap.get(Character.valueOf(top.charAt(0)))));
        }
        if (this.recipeStackMap.get(Character.valueOf(top.charAt(1))) != null) {
            recipe.setIngredient(top.charAt(1), (RecipeChoice)new RecipeChoice.ExactChoice((ItemStack)this.recipeStackMap.get(Character.valueOf(top.charAt(1)))));
        }
        if (this.recipeStackMap.get(Character.valueOf(top.charAt(2))) != null) {
            recipe.setIngredient(top.charAt(2), (RecipeChoice)new RecipeChoice.ExactChoice((ItemStack)this.recipeStackMap.get(Character.valueOf(top.charAt(2)))));
        }
        if (this.recipeStackMap.get(Character.valueOf(middle.charAt(0))) != null) {
            recipe.setIngredient(middle.charAt(0), (RecipeChoice)new RecipeChoice.ExactChoice((ItemStack)this.recipeStackMap.get(Character.valueOf(middle.charAt(0)))));
        }
        if (this.recipeStackMap.get(Character.valueOf(middle.charAt(1))) != null) {
            recipe.setIngredient(middle.charAt(1), (RecipeChoice)new RecipeChoice.ExactChoice((ItemStack)this.recipeStackMap.get(Character.valueOf(middle.charAt(1)))));
        }
        if (this.recipeStackMap.get(Character.valueOf(middle.charAt(2))) != null) {
            recipe.setIngredient(middle.charAt(2), (RecipeChoice)new RecipeChoice.ExactChoice((ItemStack)this.recipeStackMap.get(Character.valueOf(middle.charAt(2)))));
        }
        if (this.recipeStackMap.get(Character.valueOf(bottom.charAt(0))) != null) {
            recipe.setIngredient(bottom.charAt(0), (RecipeChoice)new RecipeChoice.ExactChoice((ItemStack)this.recipeStackMap.get(Character.valueOf(bottom.charAt(0)))));
        }
        if (this.recipeStackMap.get(Character.valueOf(bottom.charAt(1))) != null) {
            recipe.setIngredient(bottom.charAt(1), (RecipeChoice)new RecipeChoice.ExactChoice((ItemStack)this.recipeStackMap.get(Character.valueOf(bottom.charAt(1)))));
        }
        if (this.recipeStackMap.get(Character.valueOf(bottom.charAt(2))) != null) {
            recipe.setIngredient(bottom.charAt(2), (RecipeChoice)new RecipeChoice.ExactChoice((ItemStack)this.recipeStackMap.get(Character.valueOf(bottom.charAt(2)))));
        }
    }

    void setupMaterials(ShapedRecipe recipe, String top, String middle, String bottom) {
        if (this.recipeMap.get(Character.valueOf(top.charAt(0))) != null) {
            recipe.setIngredient(top.charAt(0), (Material)this.recipeMap.get(Character.valueOf(top.charAt(0))));
        }
        if (this.recipeMap.get(Character.valueOf(top.charAt(1))) != null) {
            recipe.setIngredient(top.charAt(1), (Material)this.recipeMap.get(Character.valueOf(top.charAt(1))));
        }
        if (this.recipeMap.get(Character.valueOf(top.charAt(2))) != null) {
            recipe.setIngredient(top.charAt(2), (Material)this.recipeMap.get(Character.valueOf(top.charAt(2))));
        }
        if (this.recipeMap.get(Character.valueOf(middle.charAt(0))) != null) {
            recipe.setIngredient(middle.charAt(0), (Material)this.recipeMap.get(Character.valueOf(middle.charAt(0))));
        }
        if (this.recipeMap.get(Character.valueOf(middle.charAt(1))) != null) {
            recipe.setIngredient(middle.charAt(1), (Material)this.recipeMap.get(Character.valueOf(middle.charAt(1))));
        }
        if (this.recipeMap.get(Character.valueOf(middle.charAt(2))) != null) {
            recipe.setIngredient(middle.charAt(2), (Material)this.recipeMap.get(Character.valueOf(middle.charAt(2))));
        }
        if (this.recipeMap.get(Character.valueOf(bottom.charAt(0))) != null) {
            recipe.setIngredient(bottom.charAt(0), (Material)this.recipeMap.get(Character.valueOf(bottom.charAt(0))));
        }
        if (this.recipeMap.get(Character.valueOf(bottom.charAt(1))) != null) {
            recipe.setIngredient(bottom.charAt(1), (Material)this.recipeMap.get(Character.valueOf(bottom.charAt(1))));
        }
        if (this.recipeMap.get(Character.valueOf(bottom.charAt(2))) != null) {
            recipe.setIngredient(bottom.charAt(2), (Material)this.recipeMap.get(Character.valueOf(bottom.charAt(2))));
        }
    }

    public void register() {
        Bukkit.addRecipe((Recipe)this.recipe);
    }

    public static List<Item> getRegistered() {
        return Collections.unmodifiableList(cache);
    }

    public static void removeEntry(Item item) {
        Iterator it = Bukkit.recipeIterator();
        while (it.hasNext()) {
            Recipe recipe = (Recipe)it.next();
            if (recipe == null || !recipe.getResult().equals((Object)item.item)) continue;
            cache.remove(item);
            it.remove();
        }
    }

    public static Item getRegistration(Material type) {
        return cache.stream().filter(i -> i.item.getType() == type).findFirst().orElse(null);
    }

    public static Item getRegistration(String key) {
        return cache.stream().filter(i -> i.key.getKey().equals(key.toLowerCase(Locale.ROOT))).findFirst().orElse(null);
    }

    public static class Edit {
        private Item parent;
        private List<ItemStack> LIST;
        private ItemStack ITEM;
        private boolean LISTED = false;
        private List<String> LORE;
        private List<ItemFlag> FLAGS;
        private Consumer<LegacyContainer> consumer;
        private Map<Enchantment, Integer> ENCHANTS;
        private String TITLE;

        Edit(Item parent) {
            this(Material.AIR);
            this.parent = parent;
        }

        public Edit(Collection<ItemStack> items) {
            this.LISTED = true;
            LinkedList<ItemStack> temp = new LinkedList<ItemStack>();
            for (ItemStack it : items) {
                temp.add(new ItemStack(it));
            }
            this.LIST = temp;
        }

        public Edit(ItemStack ... i) {
            this.LISTED = true;
            LinkedList<ItemStack> temp = new LinkedList<ItemStack>();
            for (ItemStack it : i) {
                temp.add(new ItemStack(it));
            }
            this.LIST = temp;
        }

        public Edit(ItemStack i) {
            Preconditions.checkArgument((i != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
            this.ITEM = new ItemStack(i);
        }

        public Edit(Material mat) {
            if (mat == null) {
                mat = Material.PAPER;
            }
            this.ITEM = new ItemStack(mat);
        }

        public Edit setTitle(String text) {
            this.TITLE = StringUtils.use(text).translate();
            return this;
        }

        public Edit setAmount(int amount) {
            if (this.LISTED) {
                for (ItemStack i : this.LIST) {
                    i.setAmount(amount);
                }
            } else {
                this.ITEM.setAmount(amount);
            }
            return this;
        }

        public Edit setItem(ItemStack i) {
            if (!this.LISTED) {
                this.ITEM = new ItemStack(i);
            }
            return this;
        }

        public Edit setItem(ItemStack ... i) {
            if (this.LISTED) {
                this.LIST = new ArrayList<ItemStack>(Arrays.asList(i));
            }
            return this;
        }

        public Edit setItem(Collection<ItemStack> i) {
            if (this.LISTED) {
                this.LIST = new ArrayList<ItemStack>(i);
            }
            return this;
        }

        public Edit setType(Material type) {
            if (this.LISTED) {
                for (ItemStack i : this.LIST) {
                    i.setType(type);
                }
            } else {
                this.ITEM.setType(type);
            }
            return this;
        }

        public Edit setLore(Collection<String> collection) {
            LinkedList<String> list = new LinkedList<String>();
            for (String s : collection) {
                list.add(StringUtils.use(s).translate());
            }
            this.LORE = list;
            return this;
        }

        public Edit setLore(String ... text) {
            LinkedList<String> list = new LinkedList<String>();
            for (String s : text) {
                list.add(StringUtils.use(s).translate());
            }
            this.LORE = list;
            return this;
        }

        public Edit setFlags(ItemFlag ... flag) {
            this.FLAGS = new LinkedList<ItemFlag>(Arrays.asList(flag));
            return this;
        }

        public Edit addEnchantment(Enchantment enchant, int level) {
            if (this.ENCHANTS == null) {
                this.ENCHANTS = new HashMap<Enchantment, Integer>();
            }
            this.ENCHANTS.put(enchant, level);
            return this;
        }

        @Deprecated
        public Edit getContainer(Consumer<LegacyContainer> container) {
            return this.editContainer(container);
        }

        public Edit editContainer(Consumer<LegacyContainer> container) {
            this.consumer = container;
            return this;
        }

        public List<ItemStack> finish(Consumer<Damageable> damage) {
            if (!this.LISTED) {
                return Collections.emptyList();
            }
            for (ItemStack it : this.LIST) {
                ItemMeta meta = it.getItemMeta();
                damage.accept((Damageable)meta);
                if (this.consumer != null && !LabyrinthProvider.getInstance().isLegacy()) {
                    this.consumer.accept(new LegacyContainer.Impl(meta.getPersistentDataContainer()));
                }
                if (this.TITLE != null) {
                    meta.setDisplayName(this.TITLE);
                }
                if (this.LORE != null) {
                    meta.setLore(this.LORE);
                }
                if (this.FLAGS != null && !this.FLAGS.isEmpty()) {
                    meta.addItemFlags(this.FLAGS.toArray(new ItemFlag[0]));
                }
                it.setItemMeta(meta);
                if (this.ENCHANTS == null || this.ENCHANTS.isEmpty()) continue;
                for (Map.Entry<Enchantment, Integer> e : this.ENCHANTS.entrySet()) {
                    it.addUnsafeEnchantment(e.getKey(), e.getValue().intValue());
                }
            }
            return this.LIST;
        }

        public List<ItemStack> finish(Consumer<Damageable> damage, Consumer<ItemMeta> options) {
            if (!this.LISTED) {
                return Collections.emptyList();
            }
            for (ItemStack it : this.LIST) {
                ItemMeta meta = it.getItemMeta();
                damage.accept((Damageable)meta);
                options.accept(meta);
                if (this.consumer != null && !LabyrinthProvider.getInstance().isLegacy()) {
                    this.consumer.accept(new LegacyContainer.Impl(meta.getPersistentDataContainer()));
                }
                if (this.TITLE != null) {
                    meta.setDisplayName(this.TITLE);
                }
                if (this.LORE != null) {
                    meta.setLore(this.LORE);
                }
                if (this.FLAGS != null && !this.FLAGS.isEmpty()) {
                    meta.addItemFlags(this.FLAGS.toArray(new ItemFlag[0]));
                }
                it.setItemMeta(meta);
                if (this.ENCHANTS == null || this.ENCHANTS.isEmpty()) continue;
                for (Map.Entry<Enchantment, Integer> e : this.ENCHANTS.entrySet()) {
                    it.addUnsafeEnchantment(e.getKey(), e.getValue().intValue());
                }
            }
            return this.LIST;
        }

        public List<ItemStack> finish() {
            if (!this.LISTED) {
                return Collections.emptyList();
            }
            for (ItemStack it : this.LIST) {
                ItemMeta meta = it.getItemMeta();
                if (this.consumer != null && !LabyrinthProvider.getInstance().isLegacy()) {
                    this.consumer.accept(new LegacyContainer.Impl(meta.getPersistentDataContainer()));
                }
                if (this.TITLE != null) {
                    meta.setDisplayName(this.TITLE);
                }
                if (this.LORE != null) {
                    meta.setLore(this.LORE);
                }
                if (this.FLAGS != null && !this.FLAGS.isEmpty()) {
                    meta.addItemFlags(this.FLAGS.toArray(new ItemFlag[0]));
                }
                it.setItemMeta(meta);
                if (this.ENCHANTS == null || this.ENCHANTS.isEmpty()) continue;
                for (Map.Entry<Enchantment, Integer> e : this.ENCHANTS.entrySet()) {
                    it.addUnsafeEnchantment(e.getKey(), e.getValue().intValue());
                }
            }
            return this.LIST;
        }

        public ItemStack build(Consumer<Damageable> damage) {
            if (this.LISTED) {
                return this.LIST.get(0);
            }
            ItemMeta meta = this.ITEM.getItemMeta();
            damage.accept((Damageable)meta);
            if (this.consumer != null && !LabyrinthProvider.getInstance().isLegacy()) {
                this.consumer.accept(new LegacyContainer.Impl(meta.getPersistentDataContainer()));
            }
            if (this.TITLE != null) {
                meta.setDisplayName(this.TITLE);
            }
            if (this.LORE != null) {
                meta.setLore(this.LORE);
            }
            if (this.FLAGS != null && !this.FLAGS.isEmpty()) {
                meta.addItemFlags(this.FLAGS.toArray(new ItemFlag[0]));
            }
            this.ITEM.setItemMeta(meta);
            if (this.ENCHANTS != null && !this.ENCHANTS.isEmpty()) {
                for (Map.Entry<Enchantment, Integer> e : this.ENCHANTS.entrySet()) {
                    this.ITEM.addUnsafeEnchantment(e.getKey(), e.getValue().intValue());
                }
            }
            return this.ITEM;
        }

        public ItemStack build(Consumer<Damageable> damage, Consumer<ItemMeta> options) {
            if (this.LISTED) {
                return this.LIST.get(0);
            }
            ItemMeta meta = this.ITEM.getItemMeta();
            damage.accept((Damageable)meta);
            options.accept(meta);
            if (this.consumer != null && !LabyrinthProvider.getInstance().isLegacy()) {
                this.consumer.accept(new LegacyContainer.Impl(meta.getPersistentDataContainer()));
            }
            if (this.TITLE != null) {
                meta.setDisplayName(this.TITLE);
            }
            if (this.LORE != null) {
                meta.setLore(this.LORE);
            }
            if (this.FLAGS != null && !this.FLAGS.isEmpty()) {
                meta.addItemFlags(this.FLAGS.toArray(new ItemFlag[0]));
            }
            this.ITEM.setItemMeta(meta);
            if (this.ENCHANTS != null && !this.ENCHANTS.isEmpty()) {
                for (Map.Entry<Enchantment, Integer> e : this.ENCHANTS.entrySet()) {
                    this.ITEM.addUnsafeEnchantment(e.getKey(), e.getValue().intValue());
                }
            }
            return this.ITEM;
        }

        public ItemStack build() {
            if (this.LISTED) {
                return this.LIST.get(0);
            }
            ItemMeta meta = this.ITEM.getItemMeta();
            if (this.consumer != null && !LabyrinthProvider.getInstance().isLegacy()) {
                this.consumer.accept(new LegacyContainer.Impl(meta.getPersistentDataContainer()));
            }
            if (this.TITLE != null) {
                meta.setDisplayName(this.TITLE);
            }
            if (this.LORE != null) {
                meta.setLore(this.LORE);
            }
            if (this.FLAGS != null && !this.FLAGS.isEmpty()) {
                meta.addItemFlags(this.FLAGS.toArray(new ItemFlag[0]));
            }
            this.ITEM.setItemMeta(meta);
            if (this.ENCHANTS != null && !this.ENCHANTS.isEmpty()) {
                for (Map.Entry<Enchantment, Integer> e : this.ENCHANTS.entrySet()) {
                    this.ITEM.addUnsafeEnchantment(e.getKey(), e.getValue().intValue());
                }
            }
            return this.ITEM;
        }

        @Note(value="If this is a normal item edit this will return null")
        public @Note(value="If this is a normal item edit this will return null") Item complete() {
            if (this.parent != null) {
                this.parent.item = this.build();
                return this.parent;
            }
            return null;
        }

        @Note(value="If this is a normal item edit this will return null")
        public @Note(value="If this is a normal item edit this will return null") Item complete(Consumer<Damageable> consumer) {
            if (this.parent != null) {
                this.parent.item = this.build(consumer);
                return this.parent;
            }
            return null;
        }

        @Note(value="If this is a normal item edit this will return null")
        public @Note(value="If this is a normal item edit this will return null") Item complete(Consumer<Damageable> consumer, Consumer<ItemMeta> consumer2) {
            if (this.parent != null) {
                this.parent.item = this.build(consumer, consumer2);
                return this.parent;
            }
            return null;
        }
    }

    public static class CustomFirework {
        private final Location LOCATION;
        private FireworkEffect.Builder EFFECTS;

        protected CustomFirework(@NotNull Location location) {
            if (location == null) {
                CustomFirework.$$$reportNull$$$0(0);
            }
            this.LOCATION = location;
        }

        public static CustomFirework from(Location location) {
            return new CustomFirework(location);
        }

        public CustomFirework addEffects(Consumer<FireworkEffect.Builder> operation) {
            FireworkEffect.Builder builder = FireworkEffect.builder();
            operation.accept(builder);
            this.EFFECTS = builder;
            return this;
        }

        public Firework build() {
            Firework f = (Firework)this.LOCATION.getWorld().spawnEntity(this.LOCATION, Entities.getEntity("firework"));
            FireworkMeta meta = f.getFireworkMeta();
            if (this.EFFECTS != null) {
                meta.addEffect(this.EFFECTS.build());
            }
            f.setFireworkMeta(meta);
            return f;
        }

        public Firework build(Consumer<FireworkMeta> operation) {
            Firework f = (Firework)this.LOCATION.getWorld().spawnEntity(this.LOCATION, Entities.getEntity("firework"));
            FireworkMeta meta = f.getFireworkMeta();
            operation.accept(meta);
            if (this.EFFECTS != null) {
                meta.addEffect(this.EFFECTS.build());
            }
            f.setFireworkMeta(meta);
            return f;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/github/sanctum/labyrinth/library/Item$CustomFirework", "<init>"));
        }
    }

    public static class ColoredArmor {
        private final ItemStack BASE;
        private String TITLE;
        private Color COLOR;
        private List<String> LORE;

        protected ColoredArmor(@NotNull Piece piece) {
            if (piece == null) {
                ColoredArmor.$$$reportNull$$$0(0);
            }
            switch (piece) {
                case HEAD: {
                    this.BASE = new ItemStack(Material.LEATHER_HELMET);
                    break;
                }
                case TORSO: {
                    this.BASE = new ItemStack(Material.LEATHER_CHESTPLATE);
                    break;
                }
                case LEGS: {
                    this.BASE = new ItemStack(Material.LEATHER_LEGGINGS);
                    break;
                }
                case FEET: {
                    this.BASE = new ItemStack(Material.LEATHER_BOOTS);
                    break;
                }
                default: {
                    throw new IllegalArgumentException((Object)((Object)piece) + " is not a valid armor piece.");
                }
            }
        }

        public static ColoredArmor select(@NotNull Piece piece) {
            if (piece == null) {
                ColoredArmor.$$$reportNull$$$0(1);
            }
            return new ColoredArmor(piece);
        }

        public static ColoredArmor prepare() {
            return new ColoredArmor(Piece.HEAD);
        }

        public ColoredArmor setTitle(@NotNull String text) {
            if (text == null) {
                ColoredArmor.$$$reportNull$$$0(2);
            }
            this.TITLE = StringUtils.use(text).translate();
            return this;
        }

        public ColoredArmor setColor(@NotNull Color color) {
            if (color == null) {
                ColoredArmor.$$$reportNull$$$0(3);
            }
            this.COLOR = color;
            return this;
        }

        public ColoredArmor setColor(int rgb) {
            this.COLOR = Color.fromRGB((int)rgb);
            return this;
        }

        public ColoredArmor setColor(int red, int green, int blue) {
            this.COLOR = Color.fromRGB((int)red, (int)green, (int)blue);
            return this;
        }

        public ColoredArmor setLore(String ... text) {
            if (text == null) {
                ColoredArmor.$$$reportNull$$$0(4);
            }
            LinkedList<String> list = new LinkedList<String>();
            for (String t : text) {
                list.add(StringUtils.use(t).translate());
            }
            this.LORE = list;
            return this;
        }

        public ItemStack[] buildAll() {
            LinkedList<ItemStack> i = new LinkedList<ItemStack>(Arrays.asList(new ItemStack(Material.LEATHER_HELMET), new ItemStack(Material.LEATHER_CHESTPLATE), new ItemStack(Material.LEATHER_LEGGINGS), new ItemStack(Material.LEATHER_BOOTS)));
            for (ItemStack it : i) {
                if (it.getItemMeta() instanceof LeatherArmorMeta) {
                    LeatherArmorMeta meta = (LeatherArmorMeta)it.getItemMeta();
                    if (this.COLOR != null) {
                        meta.setColor(this.COLOR);
                    }
                    if (this.LORE != null && !this.LORE.isEmpty()) {
                        meta.setLore(this.LORE);
                    }
                    if (this.TITLE != null) {
                        meta.setDisplayName(this.TITLE);
                    }
                    it.setItemMeta((ItemMeta)meta);
                    continue;
                }
                throw new IllegalStateException("An invalid item type was found present, yell at the devs!!");
            }
            return i.toArray(new ItemStack[0]);
        }

        public ItemStack build() {
            if (this.BASE.getItemMeta() instanceof LeatherArmorMeta) {
                LeatherArmorMeta meta = (LeatherArmorMeta)this.BASE.getItemMeta();
                if (this.COLOR != null) {
                    meta.setColor(this.COLOR);
                }
                if (this.LORE != null && !this.LORE.isEmpty()) {
                    meta.setLore(this.LORE);
                }
                if (this.TITLE != null) {
                    meta.setDisplayName(this.TITLE);
                }
                this.BASE.setItemMeta((ItemMeta)meta);
                return this.BASE;
            }
            throw new IllegalStateException("An invalid item type was found present, yell at the devs!!");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "piece";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
            }
            objectArray2[1] = "com/github/sanctum/labyrinth/library/Item$ColoredArmor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "select";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setTitle";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setColor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setLore";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static enum Piece {
            HEAD,
            TORSO,
            LEGS,
            FEET;

        }
    }
}

