/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import com.github.sanctum.labyrinth.library.ContainerModification;
import com.github.sanctum.labyrinth.library.ContainerQuestion;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.function.Function;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class ContainerQuery<T extends Container>
implements Iterable<ItemStack> {
    final T container;

    ContainerQuery(T container) {
        this.container = container;
    }

    public ContainerModification<T> edit() {
        if (!this.isValid()) {
            throw new UnsupportedOperationException("Cannot edit non containers!");
        }
        return new ContainerModification(this);
    }

    public ContainerQuestion<T> check() {
        if (!this.isValid()) {
            throw new UnsupportedOperationException("Cannot parse non containers!");
        }
        return new ContainerQuestion(this);
    }

    public <R extends Container> ContainerQuery<R> map(Function<Container, R> function) {
        return ContainerQuery.of((Container)function.apply((Container)this.container));
    }

    public boolean isValid() {
        return this.container != null;
    }

    public static ContainerQuery<Container> of(Block block) {
        if (block instanceof Container) {
            return new ContainerQuery<Container>((Container)block);
        }
        return null;
    }

    public static <T extends Container> ContainerQuery<T> of(@NotNull T container) {
        if (container == null) {
            ContainerQuery.$$$reportNull$$$0(0);
        }
        return new ContainerQuery<T>(container);
    }

    @Override
    @NotNull
    public Iterator<ItemStack> iterator() {
        ListIterator listIterator = this.container.getInventory().iterator();
        if (listIterator == null) {
            ContainerQuery.$$$reportNull$$$0(1);
        }
        return listIterator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/github/sanctum/labyrinth/library/ContainerQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/github/sanctum/labyrinth/library/ContainerQuery";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

