/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import com.github.sanctum.labyrinth.library.ContainerQuery;
import com.github.sanctum.labyrinth.library.ContainerQuestion;
import org.bukkit.Material;
import org.bukkit.block.Container;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class ContainerModification<T extends Container>
extends ContainerQuestion<T> {
    final ContainerQuery<T> query;
    final Inventory snapshot;

    ContainerModification(ContainerQuery<T> query) {
        super(query);
        this.query = query;
        this.snapshot = query.container.getSnapshotInventory();
    }

    public ContainerModification<T> set(ItemStack ... items) {
        if (items == null) {
            ContainerModification.$$$reportNull$$$0(0);
        }
        this.snapshot.setContents(items);
        return this;
    }

    public ContainerModification<T> add(ItemStack ... items) {
        if (items == null) {
            ContainerModification.$$$reportNull$$$0(1);
        }
        this.snapshot.addItem(items);
        return this;
    }

    public ContainerModification<T> put(int index, @NotNull ItemStack item) {
        if (item == null) {
            ContainerModification.$$$reportNull$$$0(2);
        }
        this.snapshot.setItem(index, item);
        return this;
    }

    public ContainerModification<T> remove(int index) {
        ItemStack test = this.snapshot.getItem(index);
        if (test != null) {
            this.snapshot.remove(test);
        }
        return this;
    }

    public ContainerModification<T> remove(@NotNull ItemStack item) {
        if (item == null) {
            ContainerModification.$$$reportNull$$$0(3);
        }
        this.snapshot.remove(item);
        return this;
    }

    public ContainerQuery<T> update() {
        this.query.container.update();
        return this.query;
    }

    @Override
    public boolean has(@NotNull ItemStack itemStack) {
        if (itemStack == null) {
            ContainerModification.$$$reportNull$$$0(4);
        }
        return this.snapshot.contains(itemStack);
    }

    @Override
    public boolean has(@NotNull Material material) {
        if (material == null) {
            ContainerModification.$$$reportNull$$$0(5);
        }
        return this.snapshot.contains(material);
    }

    @Override
    public boolean has(@NotNull ItemStack itemStack, int amount) {
        if (itemStack == null) {
            ContainerModification.$$$reportNull$$$0(6);
        }
        return this.snapshot.contains(itemStack, amount);
    }

    @Override
    public boolean has(@NotNull Material material, int amount) {
        if (material == null) {
            ContainerModification.$$$reportNull$$$0(7);
        }
        return this.snapshot.contains(material, amount);
    }

    @Override
    public boolean isEmpty() {
        return this.snapshot.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemStack";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "material";
                break;
            }
        }
        objectArray2[1] = "com/github/sanctum/labyrinth/library/ContainerModification";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "set";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "has";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

