/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.gui.unity.simple;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.library.Item;
import com.github.sanctum.labyrinth.library.Items;
import com.github.sanctum.labyrinth.library.StringUtils;
import com.github.sanctum.panther.annotation.Note;
import com.github.sanctum.panther.container.PantherList;
import com.github.sanctum.panther.file.Node;
import com.github.sanctum.skulls.CustomHead;
import com.github.sanctum.skulls.CustomHeadLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MemoryItem {
    protected final Node node;
    protected Map<String, String> replacements;
    protected boolean notRemovable;
    protected boolean exitOnClick;
    protected String openOnClick;
    protected String message;
    protected int slot = -1;
    protected int limit = 5;

    public MemoryItem(Node node) {
        this.node = node;
    }

    public boolean isNotRemovable() {
        return this.notRemovable;
    }

    public boolean isExitOnClick() {
        return this.exitOnClick;
    }

    @Note(value="This could return either a menu id or a command.")
    public @Note(value="This could return either a menu id or a command.") String getOpenOnClick() {
        return this.openOnClick;
    }

    public String getMessage() {
        return this.message;
    }

    public int getSlot() {
        return this.slot;
    }

    public int getLimit() {
        return this.limit;
    }

    public Map<String, String> getReplacements() {
        return this.replacements;
    }

    private ItemStack improvise(String value) {
        Material mat = Items.findMaterial(value);
        if (mat != null) {
            return new ItemStack(mat);
        }
        if (value.length() < 26) {
            return CustomHead.Manager.getHeads().stream().filter(h -> StringUtils.use(h.name()).containsIgnoreCase((CharSequence)value)).map(CustomHead::get).findFirst().orElse(null);
        }
        return CustomHeadLoader.provide(value);
    }

    @NotNull
    public ItemStack toItem() {
        String type = this.node.getNode("type").toPrimitive().getString();
        ItemStack test = this.improvise(type);
        if (test == null) {
            test = new ItemStack(Material.DIRT);
            Logger logger = LabyrinthProvider.getInstance().getLogger();
            logger.severe("Item type \"" + type + '\"' + " not found.");
            logger.severe("Key: " + this.node.getPath());
            File f = new File(LabyrinthProvider.getInstance().getPluginInstance().getDataFolder(), "Persistent/items.txt");
            if (!f.exists()) {
                logger.warning("A full list of acceptable item names has been created in directory \"/Labyrinth/Persistent/\"");
                try {
                    PrintWriter writer = new PrintWriter(f);
                    Arrays.stream(Material.values()).forEach(m -> writer.println(m.name()));
                    writer.close();
                }
                catch (FileNotFoundException e2) {
                    logger.severe("Unable to write example item list file.");
                }
            }
        }
        Item.Edit edit = new Item.Edit(test);
        String label = this.node.getPath();
        String[] split = label.split("\\.");
        String c = split[split.length - 1];
        if (!c.startsWith("!")) {
            edit.setTitle(c);
        }
        if (this.node.getNode("name").toPrimitive().isString()) {
            edit.setTitle(this.node.getNode("name").toPrimitive().getString());
        }
        if (this.node.getNode("limit").toPrimitive().isInt()) {
            this.limit = this.node.getNode("limit").toPrimitive().getInt();
        }
        if (this.node.isNode("replacements")) {
            HashMap<String, String> r = new HashMap<String, String>();
            for (String key : this.node.getNode("replacements").getKeys(false)) {
                r.put(key, this.node.getNode("replacements").getNode(key).toPrimitive().getString());
            }
            this.replacements = r;
        }
        if (this.node.getNode("message").toPrimitive().isString()) {
            this.message = this.node.getNode("message").toPrimitive().getString();
        }
        if (this.node.getNode("slot").toPrimitive().isInt()) {
            this.slot = this.node.getNode("slot").toPrimitive().getInt();
        }
        if (this.node.getNode("locked").toPrimitive().isBoolean()) {
            this.notRemovable = this.node.getNode("locked").toPrimitive().getBoolean();
        }
        if (this.node.getNode("close").toPrimitive().isBoolean()) {
            this.exitOnClick = this.node.getNode("close").toPrimitive().getBoolean();
        }
        if (this.node.getNode("open").toPrimitive().isString()) {
            this.openOnClick = this.node.getNode("open").toPrimitive().getString();
        }
        if (this.node.isNode("enchantments")) {
            Node enchants = this.node.getNode("enchantments");
            for (String enchant : enchants.getKeys(false)) {
                Arrays.stream(Enchantment.values()).filter(en -> en.getKey().getKey().equals(enchant)).findFirst().ifPresent(e -> edit.addEnchantment((Enchantment)e, enchants.getNode(enchant).toPrimitive().getInt()));
            }
        }
        if (this.node.getNode("lore").toPrimitive().isStringList()) {
            edit.setLore(this.node.getNode("lore").toPrimitive().getStringList());
        }
        if (this.node.getNode("flags").toPrimitive().isStringList()) {
            PantherList flags = new PantherList();
            for (String flag : this.node.getNode("flags").toPrimitive().getStringList()) {
                try {
                    ItemFlag f = ItemFlag.valueOf((String)flag);
                    flags.add(f);
                }
                catch (Exception exception) {}
            }
            edit.setFlags((ItemFlag[])flags.stream().toArray(ItemFlag[]::new));
        }
        ItemStack itemStack = edit.build();
        if (itemStack == null) {
            MemoryItem.$$$reportNull$$$0(0);
        }
        return itemStack;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/sanctum/labyrinth/gui/unity/simple/MemoryItem", "toItem"));
    }
}

