/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.gui.unity.simple;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.data.service.PlayerSearch;
import com.github.sanctum.labyrinth.formatting.string.FormattedString;
import com.github.sanctum.labyrinth.gui.unity.construct.Menu;
import com.github.sanctum.labyrinth.gui.unity.construct.MenuRegistration;
import com.github.sanctum.labyrinth.gui.unity.construct.PaginatedMenu;
import com.github.sanctum.labyrinth.gui.unity.construct.PrintableMenu;
import com.github.sanctum.labyrinth.gui.unity.construct.SingularMenu;
import com.github.sanctum.labyrinth.gui.unity.impl.BorderElement;
import com.github.sanctum.labyrinth.gui.unity.impl.FillerElement;
import com.github.sanctum.labyrinth.gui.unity.impl.InventoryElement;
import com.github.sanctum.labyrinth.gui.unity.impl.ItemElement;
import com.github.sanctum.labyrinth.gui.unity.impl.ListElement;
import com.github.sanctum.labyrinth.gui.unity.impl.MenuType;
import com.github.sanctum.labyrinth.gui.unity.simple.Docket;
import com.github.sanctum.labyrinth.gui.unity.simple.MemoryItem;
import com.github.sanctum.labyrinth.gui.unity.simple.UniqueHolder;
import com.github.sanctum.labyrinth.library.Mailer;
import com.github.sanctum.panther.annotation.Comment;
import com.github.sanctum.panther.annotation.Note;
import com.github.sanctum.panther.annotation.Voluntary;
import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherList;
import com.github.sanctum.panther.file.MemorySpace;
import com.github.sanctum.panther.file.Node;
import com.github.sanctum.panther.util.Check;
import com.github.sanctum.skulls.CustomHead;
import com.github.sanctum.skulls.SkullType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class MemoryDocket<T>
implements Docket<T>,
UniqueHolder {
    protected final PantherCollection<ItemElement<?>> items = new PantherList();
    protected Plugin plugin = LabyrinthProvider.getInstance().getPluginInstance();
    protected MemoryItem pagination;
    protected MemoryItem next;
    protected MemoryItem previous;
    protected MemoryItem exit;
    protected MemoryItem filler;
    protected MemoryItem border;
    protected BiFunction<String, T, String> dataConverter = (s, t) -> s;
    protected BiFunction<String, Object, String> uniqueDataConverter = (s, t) -> s;
    protected final MemorySpace memory;
    protected Supplier<List<T>> supplier;
    protected Comparator<T> comparator;
    protected Predicate<T> predicate;
    protected Object uniqueData;
    protected boolean shared;
    protected String title;
    protected String key;
    protected String nameHolder;
    protected Menu.Type type;
    protected Menu.Rows rows;
    protected Menu instance;

    public MemoryDocket(MemorySpace memorySpace) {
        this.memory = memorySpace;
    }

    @Voluntary(value="Used only in tandem with pagination.")
    public @Voluntary(value="Used only in tandem with pagination.") MemoryDocket<T> setList(@NotNull Supplier<List<T>> supplier) {
        if (supplier == null) {
            MemoryDocket.$$$reportNull$$$0(0);
        }
        this.supplier = supplier;
        return this;
    }

    @Voluntary(value="Used only in tandem with pagination.")
    public @Voluntary(value="Used only in tandem with pagination.") MemoryDocket<T> setComparator(Comparator<T> comparator) {
        this.comparator = comparator;
        return this;
    }

    @Voluntary(value="Used only in tandem with pagination.")
    public @Voluntary(value="Used only in tandem with pagination.") MemoryDocket<T> setFilter(Predicate<T> predicate) {
        this.predicate = predicate;
        return this;
    }

    @Note(value="This method is used for translating player names for skull items, it is expected to be the placeholder for returning a player username and is used in tandem with a Unique Data Converter")
    public @Note(value="This method is used for translating player names for skull items, it is expected to be the placeholder for returning a player username and is used in tandem with a Unique Data Converter") MemoryDocket<T> setNamePlaceholder(@NotNull String placeholder) {
        if (placeholder == null) {
            MemoryDocket.$$$reportNull$$$0(1);
        }
        this.nameHolder = placeholder;
        return this;
    }

    @Voluntary(value="This method allows you to setup custom placeholders, used only in tandem with pagination.")
    public @Voluntary(value="This method allows you to setup custom placeholders, used only in tandem with pagination.") MemoryDocket<T> setDataConverter(@NotNull BiFunction<String, T, String> function) {
        if (function == null) {
            MemoryDocket.$$$reportNull$$$0(2);
        }
        this.dataConverter = function;
        return this;
    }

    @Note(value="This method is used for setting up unique translations. Example; a singular parent object being attached for extra placeholders.")
    public <V> @Note(value="This method is used for setting up unique translations. Example; a singular parent object being attached for extra placeholders.") MemoryDocket<T> setUniqueDataConverter(@NotNull V t, @NotNull BiFunction<String, V, String> function) {
        if (t == null) {
            MemoryDocket.$$$reportNull$$$0(3);
        }
        if (function == null) {
            MemoryDocket.$$$reportNull$$$0(4);
        }
        this.uniqueData = t;
        this.uniqueDataConverter = function;
        return this;
    }

    @Override
    @NotNull
    public MemoryDocket<T> load() {
        this.title = Check.forNull(this.memory.getNode("title").toPrimitive().getString(), "Configured menus cannot have null titles please correct under path '" + this.memory.getPath() + "'");
        if (this.uniqueData != null) {
            this.title = this.uniqueDataConverter.apply(this.title, this.uniqueData);
        }
        this.rows = Check.forNull(Menu.Rows.valueOf(this.memory.getNode("rows").toPrimitive().getString()), "Configured menus need a row size please correct under path '" + this.memory.getPath() + "'");
        this.type = Check.forNull(Menu.Type.valueOf(this.memory.getNode("type").toPrimitive().getString()), "Configured menus need a valid type please correct under path '" + this.memory.getPath() + "'");
        this.shared = this.memory.getNode("shared").toPrimitive().getBoolean();
        if (this.memory.getNode("id").toPrimitive().isString()) {
            this.key = this.uniqueData != null ? this.uniqueDataConverter.apply(this.memory.getNode("id").toPrimitive().getString(), this.uniqueData) : this.memory.getNode("id").toPrimitive().getString();
        }
        if (this.memory.isNode("filler")) {
            this.filler = new MemoryItem(this.memory.getNode("filler"));
        }
        if (this.memory.isNode("border")) {
            this.border = new MemoryItem(this.memory.getNode("border"));
        }
        if (this.memory.isNode("pagination")) {
            this.pagination = new MemoryItem(this.memory.getNode("pagination"));
            if (this.memory.getNode("pagination").isNode("navigation")) {
                Node parent = this.memory.getNode("pagination").getNode("navigation");
                this.next = new MemoryItem(parent.getNode("next"));
                this.previous = new MemoryItem(parent.getNode("previous"));
                if (parent.isNode("exit")) {
                    this.exit = new MemoryItem(parent.getNode("exit"));
                }
            }
        }
        if (this.memory.isNode("items")) {
            for (String item : this.memory.getNode("items").getKeys(false)) {
                MemoryItem i2 = new MemoryItem(this.memory.getNode("items").getNode(item));
                ItemStack result = i2.toItem();
                ItemElement element = new ItemElement();
                element.setElement(result);
                this.handlePlayerHeadLookup(true, result, element, new Object[0]);
                if (i2.getSlot() > -1) {
                    element.setSlot(i2.getSlot());
                }
                this.handleClickEvent(i2, element);
                if (element.getElement().hasItemMeta() && element.getElement().getItemMeta().hasLore()) {
                    ArrayList<String> lore = new ArrayList<String>();
                    Iterator iterator = element.getElement().getItemMeta().getLore().iterator();
                    while (iterator.hasNext()) {
                        String s;
                        String res = s = (String)iterator.next();
                        if (this.uniqueData != null) {
                            res = this.uniqueDataConverter.apply(res, this.uniqueData);
                        }
                        lore.add(res);
                    }
                    element.setElement(edit -> edit.setLore(lore).build());
                }
                String res = element.getName();
                if (this.uniqueData != null) {
                    res = this.uniqueDataConverter.apply(res, this.uniqueData);
                }
                String finalRes = res;
                element.setElement(edit -> edit.setTitle(finalRes).build());
                this.items.add(element);
            }
        }
        switch (this.type) {
            case PAGINATED: {
                Menu.Builder<PaginatedMenu, InventoryElement.Paginated> paginated = MenuType.PAGINATED.build().setHost(this.plugin).setTitle(this.title).setSize(this.rows);
                if (this.key != null) {
                    paginated.setKey(this.key).setProperty(Menu.Property.CACHEABLE);
                }
                if (this.shared) {
                    paginated.setProperty(Menu.Property.SHAREABLE);
                }
                paginated.setStock(i -> {
                    this.items.forEach(i::addItem);
                    ListElement<Object> element = new ListElement<Object>(this.supplier);
                    if (this.comparator != null) {
                        element.setComparator((o1, o2) -> this.comparator.compare(o1.getData().orElse(null), o2.getData().orElse(null)));
                    }
                    if (this.predicate != null) {
                        element.setFilter((? super ItemElement<T> tItemElement) -> this.predicate.test(tItemElement.getData().orElse(null)));
                    }
                    if (this.border != null) {
                        BorderElement border = new BorderElement((InventoryElement)i);
                        for (Menu.Panel p : Menu.Panel.values()) {
                            if (p == Menu.Panel.MIDDLE) continue;
                            border.add(p, ed -> {
                                ItemStack built = this.border.toItem();
                                ed.setElement(built);
                                this.handleClickEvent(this.border, (ItemElement<?>)ed);
                                ed.setType(ItemElement.ControlType.ITEM_BORDER);
                            });
                        }
                        i.addItem(border);
                    }
                    if (this.filler != null) {
                        FillerElement filler = new FillerElement((InventoryElement)i);
                        filler.add(ed -> {
                            ItemStack built = this.filler.toItem();
                            ed.setElement(built);
                            this.handleClickEvent(this.filler, (ItemElement<?>)ed);
                            ed.setType(ItemElement.ControlType.ITEM_FILLER);
                        });
                        i.addItem(filler);
                    }
                    ItemStack built = this.pagination.toItem();
                    element.setLimit(this.pagination.getLimit());
                    element.setPopulate((value, item) -> {
                        item.setElement(built);
                        this.handlePlayerHeadLookup(false, built, item, value);
                        String title = item.getName();
                        if (this.pagination != null) {
                            if (this.pagination.isNotRemovable()) {
                                item.setClick(click -> {
                                    click.setCancelled(true);
                                    if (this.pagination.isExitOnClick()) {
                                        click.getParent().getParent().getParent().close(click.getElement());
                                    }
                                    if (this.pagination.getMessage() != null) {
                                        String res = this.handlePaginationReplacements(this.pagination, this.pagination.getMessage(), value);
                                        if (this.dataConverter != null) {
                                            res = this.dataConverter.apply(res, (String)value);
                                        }
                                        Mailer.empty((CommandSender)click.getElement()).chat(res).deploy();
                                    }
                                    if (this.pagination.getOpenOnClick() != null) {
                                        MenuRegistration registration;
                                        Menu registered;
                                        String open = this.pagination.getOpenOnClick();
                                        String r = this.handlePaginationReplacements(this.pagination, open, value);
                                        if (this.dataConverter != null) {
                                            r = this.dataConverter.apply(r, (String)value);
                                        }
                                        if ((registered = (registration = MenuRegistration.getInstance()).get(r).deploy().get()) != null) {
                                            registered.open(click.getElement());
                                        } else if (this.pagination.getOpenOnClick().startsWith("/")) {
                                            String command = this.pagination.getOpenOnClick().replace("/", "");
                                            String res = this.handlePaginationReplacements(this.pagination, command, value);
                                            if (this.dataConverter != null) {
                                                res = this.dataConverter.apply(res, (String)value);
                                            }
                                            click.getElement().performCommand(res);
                                        }
                                    }
                                });
                            }
                            if (this.pagination.getReplacements() != null) {
                                if (item.getElement().hasItemMeta() && item.getElement().getItemMeta().hasLore()) {
                                    ArrayList<String> lore = new ArrayList<String>();
                                    for (String s : item.getElement().getItemMeta().getLore()) {
                                        String res = this.handlePaginationReplacements(this.pagination, s, value);
                                        if (this.dataConverter != null) {
                                            res = this.dataConverter.apply(res, (String)value);
                                        }
                                        lore.add(res);
                                    }
                                    item.setElement(edit -> edit.setLore(lore).build());
                                }
                                String res = this.handlePaginationReplacements(this.pagination, title, value);
                                if (this.dataConverter != null) {
                                    res = this.dataConverter.apply(res, (String)value);
                                }
                                String finalRes = res;
                                item.setElement(edit -> edit.setTitle(finalRes).build());
                            }
                        }
                    });
                    i.addItem(element);
                    if (!Check.isNull(this.next, this.previous)) {
                        i.addItem(b -> {
                            b.setElement(it -> it.setItem(this.next.toItem()).build()).setType(ItemElement.ControlType.BUTTON_NEXT).setSlot(this.next.getSlot());
                            this.handleClickEvent(this.next, (ItemElement<?>)b);
                        }).addItem(b -> {
                            b.setElement(it -> it.setItem(this.previous.toItem()).build()).setType(ItemElement.ControlType.BUTTON_BACK).setSlot(this.previous.getSlot());
                            this.handleClickEvent(this.previous, (ItemElement<?>)b);
                        });
                    }
                    if (this.exit != null) {
                        i.addItem(b -> {
                            b.setElement(it -> it.setItem(this.exit.toItem()).build()).setType(ItemElement.ControlType.BUTTON_EXIT).setSlot(this.exit.getSlot());
                            this.handleClickEvent(this.exit, (ItemElement<?>)b);
                        });
                    }
                });
                this.instance = paginated.join();
                break;
            }
            case PRINTABLE: {
                Menu.Builder<PrintableMenu, InventoryElement.Printable> printable = MenuType.PRINTABLE.build().setHost(this.plugin).setTitle(this.title).setSize(this.rows);
                if (this.key != null) {
                    printable.setKey(this.key).setProperty(Menu.Property.CACHEABLE);
                }
                if (this.shared) {
                    printable.setProperty(Menu.Property.SHAREABLE);
                }
                printable.setStock(i -> this.items.forEach(i::addItem));
                this.instance = printable.join();
                break;
            }
            case SINGULAR: {
                Menu.Builder<SingularMenu, InventoryElement.Normal> singular = MenuType.SINGULAR.build().setHost(this.plugin).setTitle(this.title).setSize(this.rows);
                if (this.key != null) {
                    singular.setKey(this.key).setProperty(Menu.Property.CACHEABLE);
                }
                if (this.shared) {
                    singular.setProperty(Menu.Property.SHAREABLE);
                }
                singular.setProperty(Menu.Property.RECURSIVE);
                singular.setStock(i -> {
                    this.items.forEach(i::addItem);
                    if (this.border != null) {
                        BorderElement border = new BorderElement((InventoryElement)i);
                        for (Menu.Panel p : Menu.Panel.values()) {
                            if (p == Menu.Panel.MIDDLE) continue;
                            border.add(p, ed -> {
                                ItemStack built = this.border.toItem();
                                ed.setElement(built);
                                if (this.border != null) {
                                    this.handleClickEvent(this.border, (ItemElement<?>)ed);
                                }
                                ed.setType(ItemElement.ControlType.ITEM_BORDER);
                            });
                        }
                        i.addItem(border);
                    }
                    if (this.filler != null) {
                        FillerElement filler = new FillerElement((InventoryElement)i);
                        filler.add(ed -> {
                            ItemStack built = this.filler.toItem();
                            ed.setElement(built);
                            if (this.filler != null) {
                                this.handleClickEvent(this.filler, (ItemElement<?>)ed);
                            }
                            ed.setType(ItemElement.ControlType.ITEM_FILLER);
                        });
                        i.addItem(filler);
                    }
                });
                this.instance = singular.join();
            }
        }
        MemoryDocket memoryDocket = this;
        if (memoryDocket == null) {
            MemoryDocket.$$$reportNull$$$0(5);
        }
        return memoryDocket;
    }

    @Override
    @NotNull
    public Menu toMenu() {
        Menu menu = this.instance;
        if (menu == null) {
            MemoryDocket.$$$reportNull$$$0(6);
        }
        return menu;
    }

    protected void handleClickEvent(MemoryItem item, ItemElement<?> ed) {
        if (item.isNotRemovable()) {
            ed.setClick(click -> {
                click.setCancelled(true);
                if (item.isExitOnClick()) {
                    click.getParent().getParent().getParent().close(click.getElement());
                }
                if (item.getMessage() != null) {
                    String message = item.getMessage();
                    if (this.uniqueData != null) {
                        message = this.uniqueDataConverter.apply(message, this.uniqueData);
                    }
                    Mailer.empty((CommandSender)click.getElement()).chat(message).deploy();
                }
                if (item.getOpenOnClick() != null) {
                    MenuRegistration registration;
                    Menu registered;
                    String open = item.getOpenOnClick();
                    if (this.uniqueData != null) {
                        open = this.uniqueDataConverter.apply(open, this.uniqueData);
                    }
                    if ((registered = (registration = MenuRegistration.getInstance()).get(open).deploy().complete()) != null) {
                        registered.open(click.getElement());
                    } else if (item.getOpenOnClick().startsWith("/")) {
                        String command = item.getOpenOnClick().replace("/", "");
                        if (this.uniqueData != null) {
                            command = this.uniqueDataConverter.apply(command, this.uniqueData);
                        }
                        click.getElement().performCommand(command);
                    }
                }
            });
        }
    }

    @Comment(value="Handle player head to user translations, local being a unique object instead of paginated.")
    protected void handlePlayerHeadLookup(boolean local, ItemStack built, ItemElement<?> item, Object ... args) {
        String name;
        PlayerSearch search;
        boolean pass;
        boolean bl = local ? !Check.isNull(this.uniqueData, this.uniqueDataConverter, this.nameHolder) : (pass = !Check.isNull(this.dataConverter, this.nameHolder));
        if (pass && new FormattedString(built.getType().name()).contains("player_head", "skull_item") && (search = PlayerSearch.of(name = local ? this.uniqueDataConverter.apply(this.nameHolder, this.uniqueData) : this.dataConverter.apply(this.nameHolder, (String)args[0]))) != null) {
            ItemStack head = CustomHead.Manager.get(search.getPlayer());
            item.setElement(edit -> edit.setItem(head != null ? head : SkullType.PLAYER.get()).build());
            if (built.hasItemMeta()) {
                if (built.getItemMeta().hasDisplayName()) {
                    item.setElement(edit -> edit.setTitle(built.getItemMeta().getDisplayName()).build());
                }
                if (built.getItemMeta().hasLore()) {
                    item.setElement(edit -> edit.setLore(built.getItemMeta().getLore()).build());
                }
            }
        }
    }

    @Comment(value="Handle memory item placeholder translation on a string with a provided value")
    protected @Comment(value="Handle memory item placeholder translation on a string with a provided value") String handlePaginationReplacements(MemoryItem item, String context, T value) {
        FormattedString string = new FormattedString(context);
        for (Map.Entry<String, String> entry : item.getReplacements().entrySet()) {
            try {
                if (entry.getValue().contains(".")) {
                    String[] steps = entry.getValue().split("\\.");
                    Method method = value.getClass().getMethod(steps[0], new Class[0]);
                    Object step = method.invoke(value, new Object[0]);
                    int position = 1;
                    do {
                        method = step.getClass().getMethod(steps[position], new Class[0]);
                        step = method.invoke(step, new Object[0]);
                    } while (++position != steps.length);
                    String rep = step.toString();
                    string.replace(entry.getKey(), rep);
                    continue;
                }
                Method m = value.getClass().getMethod(entry.getValue(), new Class[0]);
                String rep = m.invoke(value, new Object[0]).toString();
                string.replace(entry.getKey(), rep);
            }
            catch (Exception ex) {
                this.plugin.getLogger().severe("Unable to resolve method name \"" + entry.getValue() + '\"' + " from class " + value.getClass().getSimpleName() + " in menu " + '\"' + this.title + '\"');
            }
        }
        return string.get();
    }

    @Override
    @NotNull
    public Docket.Type getType() {
        Docket.Type type = Docket.Type.MEMORY;
        if (type == null) {
            MemoryDocket.$$$reportNull$$$0(7);
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/github/sanctum/labyrinth/gui/unity/simple/MemoryDocket";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/github/sanctum/labyrinth/gui/unity/simple/MemoryDocket";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toMenu";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setList";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setNamePlaceholder";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDataConverter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setUniqueDataConverter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

