/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.gui.unity.impl;

import com.github.sanctum.labyrinth.formatting.UniformedComponents;
import com.github.sanctum.labyrinth.gui.unity.construct.Menu;
import com.github.sanctum.labyrinth.gui.unity.impl.BorderElement;
import com.github.sanctum.labyrinth.gui.unity.impl.FillerElement;
import com.github.sanctum.labyrinth.gui.unity.impl.InventoryElement;
import com.github.sanctum.labyrinth.gui.unity.impl.ItemElement;
import com.github.sanctum.labyrinth.library.StringUtils;
import com.github.sanctum.labyrinth.task.RenderedTask;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class MenuViewer {
    private int page;
    private Inventory inventory;
    private RenderedTask task;
    private final UUID id;
    private final InventoryElement element;

    public MenuViewer(UUID id, InventoryElement element) {
        this.element = element;
        this.page = 1;
        this.id = id;
    }

    void setTask(RenderedTask task) {
        this.task = task;
    }

    public InventoryElement getInventory() {
        return this.element;
    }

    public void setElement(Inventory inventory) {
        this.inventory = inventory;
    }

    public Inventory getElement() {
        block14: {
            Optional<Integer> i;
            Iterator<Object> filler22;
            block15: {
                Iterator iterator;
                if (this.inventory == null) {
                    int total = 0;
                    if (this.getInventory().isPaginated()) {
                        total = ((InventoryElement.Paginated)this.getInventory()).getTotalPages();
                    }
                    this.inventory = Bukkit.createInventory((InventoryHolder)Menu.Instance.of(this.element.menu, this.getPlayer().getPlayer()), (int)this.getInventory().getParent().getSize().getSize(), (String)StringUtils.use(MessageFormat.format(this.getInventory().title, this.getPage().toNumber(), total)).translate());
                }
                if (!this.getInventory().getParent().getProperties().contains((Object)Menu.Property.REFILLABLE) || UniformedComponents.accept(Arrays.asList(this.inventory.getContents())).filter(Objects::nonNull).findAny().isPresent()) break block14;
                if (!this.getInventory().isPaginated()) break block15;
                if (this.getInventory().getParent().getProperties().contains((Object)Menu.Property.LIVE_META)) break block14;
                BorderElement border = (BorderElement)this.getInventory().getElement(e -> e instanceof BorderElement);
                if (border != null) {
                    iterator = border.getAttachment().iterator();
                    while (iterator.hasNext()) {
                        ItemElement itemElement = (ItemElement)iterator.next();
                        Optional<Integer> i2 = itemElement.getSlot();
                        i2.ifPresent(integer -> this.inventory.setItem(integer.intValue(), itemElement.getElement()));
                    }
                }
                iterator = this.getPage().getAttachment().iterator();
                while (iterator.hasNext()) {
                    ItemElement itemElement = (ItemElement)iterator.next();
                    if (this.inventory.contains(itemElement.getElement())) continue;
                    this.inventory.addItem(new ItemStack[]{itemElement.getElement()});
                }
                iterator = this.getInventory().getAttachment().iterator();
                while (iterator.hasNext()) {
                    ItemElement itemElement = (ItemElement)iterator.next();
                    Optional<Integer> i2 = itemElement.getSlot();
                    i2.ifPresent(integer -> this.inventory.setItem(integer.intValue(), itemElement.getElement()));
                }
                FillerElement filler22 = (FillerElement)this.getInventory().getElement(e -> e instanceof FillerElement);
                if (filler22 != null) {
                    Iterator iterator2 = filler22.getAttachment().iterator();
                    while (iterator2.hasNext()) {
                        ItemElement el = (ItemElement)iterator2.next();
                        int slot = el.getSlot().orElse(0);
                        if (this.inventory.getItem(slot) != null) continue;
                        this.inventory.setItem(slot, el.getElement());
                    }
                }
                break block14;
            }
            BorderElement border = (BorderElement)this.getInventory().getElement(e -> e instanceof BorderElement);
            if (border != null) {
                filler22 = border.getAttachment().iterator();
                while (filler22.hasNext()) {
                    ItemElement itemElement = (ItemElement)filler22.next();
                    i = itemElement.getSlot();
                    i.ifPresent(integer -> this.inventory.setItem(integer.intValue(), element3.getElement()));
                }
            }
            for (ItemElement itemElement : this.getInventory().getContents()) {
                if (this.inventory.contains(itemElement.getElement())) continue;
                this.inventory.addItem(new ItemStack[]{itemElement.getElement()});
            }
            filler22 = this.getInventory().getAttachment().iterator();
            while (filler22.hasNext()) {
                ItemElement itemElement = (ItemElement)filler22.next();
                i = itemElement.getSlot();
                i.ifPresent(integer -> this.inventory.setItem(integer.intValue(), element3.getElement()));
            }
            FillerElement filler = (FillerElement)this.getInventory().getElement(e -> e instanceof FillerElement);
            if (filler != null) {
                Iterator iterator = filler.getAttachment().iterator();
                while (iterator.hasNext()) {
                    ItemElement el = (ItemElement)iterator.next();
                    int slot = el.getSlot().orElse(0);
                    if (this.inventory.getItem(slot) != null) continue;
                    this.inventory.setItem(slot, el.getElement());
                }
            }
        }
        return this.inventory;
    }

    public OfflinePlayer getPlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.id);
    }

    public RenderedTask getTask() {
        return this.task;
    }

    public InventoryElement.Page getPage() {
        if (this.getInventory().isPaginated()) {
            InventoryElement.Paginated i = (InventoryElement.Paginated)this.getInventory();
            return i.getPage(this.page);
        }
        return new InventoryElement.Page(1, this.getInventory());
    }

    public void setPage(int page) {
        this.page = page;
    }
}

