/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.gui.unity.impl;

import com.github.sanctum.labyrinth.gui.unity.construct.Menu;
import com.github.sanctum.labyrinth.gui.unity.impl.ClickElement;
import com.github.sanctum.labyrinth.gui.unity.impl.InventoryElement;
import com.github.sanctum.labyrinth.gui.unity.impl.ListElement;
import com.github.sanctum.labyrinth.library.Item;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemElement<V>
extends Menu.Element<ItemStack, Menu.Click> {
    private boolean slotted;
    private ControlType type;
    private int slot;
    private final V data;
    private ItemStack item;
    private InventoryElement.Page page;
    private Consumer<InventoryElement> clickGenerator;
    private Menu.Click click;
    private InventoryElement parent;
    private boolean playerAdded;

    public ItemElement() {
        this(null);
    }

    public ItemElement(V data) {
        this.data = data;
        this.setType(ControlType.DISPLAY);
    }

    public ItemElement<V> setSlot(int slot) {
        this.slot = slot;
        this.slotted = true;
        return this;
    }

    public ItemElement<V> setClick(Menu.Click click) {
        this.type = ControlType.CUSTOM;
        this.click = click;
        this.clickGenerator = e -> {
            this.click = click;
        };
        return this;
    }

    public ItemElement<V> setElement(ItemStack item) {
        this.item = new ItemStack(item);
        return this;
    }

    public ItemElement<V> setPlayerAdded(boolean playerAdded) {
        this.playerAdded = playerAdded;
        return this;
    }

    public ItemElement<V> setElement(Function<Item.Edit, ItemStack> edit) {
        Item.Edit ed = this.item != null ? new Item.Edit(this.item) : new Item.Edit(Material.DIRT);
        return this.setElement(edit.apply(ed));
    }

    public ItemElement<V> setType(ControlType type) {
        this.type = type;
        this.clickGenerator = e -> type.generateAndSetClick((InventoryElement)e, this);
        if (this.parent != null) {
            this.clickGenerator.accept(this.parent);
        }
        type.generateAndSetClick(this.parent, this);
        return this;
    }

    public ItemElement<V> setTypeAndAddAction(ControlType type, Menu.Click click) {
        this.type = type;
        this.clickGenerator = e -> {
            Menu.Click template = (Menu.Click)type.clickHandlerGenerator.apply(e);
            this.click = template == null ? click : c -> {
                template.apply(c);
                click.apply(c);
            };
        };
        if (this.parent != null) {
            this.clickGenerator.accept(this.parent);
        }
        return this;
    }

    public Optional<V> getData() {
        return Optional.ofNullable(this.data);
    }

    public Optional<Integer> getSlot() {
        return this.slotted ? Optional.of(this.slot) : Optional.empty();
    }

    public ControlType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public ItemStack getElement() {
        ItemStack itemStack = this.item;
        if (itemStack == null) {
            ItemElement.$$$reportNull$$$0(0);
        }
        return itemStack;
    }

    public boolean isPlayerAdded() {
        return this.playerAdded;
    }

    public boolean isSlotted() {
        return this.slotted;
    }

    public ItemElement<V> setParent(@NotNull InventoryElement parent) {
        if (parent == null) {
            ItemElement.$$$reportNull$$$0(1);
        }
        this.parent = parent;
        this.clickGenerator.accept(parent);
        return this;
    }

    public InventoryElement getParent() {
        return this.parent;
    }

    @Override
    public Menu.Click getAttachment() {
        return this.click;
    }

    public ItemElement<V> setPage(@NotNull InventoryElement.Page page) {
        if (page == null) {
            ItemElement.$$$reportNull$$$0(2);
        }
        this.page = page;
        return this;
    }

    public InventoryElement.Page getPage() {
        if (this.page == null && this.getParent().isPaginated()) {
            return ((InventoryElement.Paginated)this.getParent()).getPage(1);
        }
        return this.page;
    }

    public final void remove(boolean sincere) {
        this.getParent().removeItem(this, sincere);
    }

    public final void remove(Player player, boolean sincere) {
        this.getParent().removeItem(player, this, sincere);
    }

    public String getName() {
        return this.getElement().getItemMeta() != null && this.getElement().getItemMeta().hasDisplayName() ? this.getElement().getItemMeta().getDisplayName() : this.getElement().getType().name();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemElement)) {
            return false;
        }
        ItemElement that = (ItemElement)o;
        return this.isSlotted() == that.isSlotted() && this.getSlot() == that.getSlot() && this.isPlayerAdded() == that.isPlayerAdded() && this.getType() == that.getType() && Objects.equals(this.getData(), that.getData()) && this.item.equals((Object)that.item) && Objects.equals(this.getPage(), that.getPage()) && Objects.equals(this.click, that.click) && this.getParent().equals(that.getParent());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isSlotted(), this.getType(), this.getSlot(), this.getData(), this.item, this.getPage(), this.click, this.getParent(), this.isPlayerAdded()});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/github/sanctum/labyrinth/gui/unity/impl/ItemElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "page";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/github/sanctum/labyrinth/gui/unity/impl/ItemElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setParent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ControlType {
        BUTTON_BACK(ControlType::reloadInv),
        BUTTON_NEXT(ControlType::reloadInv),
        BUTTON_EXIT(i -> ControlType::close),
        DISPLAY(i -> ControlType::cancelClicks),
        TAKEAWAY(i -> null),
        ITEM_BORDER(i -> ControlType::cancelClicks),
        ITEM_FILLER(i -> ControlType::cancelClicks),
        CUSTOM(i -> null);

        private final Function<InventoryElement, Menu.Click> clickHandlerGenerator;

        private ControlType(Function<InventoryElement, Menu.Click> clickHandlerGenerator) {
            this.clickHandlerGenerator = clickHandlerGenerator;
        }

        public void generateAndSetClick(InventoryElement inventoryElement, ItemElement<?> itemElement) {
            ((ItemElement)itemElement).click = this.clickHandlerGenerator.apply(inventoryElement);
        }

        public void generateAndSetClick(InventoryElement inventoryElement, ListElement<?> listElement) {
            listElement.getAttachment().forEach(i -> i.setType(this));
        }

        private static void cancelClicks(ClickElement clickElement) {
            clickElement.setHotbarAllowed(false);
            clickElement.setCancelled(true);
        }

        private static Menu.Click reloadInv(InventoryElement inventoryElement) {
            return c -> {
                ControlType.cancelClicks(c);
                c.setConsumer((p, s) -> {
                    if (s) {
                        inventoryElement.open(p);
                    }
                });
            };
        }

        private static void close(ClickElement clickElement) {
            clickElement.getElement().closeInventory();
        }

        public static Menu.Click combine(InventoryElement inventoryElement, ControlType ... types) {
            return c -> {
                for (ControlType type : types) {
                    type.clickHandlerGenerator.apply(inventoryElement).apply(c);
                }
            };
        }
    }
}

