/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.gui.unity.impl;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.data.service.AnvilMechanics;
import com.github.sanctum.labyrinth.formatting.UniformedComponents;
import com.github.sanctum.labyrinth.gui.unity.construct.Menu;
import com.github.sanctum.labyrinth.gui.unity.impl.BorderElement;
import com.github.sanctum.labyrinth.gui.unity.impl.FillerElement;
import com.github.sanctum.labyrinth.gui.unity.impl.ItemElement;
import com.github.sanctum.labyrinth.gui.unity.impl.ListElement;
import com.github.sanctum.labyrinth.gui.unity.impl.MenuViewer;
import com.github.sanctum.labyrinth.library.Mailer;
import com.github.sanctum.labyrinth.library.StringUtils;
import com.github.sanctum.labyrinth.task.BukkitTaskPredicate;
import com.github.sanctum.labyrinth.task.TaskScheduler;
import com.github.sanctum.panther.container.ImmutablePantherMap;
import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherEntry;
import com.github.sanctum.panther.container.PantherEntryMap;
import com.github.sanctum.panther.container.PantherMap;
import com.github.sanctum.panther.container.PantherSet;
import com.github.sanctum.panther.util.AbstractPaginatedCollection;
import com.github.sanctum.panther.util.SpecialID;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InventoryElement
extends Menu.Element<Inventory, Set<ItemElement<?>>> {
    protected final Set<MenuViewer> index;
    protected final Set<ItemElement<?>> items = new HashSet();
    protected final boolean lazy;
    protected final String title;
    protected final Menu menu;
    protected Inventory inventory;
    protected int limit = 5;
    protected int page = 1;

    public InventoryElement(String title, Menu menu, boolean lazy) {
        this.menu = menu;
        this.index = new HashSet<MenuViewer>();
        this.title = title;
        this.lazy = lazy;
    }

    public synchronized void open(Player player) {
    }

    public synchronized void close(Player player) {
    }

    @Override
    public Inventory getElement() {
        block13: {
            block14: {
                Object element2;
                ListElement list;
                if (this.inventory == null) {
                    this.inventory = Bukkit.createInventory((InventoryHolder)Menu.Instance.of(this.menu), (int)this.menu.getSize().getSize(), (String)StringUtils.use(MessageFormat.format(this.title, this.page, 0)).translate());
                }
                if (!this.menu.getProperties().contains((Object)Menu.Property.REFILLABLE) || UniformedComponents.accept(Arrays.asList(this.inventory.getContents())).filter(i -> i != null).count() != 0L) break block13;
                if (!this.isPaginated()) break block14;
                BorderElement border = (BorderElement)this.getElement(e -> e instanceof BorderElement);
                if (border != null) {
                    Iterator iterator = border.getAttachment().iterator();
                    while (iterator.hasNext()) {
                        ItemElement itemElement = (ItemElement)iterator.next();
                        Optional<Integer> i3 = itemElement.getSlot();
                        i3.ifPresent(integer -> this.inventory.setItem(integer.intValue(), itemElement.getElement()));
                    }
                }
                if ((list = (ListElement)this.getElement(e -> e instanceof ListElement)) == null) {
                    return this.inventory;
                }
                for (ItemElement element3 : AbstractPaginatedCollection.of(this.getContents()).limit(list.getLimit()).sort(list.comparator).filter(list.predicate).get(this.page)) {
                    if (this.inventory.contains(element3.getElement())) continue;
                    this.inventory.addItem(new ItemStack[]{element3.getElement()});
                }
                for (Object element2 : this.items) {
                    Optional<Integer> i4 = ((ItemElement)element2).getSlot();
                    i4.ifPresent(integer -> this.inventory.setItem(integer.intValue(), element3.getElement()));
                }
                FillerElement fillerElement = (FillerElement)this.getElement(e -> e instanceof FillerElement);
                if (fillerElement == null) break block13;
                element2 = fillerElement.getAttachment().iterator();
                while (element2.hasNext()) {
                    ItemElement el = (ItemElement)element2.next();
                    int slot = el.getSlot().orElse(0);
                    if (this.inventory.getItem(slot) != null) continue;
                    this.inventory.setItem(slot, el.getElement());
                }
                break block13;
            }
            BorderElement border = (BorderElement)this.getElement(e -> e instanceof BorderElement);
            if (border != null) {
                Iterator<Object> list = border.getAttachment().iterator();
                while (list.hasNext()) {
                    ItemElement itemElement = (ItemElement)list.next();
                    Optional<Integer> i2 = itemElement.getSlot();
                    i2.ifPresent(integer -> this.inventory.setItem(integer.intValue(), element.getElement()));
                }
            }
            for (ItemElement itemElement : this.getContents()) {
                if (this.inventory.contains(itemElement.getElement())) continue;
                this.inventory.addItem(new ItemStack[]{itemElement.getElement()});
            }
            for (ItemElement itemElement : this.items) {
                Optional<Integer> i2 = itemElement.getSlot();
                i2.ifPresent(integer -> this.inventory.setItem(integer.intValue(), element.getElement()));
            }
            FillerElement filler = (FillerElement)this.getElement(e -> e instanceof FillerElement);
            if (filler != null) {
                Iterator iterator = filler.getAttachment().iterator();
                while (iterator.hasNext()) {
                    ItemElement el = (ItemElement)iterator.next();
                    int slot = el.getSlot().orElse(0);
                    if (this.inventory.getItem(slot) != null) continue;
                    this.inventory.setItem(slot, el.getElement());
                }
            }
        }
        return this.inventory;
    }

    public InventoryElement setContents(Iterable<ItemElement<?>> elements) {
        this.items.clear();
        elements.forEach(this::addItem);
        return this;
    }

    public MenuViewer getViewer(Player player) {
        MenuViewer pl = this.index.stream().filter(p -> player.getName().equals(p.getPlayer().getName())).findFirst().orElse(null);
        if (pl == null) {
            pl = new MenuViewer(player.getUniqueId(), this);
            this.index.add(pl);
        }
        return pl;
    }

    public Set<ItemElement<?>> getContents() {
        ListElement list;
        HashSet items = new HashSet();
        for (ItemElement<?> it : this.items) {
            if (it.getSlot().isPresent() || it.isPlayerAdded()) continue;
            items.add(it);
        }
        if (this.isPaginated() && (list = (ListElement)this.getElement(e -> e instanceof ListElement)) != null) {
            items.addAll((Collection<ItemElement<?>>)list.getAttachment());
        }
        return items;
    }

    @Override
    public Set<ItemElement<?>> getAttachment() {
        return this.items;
    }

    @NotNull
    public String getTitle() {
        String string = this.title;
        if (string == null) {
            InventoryElement.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public Menu getParent() {
        Menu menu = this.menu;
        if (menu == null) {
            InventoryElement.$$$reportNull$$$0(1);
        }
        return menu;
    }

    @Nullable
    public ItemElement<?> getItem(Predicate<ItemElement<?>> item) {
        ListElement list = (ListElement)this.getElement(e -> e instanceof ListElement);
        BorderElement border = (BorderElement)this.getElement(e -> e instanceof BorderElement);
        FillerElement filler = (FillerElement)this.getElement(e -> e instanceof FillerElement);
        if (this.isAnimated()) {
            Animated animated = (Animated)this;
            for (Slide s : animated.getSlides()) {
                for (ItemElement i : s.getAttachment().values()) {
                    if (!item.test(i)) continue;
                    return i;
                }
            }
        }
        if (this.isPaginated()) {
            return this.items.stream().filter(item).findFirst().orElse(list == null ? null : (ItemElement)list.getAttachment().stream().filter(item).findFirst().orElse(border == null ? null : (ItemElement)border.getAttachment().stream().filter(item).findFirst().orElse(filler == null ? null : (ItemElement)filler.getAttachment().stream().filter(item).findFirst().orElse(null))));
        }
        return this.items.stream().filter(item).findFirst().orElse(border == null ? null : (ItemElement)border.getAttachment().stream().filter(item).findFirst().orElse(filler == null ? null : (ItemElement)filler.getAttachment().stream().filter(item).findFirst().orElse(null)));
    }

    @Nullable
    public ItemElement<?> getItem(ItemStack item) {
        boolean check;
        ListElement list = (ListElement)this.getElement(e -> e instanceof ListElement);
        BorderElement border = (BorderElement)this.getElement(e -> e instanceof BorderElement);
        FillerElement filler = (FillerElement)this.getElement(e -> e instanceof FillerElement);
        boolean bl = check = this.getParent().getProperties().contains((Object)Menu.Property.LIVE_META) || this.getParent().getProperties().contains((Object)Menu.Property.ANIMATED);
        if (this.isAnimated()) {
            Animated animated = (Animated)this;
            for (Slide s : animated.getSlides()) {
                for (ItemElement i2 : s.getAttachment().values()) {
                    if (!this.isSimilar(i2.getElement(), item)) continue;
                    return i2;
                }
            }
        }
        return this.items.stream().filter(i -> {
            if (check) {
                return this.isSimilar(item, i.getElement());
            }
            return i.getElement().isSimilar(item);
        }).findFirst().orElse(list == null ? null : (ItemElement)list.getAttachment().stream().filter(i -> {
            if (check) {
                return this.isSimilar(item, i.getElement());
            }
            return i.getElement().isSimilar(item);
        }).findFirst().orElse(border == null ? null : (ItemElement)border.getAttachment().stream().filter(i -> i.getElement().isSimilar(item)).findFirst().orElse(filler == null ? null : (ItemElement)filler.getAttachment().stream().filter(i -> {
            if (check) {
                return this.isSimilar(item, i.getElement());
            }
            return i.getElement().isSimilar(item);
        }).findFirst().orElse(null))));
    }

    @Nullable
    public ItemElement<?> getItem(int slot) {
        ItemElement it;
        Iterator iterator;
        Iterator iterator2 = this.getAttachment().iterator();
        while (iterator2.hasNext()) {
            ItemElement it2 = (ItemElement)iterator2.next();
            if (!it2.getSlot().map(s -> s == slot).orElse(false).booleanValue()) continue;
            return it2;
        }
        if (this.isAnimated()) {
            Animated inv = (Animated)this;
            for (Slide s2 : inv.getSlides()) {
                for (ItemElement item : s2.getAttachment().values()) {
                    if (!item.getSlot().isPresent() || item.getSlot().get() != slot) continue;
                    return item;
                }
            }
        }
        BorderElement border = (BorderElement)this.getElement(e -> e instanceof BorderElement);
        FillerElement filler = (FillerElement)this.getElement(e -> e instanceof FillerElement);
        if (border != null) {
            iterator = border.getAttachment().iterator();
            while (iterator.hasNext()) {
                it = (ItemElement)iterator.next();
                if (!it.getSlot().map(s -> s == slot).orElse(false).booleanValue()) continue;
                return it;
            }
        }
        if (filler != null) {
            iterator = filler.getAttachment().iterator();
            while (iterator.hasNext()) {
                it = (ItemElement)iterator.next();
                if (!it.getSlot().map(s -> s == slot).orElse(false).booleanValue()) continue;
                return it;
            }
        }
        return null;
    }

    public boolean contains(ItemStack item) {
        Animated inv;
        ListElement list = (ListElement)this.getElement(e -> e instanceof ListElement);
        if (this.isAnimated() && (inv = (Animated)this).getSlides().stream().anyMatch(s -> s.getAttachment().values().stream().anyMatch(it -> this.isSimilar(it.getElement(), item)))) {
            return true;
        }
        return this.items.stream().map(ItemElement::getElement).anyMatch(i -> {
            if (this.getParent().getProperties().contains((Object)Menu.Property.LIVE_META)) {
                return this.isSimilar(item, (ItemStack)i);
            }
            return i.isSimilar(item);
        }) || list != null && list.getAttachment().stream().map(ItemElement::getElement).anyMatch(i -> {
            if (this.getParent().getProperties().contains((Object)Menu.Property.LIVE_META)) {
                return this.isSimilar(item, (ItemStack)i);
            }
            return i.isSimilar(item);
        });
    }

    public boolean isSimilar(@Nullable ItemStack stack, @Nullable ItemStack stack2) {
        if (stack == null) {
            return false;
        }
        if (stack == stack2) {
            return true;
        }
        Material comparisonType = stack2.getType().isLegacy() ? Bukkit.getUnsafe().fromLegacy(stack2.getData(), true) : stack2.getType();
        return comparisonType == stack.getType() && stack2.getDurability() == stack.getDurability() && stack2.hasItemMeta() == stack.hasItemMeta() && Objects.equals(stack2.getItemMeta().getDisplayName(), stack.getItemMeta().getDisplayName());
    }

    public InventoryElement setElement(Inventory inventory) {
        this.inventory = inventory;
        return this;
    }

    public <R> InventoryElement removeItem(ItemElement<R> item, boolean sincere) {
        this.items.remove(item);
        if (sincere) {
            this.getElement().remove(item.getElement());
        }
        return this;
    }

    public <R> InventoryElement removeItem(Player target, ItemElement<R> item, boolean sincere) {
        this.items.remove(item);
        if (sincere) {
            this.getViewer(target).getElement().remove(item.getElement());
        }
        return this;
    }

    public <R> InventoryElement addItem(ItemElement<R> item) {
        this.items.add(item.setParent(this));
        return this;
    }

    public <R> InventoryElement addItem(BorderElement<R> element) {
        this.addElement(element);
        return this;
    }

    public <R> InventoryElement addItem(FillerElement<R> element) {
        this.addElement(element);
        return this;
    }

    public InventoryElement addItem(ItemStack ... itemStacks) {
        for (ItemStack i : itemStacks) {
            if (i == null || i.getType() == Material.AIR) continue;
            this.addItem(new ItemElement().setElement(i));
        }
        return this;
    }

    public InventoryElement addItem(ItemElement<?> ... elements) {
        for (ItemElement<?> e : elements) {
            this.addItem((ItemElement)e);
        }
        return this;
    }

    public InventoryElement addItem(ListElement<?> element) {
        this.addElement(element.setParent(this));
        this.limit = element.getLimit();
        return this;
    }

    public InventoryElement addItem(Consumer<ItemElement<?>> builder) {
        ItemElement element = new ItemElement();
        builder.accept(element);
        return this.addItem(element);
    }

    public <R> InventoryElement addItem(Consumer<ItemElement<R>> builder, R value) {
        ItemElement<R> element = new ItemElement<R>(value);
        builder.accept(element);
        return this.addItem(element);
    }

    public boolean isPaginated() {
        return this instanceof Paginated;
    }

    public boolean isAnimated() {
        return this instanceof Animated;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/github/sanctum/labyrinth/gui/unity/impl/InventoryElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class Animated
    extends InventoryElement {
        private final PantherMap<Integer, Slide> slides = new PantherEntryMap<Integer, Slide>();
        private BukkitTaskPredicate<?>[] predicates = new BukkitTaskPredicate[0];
        private long repeat;

        public Animated(String title, Menu menu) {
            super(title, menu, true);
        }

        public Animated addItem(Slide element) {
            this.slides.put(this.slides.size(), element);
            return this;
        }

        public Animated setRepeat(long repeat) {
            this.repeat = repeat;
            return this;
        }

        public Animated setPredicates(BukkitTaskPredicate<?> ... predicates) {
            this.predicates = predicates;
            return this;
        }

        public long getRepeat() {
            return this.repeat;
        }

        public PantherCollection<Slide> getSlides() {
            return this.slides.values();
        }

        @Override
        public synchronized void close(Player player) {
            player.closeInventory();
        }

        @Override
        public synchronized void open(Player player) {
            TaskScheduler.of(() -> this.slides.stream().sorted(Comparator.comparingInt(PantherEntry::getKey)).forEach(entry -> TaskScheduler.of(() -> {
                Optional<Integer> in;
                this.getElement().clear();
                BorderElement border = (BorderElement)this.getElement(e -> e instanceof BorderElement);
                if (border != null) {
                    Iterator<Object> iterator = border.getAttachment().iterator();
                    while (iterator.hasNext()) {
                        ItemElement iterator2 = (ItemElement)iterator.next();
                        Optional<Integer> i = iterator2.getSlot();
                        i.ifPresent(integer -> this.inventory.setItem(integer.intValue(), element.getElement()));
                    }
                }
                for (ItemElement itemElement : this.getContents()) {
                    in = itemElement.getSlot();
                    if (in.isPresent()) {
                        this.getElement().setItem(in.get().intValue(), itemElement.getElement());
                        continue;
                    }
                    if (this.getElement().contains(itemElement.getElement())) continue;
                    this.getElement().addItem(new ItemStack[]{itemElement.getElement()});
                }
                for (ItemElement itemElement : this.items) {
                    in = itemElement.getSlot();
                    in.ifPresent(integer -> this.getElement().setItem(integer.intValue(), element.getElement()));
                }
                FillerElement filler = (FillerElement)this.getElement(e -> e instanceof FillerElement);
                if (filler != null) {
                    Iterator iterator = filler.getAttachment().iterator();
                    while (iterator.hasNext()) {
                        ItemElement el = (ItemElement)iterator.next();
                        int slot = el.getSlot().orElse(0);
                        if (this.getElement().getItem(slot) != null) continue;
                        this.getElement().setItem(slot, el.getElement());
                    }
                }
                ((Slide)entry.getValue()).getAttachment().forEach(entry2 -> this.getElement().setItem(((Integer)entry2.getKey()).intValue(), ((ItemElement)entry2.getValue()).getElement()));
            }).scheduleLater(((Slide)entry.getValue()).changeInterval))).scheduleTimerAsync("Labyrinth:" + this.getParent().hashCode() + ";slide-" + player.getUniqueId(), 0L, this.getRepeat(), this.predicates).next(() -> player.openInventory(this.getElement())).scheduleLater(2L);
        }
    }

    public static class Slide
    extends Menu.Element<InventoryElement, PantherMap<Integer, ItemElement<?>>> {
        private final PantherMap<Integer, ItemElement<?>> items = new PantherEntryMap();
        private final InventoryElement parent;
        private long changeInterval;

        public Slide(InventoryElement parent) {
            this.parent = parent;
        }

        public Slide set(int slot, ItemElement<?> itemElement) throws IndexOutOfBoundsException {
            if (slot >= this.parent.inventory.getSize() || slot < 0) {
                throw new IndexOutOfBoundsException("Cannot modify item element beyond natural scope.");
            }
            this.items.put(slot, itemElement.setSlot(slot).setParent(this.parent));
            return this;
        }

        public Slide setNextDelay(long changeInterval) {
            this.changeInterval = changeInterval;
            return this;
        }

        public long getChangeInterval() {
            return this.changeInterval;
        }

        @Override
        public InventoryElement getElement() {
            return this.parent;
        }

        @Override
        public PantherMap<Integer, ItemElement<?>> getAttachment() {
            return ImmutablePantherMap.of(this.items);
        }
    }

    public static class Paginated
    extends InventoryElement {
        public Paginated(String title, Menu menu) {
            super(title, menu, true);
        }

        public Paginated setGlobalSlot(int page) {
            this.page = page;
            return this;
        }

        public Page getPage(int page) {
            if (this.getElement(e -> e instanceof Page && ((Page)e).toNumber() == page) != null) {
                return (Page)this.getElement(e -> e instanceof Page && ((Page)e).toNumber() == page);
            }
            Page p = new Page(page, this);
            this.addElement(p);
            return p;
        }

        public Set<Page> getAllPages() {
            HashSet<Page> set = new HashSet<Page>();
            for (int i = 1; i < this.getTotalPages() + 1; ++i) {
                set.add(this.getPage(i));
            }
            return set;
        }

        public Page getGlobalSlot() {
            return this.getPage(this.page);
        }

        public int getTotalPages() {
            int totalPageCount = 1;
            if (this.getContents().size() % this.limit == 0) {
                if (this.getContents().size() > 0) {
                    totalPageCount = this.getContents().size() / this.limit;
                }
            } else {
                totalPageCount = this.getContents().size() / this.limit + 1;
            }
            return totalPageCount;
        }

        @Override
        public synchronized void close(Player player) {
            player.closeInventory();
        }

        @Override
        public synchronized void open(Player player) {
            MenuViewer viewer = this.getViewer(player);
            if (this.lazy) {
                viewer.setElement(null);
            }
            if (this.menu.getProperties().contains((Object)Menu.Property.LIVE_META)) {
                viewer.getElement().setMaxStackSize(1);
                if (viewer.getTask() != null) {
                    viewer.getTask().getTask().cancel();
                }
                viewer.setTask(TaskScheduler.of(() -> {
                    ItemElement element2;
                    Iterator iterator;
                    viewer.getElement().clear();
                    BorderElement border = (BorderElement)this.getElement(e -> e instanceof BorderElement);
                    if (border != null) {
                        iterator = border.getAttachment().iterator();
                        while (iterator.hasNext()) {
                            element2 = (ItemElement)iterator.next();
                            Optional<Integer> i = element2.getSlot();
                            i.ifPresent(integer -> viewer.getElement().setItem(integer.intValue(), element2.getElement()));
                        }
                    }
                    iterator = viewer.getPage().getAttachment().iterator();
                    while (iterator.hasNext()) {
                        element2 = (ItemElement)iterator.next();
                        if (viewer.getElement().contains(element2.getElement())) continue;
                        viewer.getElement().addItem(new ItemStack[]{element2.getElement()});
                    }
                    for (ItemElement element2 : this.items) {
                        Optional<Integer> in = element2.getSlot();
                        in.ifPresent(integer -> viewer.getElement().setItem(integer.intValue(), element2.getElement()));
                    }
                    FillerElement filler = (FillerElement)this.getElement(e -> e instanceof FillerElement);
                    if (filler != null) {
                        Iterator iterator2 = filler.getAttachment().iterator();
                        while (iterator2.hasNext()) {
                            ItemElement el = (ItemElement)iterator2.next();
                            int slot = el.getSlot().orElse(0);
                            if (viewer.getElement().getItem(slot) != null) continue;
                            viewer.getElement().setItem(slot, el.getElement());
                        }
                    }
                }).scheduleTimer("Unity:" + SpecialID.builder().setLength(12).build(this) + ":" + player.getUniqueId(), 0L, 60L));
                TaskScheduler.of(() -> player.openInventory(viewer.getElement())).schedule();
            } else {
                Iterator iterator = viewer.getPage().getAttachment().iterator();
                while (iterator.hasNext()) {
                    ItemElement element = (ItemElement)iterator.next();
                    if (viewer.getElement().contains(element.getElement())) continue;
                    viewer.getElement().addItem(new ItemStack[]{element.getElement()});
                }
                for (ItemElement element : this.items) {
                    Optional<Integer> in = element.getSlot();
                    in.ifPresent(integer -> viewer.getElement().setItem(integer.intValue(), element.getElement()));
                }
                player.openInventory(viewer.getElement());
            }
        }
    }

    public static class Printable
    extends InventoryElement {
        private final AnvilMechanics nms;
        private int containerId;
        private final PantherCollection<Player> visible = new PantherSet<Player>();

        public Printable(String title, AnvilMechanics mechanics, Menu menu) {
            super(StringUtils.use(title).translate(), menu, true);
            this.nms = mechanics;
        }

        public boolean isVisible(Player player) {
            return this.visible.contains(player);
        }

        @Override
        public synchronized void close(Player player) {
            this.close(player, true);
        }

        public void close(Player player, boolean sendPacket) {
            if (this.nms == null || !this.visible.contains(player)) {
                return;
            }
            this.visible.remove(player);
            if (sendPacket) {
                this.nms.handleInventoryCloseEvent(player);
            }
            this.nms.setActiveContainerDefault(player);
            this.nms.sendPacketCloseWindow(player, this.containerId);
        }

        @Override
        public void open(Player player) {
            if (this.nms == null) {
                Mailer mailer = Mailer.empty((CommandSender)player).prefix().start("&7[").middle("&2&lLabyrinth").end("&7]").finish();
                String reason = LabyrinthProvider.getInstance().isModded() ? "Modded Environment" : "Unknown";
                mailer.chat("&c&lAn internal matter has prevented you from accessing this menu.").deploy(m -> {
                    if (player.isOp()) {
                        mailer.chat("&eReason: &f" + reason).queue();
                    }
                });
                player.closeInventory();
                return;
            }
            this.nms.handleInventoryCloseEvent(player);
            this.nms.setActiveContainerDefault(player);
            Object container = this.nms.newContainerAnvil(player, this.getTitle());
            this.setElement(this.nms.toBukkitInventory(container));
            Iterator iterator = this.getAttachment().iterator();
            while (iterator.hasNext()) {
                ItemElement it = (ItemElement)iterator.next();
                if (!it.getSlot().isPresent()) continue;
                int slot = it.getSlot().get();
                if (slot == 0) {
                    this.getElement().setItem(0, it.getElement());
                }
                if (slot == 1) {
                    this.getElement().setItem(1, it.getElement());
                }
                if (slot != 2) continue;
                this.getElement().setItem(2, it.getElement());
            }
            this.containerId = this.nms.getNextContainerId(player, container);
            this.nms.sendPacketOpenWindow(player, this.containerId, this.getTitle());
            this.nms.setActiveContainer(player, container);
            this.nms.setActiveContainerId(container, this.containerId);
            this.nms.addActiveContainerSlotListener(container, player);
            this.visible.add(player);
        }
    }

    public static class Normal
    extends InventoryElement {
        public Normal(String title, Menu menu) {
            super(title, menu, true);
        }

        @Override
        public synchronized void close(Player player) {
            player.closeInventory();
        }

        @Override
        public synchronized void open(Player player) {
            MenuViewer viewer = this.getViewer(player);
            if (this.lazy && this.getParent().getProperties().contains((Object)Menu.Property.RECURSIVE)) {
                this.inventory = Bukkit.createInventory((InventoryHolder)Menu.Instance.of(this.menu), (int)this.menu.getSize().getSize(), (String)StringUtils.use(MessageFormat.format(this.title, this.page, 0)).translate());
                viewer.setElement(null);
            }
            if (this.menu.getProperties().contains((Object)Menu.Property.LIVE_META)) {
                if (viewer.getTask() != null) {
                    viewer.getTask().getTask().cancel();
                }
                viewer.getElement().setMaxStackSize(1);
                viewer.setTask(TaskScheduler.of(() -> {
                    Optional<Integer> in;
                    viewer.getElement().clear();
                    BorderElement border = (BorderElement)this.getElement(e -> e instanceof BorderElement);
                    if (border != null) {
                        Iterator<Object> iterator = border.getAttachment().iterator();
                        while (iterator.hasNext()) {
                            ItemElement iterator2 = (ItemElement)iterator.next();
                            Optional<Integer> i = iterator2.getSlot();
                            i.ifPresent(integer -> viewer.getElement().setItem(integer.intValue(), element.getElement()));
                        }
                    }
                    for (ItemElement itemElement : this.getContents()) {
                        in = itemElement.getSlot();
                        if (in.isPresent()) {
                            viewer.getElement().setItem(in.get().intValue(), itemElement.getElement());
                            continue;
                        }
                        if (viewer.getElement().contains(itemElement.getElement())) continue;
                        viewer.getElement().addItem(new ItemStack[]{itemElement.getElement()});
                    }
                    for (ItemElement itemElement : this.items) {
                        in = itemElement.getSlot();
                        in.ifPresent(integer -> viewer.getElement().setItem(integer.intValue(), element.getElement()));
                    }
                    FillerElement filler = (FillerElement)this.getElement(e -> e instanceof FillerElement);
                    if (filler != null) {
                        Iterator iterator = filler.getAttachment().iterator();
                        while (iterator.hasNext()) {
                            ItemElement el = (ItemElement)iterator.next();
                            int slot = el.getSlot().orElse(0);
                            if (viewer.getElement().getItem(slot) != null) continue;
                            viewer.getElement().setItem(slot, el.getElement());
                        }
                    }
                }).scheduleTimer("Unity:" + SpecialID.builder().setLength(12).build(this) + ":" + player.getUniqueId(), 0L, 1L));
            } else {
                Optional<Integer> in;
                BorderElement border = (BorderElement)this.getElement(e -> e instanceof BorderElement);
                if (border != null) {
                    Iterator<Object> iterator = border.getAttachment().iterator();
                    while (iterator.hasNext()) {
                        ItemElement iterator2 = (ItemElement)iterator.next();
                        Optional<Integer> i = iterator2.getSlot();
                        i.ifPresent(integer -> viewer.getElement().setItem(integer.intValue(), element.getElement()));
                    }
                }
                for (ItemElement itemElement : this.getContents()) {
                    in = itemElement.getSlot();
                    if (in.isPresent()) {
                        viewer.getElement().setItem(in.get().intValue(), itemElement.getElement());
                        continue;
                    }
                    if (viewer.getElement().contains(itemElement.getElement())) continue;
                    viewer.getElement().addItem(new ItemStack[]{itemElement.getElement()});
                }
                for (ItemElement itemElement : this.items) {
                    in = itemElement.getSlot();
                    in.ifPresent(integer -> viewer.getElement().setItem(integer.intValue(), element.getElement()));
                }
                FillerElement filler = (FillerElement)this.getElement(e -> e instanceof FillerElement);
                if (filler != null) {
                    Iterator iterator = filler.getAttachment().iterator();
                    while (iterator.hasNext()) {
                        ItemElement el = (ItemElement)iterator.next();
                        int slot = el.getSlot().orElse(0);
                        if (viewer.getElement().getItem(slot) != null) continue;
                        viewer.getElement().setItem(slot, el.getElement());
                    }
                }
            }
            player.openInventory(viewer.getElement());
        }
    }

    public static class Shared
    extends Normal {
        private final Set<Player> viewers = new HashSet<Player>();

        public Shared(String title, Menu menu) {
            super(title, menu);
        }

        public Set<Player> getViewers() {
            return this.viewers;
        }

        @Override
        public synchronized void close(Player player) {
            player.closeInventory();
        }

        @Override
        public synchronized void open(Player player) {
            Optional<Integer> in;
            this.viewers.add(player);
            MenuViewer viewer = this.getViewer(player);
            if (this.lazy && this.getParent().getProperties().contains((Object)Menu.Property.RECURSIVE)) {
                this.inventory = Bukkit.createInventory((InventoryHolder)Menu.Instance.of(this.menu), (int)this.menu.getSize().getSize(), (String)StringUtils.use(MessageFormat.format(this.title, this.page, 0)).translate());
            }
            if (this.menu.getProperties().contains((Object)Menu.Property.ANIMATED)) {
                return;
            }
            if (this.menu.getProperties().contains((Object)Menu.Property.LIVE_META)) {
                if (viewer.getTask() != null) {
                    viewer.getTask().getTask().cancel();
                }
                this.getElement().setMaxStackSize(1);
                if (this.getViewers().stream().map(this::getViewer).noneMatch(m -> m.getTask() != null)) {
                    viewer.setTask(TaskScheduler.of(() -> {
                        Optional<Integer> in;
                        this.getElement().clear();
                        BorderElement border = (BorderElement)this.getElement(e -> e instanceof BorderElement);
                        if (border != null) {
                            Iterator<Object> iterator = border.getAttachment().iterator();
                            while (iterator.hasNext()) {
                                ItemElement iterator2 = (ItemElement)iterator.next();
                                Optional<Integer> i = iterator2.getSlot();
                                i.ifPresent(integer -> this.inventory.setItem(integer.intValue(), element.getElement()));
                            }
                        }
                        for (ItemElement itemElement : this.getContents()) {
                            in = itemElement.getSlot();
                            if (in.isPresent()) {
                                this.getElement().setItem(in.get().intValue(), itemElement.getElement());
                                continue;
                            }
                            if (this.getElement().contains(itemElement.getElement())) continue;
                            this.getElement().addItem(new ItemStack[]{itemElement.getElement()});
                        }
                        for (ItemElement itemElement : this.items) {
                            in = itemElement.getSlot();
                            in.ifPresent(integer -> this.getElement().setItem(integer.intValue(), element.getElement()));
                        }
                        FillerElement filler = (FillerElement)this.getElement(e -> e instanceof FillerElement);
                        if (filler != null) {
                            Iterator iterator = filler.getAttachment().iterator();
                            while (iterator.hasNext()) {
                                ItemElement el = (ItemElement)iterator.next();
                                int slot = el.getSlot().orElse(0);
                                if (this.getElement().getItem(slot) != null) continue;
                                this.getElement().setItem(slot, el.getElement());
                            }
                        }
                    }).scheduleTimer("Unity:" + SpecialID.builder().setLength(12).build(this) + ":" + player.getUniqueId(), 0L, 1L));
                }
                TaskScheduler.of(() -> {
                    Shared inv = this;
                    for (Player p : inv.getViewers()) {
                        if (p.equals(player)) {
                            p.openInventory(this.getElement());
                            continue;
                        }
                        inv.open(player);
                    }
                }).scheduleLater(2L);
                return;
            }
            BorderElement border = (BorderElement)this.getElement(e -> e instanceof BorderElement);
            if (border != null) {
                Iterator<Object> iterator = border.getAttachment().iterator();
                while (iterator.hasNext()) {
                    ItemElement iterator2 = (ItemElement)iterator.next();
                    Optional<Integer> i = iterator2.getSlot();
                    i.ifPresent(integer -> this.inventory.setItem(integer.intValue(), element.getElement()));
                }
            }
            for (ItemElement itemElement : this.getContents()) {
                in = itemElement.getSlot();
                if (in.isPresent()) {
                    this.getElement().setItem(in.get().intValue(), itemElement.getElement());
                    continue;
                }
                if (this.getElement().contains(itemElement.getElement())) continue;
                this.getElement().addItem(new ItemStack[]{itemElement.getElement()});
            }
            for (ItemElement itemElement : this.items) {
                in = itemElement.getSlot();
                in.ifPresent(integer -> this.getElement().setItem(integer.intValue(), element.getElement()));
            }
            FillerElement filler = (FillerElement)this.getElement(e -> e instanceof FillerElement);
            if (filler != null) {
                Iterator iterator = filler.getAttachment().iterator();
                while (iterator.hasNext()) {
                    ItemElement el = (ItemElement)iterator.next();
                    int slot = el.getSlot().orElse(0);
                    if (this.getElement().getItem(slot) != null) continue;
                    this.getElement().setItem(slot, el.getElement());
                }
            }
            player.openInventory(this.getElement());
            for (Player p : this.viewers) {
                if (this.getElement() == null || p.getOpenInventory().getTopInventory().equals(this.getElement())) continue;
                TaskScheduler.of(() -> this.viewers.remove(p)).scheduleLater(1L);
            }
        }
    }

    public static class SharedPaginated
    extends Paginated {
        private final Set<Player> viewers = new HashSet<Player>();

        public SharedPaginated(String title, Menu menu) {
            super(title, menu);
        }

        public Set<Player> getViewers() {
            return this.viewers;
        }

        @Override
        public synchronized void close(Player player) {
            player.closeInventory();
        }

        @Override
        public synchronized void open(Player player) {
            this.viewers.add(player);
            MenuViewer viewer = this.getViewer(player);
            if (this.lazy) {
                this.inventory = Bukkit.createInventory((InventoryHolder)Menu.Instance.of(this.menu), (int)this.menu.getSize().getSize(), (String)StringUtils.use(MessageFormat.format(this.title, this.page, this.getTotalPages())).translate());
            }
            if (this.menu.getProperties().contains((Object)Menu.Property.LIVE_META)) {
                this.getElement().setMaxStackSize(1);
                if (viewer.getTask() != null) {
                    viewer.getTask().getTask().cancel();
                }
                if (this.getViewers().stream().map(this::getViewer).noneMatch(m -> m.getTask() != null)) {
                    viewer.setTask(TaskScheduler.of(() -> {
                        this.getElement().clear();
                        Iterator iterator = this.getGlobalSlot().getAttachment().iterator();
                        while (iterator.hasNext()) {
                            ItemElement element = (ItemElement)iterator.next();
                            if (this.getElement().contains(element.getElement())) continue;
                            this.getElement().addItem(new ItemStack[]{element.getElement()});
                        }
                        for (ItemElement element : this.items) {
                            Optional<Integer> in = element.getSlot();
                            in.ifPresent(integer -> this.getElement().setItem(integer.intValue(), element.getElement()));
                        }
                    }).scheduleTimer("Unity:" + SpecialID.builder().setLength(12).build(this) + ":" + player.getUniqueId(), 0L, 60L));
                }
                TaskScheduler.of(() -> {
                    SharedPaginated inv = this;
                    for (Player p : inv.getViewers()) {
                        if (p.equals(player)) {
                            TaskScheduler.of(() -> player.openInventory(this.getElement())).schedule();
                            continue;
                        }
                        inv.open(p);
                    }
                }).scheduleLater(2L);
            } else {
                Iterator iterator = this.getGlobalSlot().getAttachment().iterator();
                while (iterator.hasNext()) {
                    ItemElement element = (ItemElement)iterator.next();
                    if (this.getElement().contains(element.getElement())) continue;
                    this.getElement().addItem(new ItemStack[]{element.getElement()});
                }
                for (ItemElement element : this.items) {
                    Optional<Integer> in = element.getSlot();
                    in.ifPresent(integer -> this.getElement().setItem(integer.intValue(), element.getElement()));
                }
                player.openInventory(this.getElement());
            }
        }
    }

    public static class Page
    extends Menu.Element<InventoryElement, Set<ItemElement<?>>> {
        private final InventoryElement element;
        private final int num;
        private boolean full;

        public Page(int num, InventoryElement inventory) {
            this.element = inventory;
            this.num = num;
        }

        public boolean isFull() {
            return this.full;
        }

        public int toNumber() {
            return this.num;
        }

        @Override
        public InventoryElement getElement() {
            return this.element;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Page)) {
                return false;
            }
            Page page = (Page)o;
            return this.num == page.num && this.getElement().equals(page.getElement());
        }

        public int hashCode() {
            return Objects.hash(this.getElement(), this.num);
        }

        @Override
        public Set<ItemElement<?>> getAttachment() {
            ListElement list = (ListElement)this.element.getElement(e -> e instanceof ListElement);
            if (list == null) {
                return new HashSet();
            }
            Set set = StreamSupport.stream(AbstractPaginatedCollection.of(this.element.getContents()).limit(list.getLimit()).sort(list.comparator).get(this.toNumber()).spliterator(), false).sorted(list.comparator).collect(Collectors.toCollection(LinkedHashSet::new));
            Iterator iterator = this.getElement().getAttachment().iterator();
            while (iterator.hasNext()) {
                ItemElement extra = (ItemElement)iterator.next();
                if (set.contains(extra) || !extra.isPlayerAdded() || extra.getPage().toNumber() != this.toNumber()) continue;
                set.add(extra);
            }
            if (set.size() >= list.getLimit()) {
                this.full = true;
            }
            return set;
        }
    }
}

